/*
 * Decompiled with CFR 0.152.
 */
package org.joml;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.text.NumberFormat;
import org.joml.Math;
import org.joml.Vector2ic;
import org.joml.Vector3ic;
import org.joml.Vector4ic;
import org.joml.internal.MemUtil;
import org.joml.internal.Options;
import org.joml.internal.Runtime;

public class Vector4i
implements Externalizable,
Vector4ic {
    private static final long serialVersionUID = 1L;
    public int x;
    public int y;
    public int z;
    public int w;

    public Vector4i() {
        this.w = 1;
    }

    public Vector4i(Vector4ic v) {
        if (v instanceof Vector4i) {
            MemUtil.INSTANCE.copy((Vector4i)v, this);
        } else {
            this.x = v.x();
            this.y = v.y();
            this.z = v.z();
            this.w = v.w();
        }
    }

    public Vector4i(Vector3ic v, int w) {
        this(v.x(), v.y(), v.z(), w);
    }

    public Vector4i(Vector2ic v, int z, int w) {
        this(v.x(), v.y(), z, w);
    }

    public Vector4i(int s) {
        MemUtil.INSTANCE.broadcast(s, this);
    }

    public Vector4i(int x, int y, int z, int w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    public Vector4i(ByteBuffer buffer) {
        this(buffer.position(), buffer);
    }

    public Vector4i(int index, ByteBuffer buffer) {
        MemUtil.INSTANCE.get(this, index, buffer);
    }

    public Vector4i(IntBuffer buffer) {
        this(buffer.position(), buffer);
    }

    public Vector4i(int index, IntBuffer buffer) {
        MemUtil.INSTANCE.get(this, index, buffer);
    }

    private Vector4i thisOrNew() {
        return this;
    }

    public int x() {
        return this.x;
    }

    public int y() {
        return this.y;
    }

    public int z() {
        return this.z;
    }

    public int w() {
        return this.w;
    }

    public Vector4i set(Vector4ic v) {
        if (v instanceof Vector4i) {
            MemUtil.INSTANCE.copy((Vector4i)v, this);
        } else {
            this.x = v.x();
            this.y = v.y();
            this.z = v.z();
            this.w = v.w();
        }
        return this;
    }

    public Vector4i set(Vector3ic v, int w) {
        return this.set(v.x(), v.y(), v.z(), w);
    }

    public Vector4i set(Vector2ic v, int z, int w) {
        return this.set(v.x(), v.y(), z, w);
    }

    public Vector4i set(int s) {
        MemUtil.INSTANCE.broadcast(s, this);
        return this;
    }

    public Vector4i set(int x, int y, int z, int w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
        return this;
    }

    public Vector4i set(ByteBuffer buffer) {
        return this.set(buffer.position(), buffer);
    }

    public Vector4i set(int index, ByteBuffer buffer) {
        MemUtil.INSTANCE.get(this, index, buffer);
        return this;
    }

    public Vector4i set(IntBuffer buffer) {
        return this.set(buffer.position(), buffer);
    }

    public Vector4i set(int index, IntBuffer buffer) {
        MemUtil.INSTANCE.get(this, index, buffer);
        return this;
    }

    public Vector4i setFromAddress(long address) {
        if (Options.NO_UNSAFE) {
            throw new UnsupportedOperationException("Not supported when using joml.nounsafe");
        }
        MemUtil.MemUtilUnsafe unsafe = (MemUtil.MemUtilUnsafe)MemUtil.INSTANCE;
        unsafe.get(this, address);
        return this;
    }

    public int get(int component) throws IllegalArgumentException {
        switch (component) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
            case 2: {
                return this.z;
            }
            case 3: {
                return this.w;
            }
        }
        throw new IllegalArgumentException();
    }

    public Vector4i setComponent(int component, int value) throws IllegalArgumentException {
        switch (component) {
            case 0: {
                this.x = value;
                break;
            }
            case 1: {
                this.y = value;
                break;
            }
            case 2: {
                this.z = value;
                break;
            }
            case 3: {
                this.w = value;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return this;
    }

    public IntBuffer get(IntBuffer buffer) {
        return this.get(buffer.position(), buffer);
    }

    public IntBuffer get(int index, IntBuffer buffer) {
        MemUtil.INSTANCE.put(this, index, buffer);
        return buffer;
    }

    public ByteBuffer get(ByteBuffer buffer) {
        return this.get(buffer.position(), buffer);
    }

    public ByteBuffer get(int index, ByteBuffer buffer) {
        MemUtil.INSTANCE.put(this, index, buffer);
        return buffer;
    }

    public Vector4ic getToAddress(long address) {
        if (Options.NO_UNSAFE) {
            throw new UnsupportedOperationException("Not supported when using joml.nounsafe");
        }
        MemUtil.MemUtilUnsafe unsafe = (MemUtil.MemUtilUnsafe)MemUtil.INSTANCE;
        unsafe.put(this, address);
        return this;
    }

    public Vector4i sub(Vector4ic v) {
        return this.sub(v, this.thisOrNew());
    }

    public Vector4i sub(int x, int y, int z, int w) {
        return this.sub(x, y, z, w, this.thisOrNew());
    }

    public Vector4i sub(Vector4ic v, Vector4i dest) {
        return this.sub(v.x(), v.y(), v.z(), v.w(), dest);
    }

    public Vector4i sub(int x, int y, int z, int w, Vector4i dest) {
        dest.x = this.x - x;
        dest.y = this.y - y;
        dest.z = this.z - z;
        dest.w = this.w - w;
        return dest;
    }

    public Vector4i add(Vector4ic v) {
        return this.add(v, this.thisOrNew());
    }

    public Vector4i add(Vector4ic v, Vector4i dest) {
        return this.add(v.x(), v.y(), v.z(), v.w(), dest);
    }

    public Vector4i add(int x, int y, int z, int w) {
        return this.add(x, y, z, w, this.thisOrNew());
    }

    public Vector4i add(int x, int y, int z, int w, Vector4i dest) {
        dest.x = this.x + x;
        dest.y = this.y + y;
        dest.z = this.z + z;
        dest.w = this.w + w;
        return dest;
    }

    public Vector4i mul(Vector4ic v) {
        return this.mul(v, this.thisOrNew());
    }

    public Vector4i mul(Vector4ic v, Vector4i dest) {
        dest.x = this.x * v.x();
        dest.y = this.y * v.y();
        dest.z = this.z * v.z();
        dest.w = this.w * v.w();
        return dest;
    }

    public Vector4i div(Vector4ic v) {
        return this.div(v, this.thisOrNew());
    }

    public Vector4i div(Vector4ic v, Vector4i dest) {
        dest.x = this.x / v.x();
        dest.y = this.y / v.y();
        dest.z = this.z / v.z();
        dest.w = this.w / v.w();
        return dest;
    }

    public Vector4i mul(int scalar) {
        return this.mul(scalar, this.thisOrNew());
    }

    public Vector4i mul(int scalar, Vector4i dest) {
        dest.x = this.x * scalar;
        dest.y = this.y * scalar;
        dest.z = this.z * scalar;
        dest.w = this.w * scalar;
        return dest;
    }

    public Vector4i div(int scalar) {
        return this.div(scalar, this.thisOrNew());
    }

    public Vector4i div(float scalar, Vector4i dest) {
        dest.x = (int)((float)this.x / scalar);
        dest.y = (int)((float)this.y / scalar);
        dest.z = (int)((float)this.z / scalar);
        dest.w = (int)((float)this.w / scalar);
        return dest;
    }

    public long lengthSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w;
    }

    public double length() {
        return Math.sqrt(this.lengthSquared());
    }

    public double distance(Vector4ic v) {
        return this.distance(v.x(), v.y(), v.z(), v.w());
    }

    public double distance(int x, int y, int z, int w) {
        return Math.sqrt(this.distanceSquared(x, y, z, w));
    }

    public int distanceSquared(Vector4ic v) {
        return this.distanceSquared(v.x(), v.y(), v.z(), v.w());
    }

    public int distanceSquared(int x, int y, int z, int w) {
        int dx = this.x - x;
        int dy = this.y - y;
        int dz = this.z - z;
        int dw = this.w - w;
        return dx * dx + dy * dy + dz * dz + dw * dw;
    }

    public int dot(Vector4ic v) {
        return this.x * v.x() + this.y * v.y() + this.z * v.z() + this.w * v.w();
    }

    public Vector4i zero() {
        Vector4i dest = this.thisOrNew();
        MemUtil.INSTANCE.zero(dest);
        return dest;
    }

    public Vector4i negate() {
        return this.negate(this.thisOrNew());
    }

    public Vector4i negate(Vector4i dest) {
        dest.x = -this.x;
        dest.y = -this.y;
        dest.z = -this.z;
        dest.w = -this.w;
        return dest;
    }

    public String toString() {
        return Runtime.formatNumbers(this.toString(Options.NUMBER_FORMAT));
    }

    public String toString(NumberFormat formatter) {
        return "(" + formatter.format(this.x) + " " + formatter.format(this.y) + " " + formatter.format(this.z) + " " + formatter.format(this.w) + ")";
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.x);
        out.writeInt(this.y);
        out.writeInt(this.z);
        out.writeInt(this.w);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.x = in.readInt();
        this.y = in.readInt();
        this.z = in.readInt();
        this.w = in.readInt();
    }

    public Vector4i min(Vector4ic v) {
        return this.min(v, this.thisOrNew());
    }

    public Vector4i min(Vector4ic v, Vector4i dest) {
        dest.x = this.x < v.x() ? this.x : v.x();
        dest.y = this.y < v.y() ? this.y : v.y();
        dest.z = this.z < v.z() ? this.z : v.z();
        dest.w = this.w < v.w() ? this.w : v.w();
        return this;
    }

    public Vector4i max(Vector4ic v) {
        return this.max(v, this.thisOrNew());
    }

    public Vector4i max(Vector4ic v, Vector4i dest) {
        dest.x = this.x > v.x() ? this.x : v.x();
        dest.y = this.y > v.y() ? this.y : v.y();
        dest.z = this.z > v.z() ? this.z : v.z();
        dest.w = this.w > v.w() ? this.w : v.w();
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.x;
        result = 31 * result + this.y;
        result = 31 * result + this.z;
        result = 31 * result + this.w;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Vector4i other = (Vector4i)obj;
        if (this.x != other.x) {
            return false;
        }
        if (this.y != other.y) {
            return false;
        }
        if (this.z != other.z) {
            return false;
        }
        return this.w == other.w;
    }
}

