/*
 * Decompiled with CFR 0.152.
 */
package game;

import engine.EnigUtils;
import engine.OpenGL.Texture;
import game.Entity;
import game.Main;
import game.Projectile;
import game.UserControls;
import java.util.ArrayList;
import org.joml.Vector2f;

public class Player
extends Entity {
    public ArrayList<Projectile> projectiles = new ArrayList();
    private Texture[] animFrames;
    float energy = 1.0f;
    float hp = 1.0f;

    public Player() {
        this.position = new Vector2f(0.0f, 25.0f);
        this.animFrames = new Texture[2];
        this.animFrames[0] = new Texture("res/player/frame1.png");
        this.animFrames[1] = new Texture("res/player/frame2.png");
    }

    public void reset() {
        this.energy = 1.0f;
        this.hp = 1.0f;
        this.position.x = 0.0f;
        this.position.y = 25.0f;
        this.velocity.x = 0.0f;
        this.velocity.y = 0.0f;
    }

    public void render(float time) {
        this.animFrames[(int)(time % 0.2f / 0.1f)].bind();
        Player.entityProgram.shaders[0].uniforms[0].set(Main.getptpm().translate(this.position.x, this.position.y, 0.0f));
        entityVAO.drawTriangles();
    }

    @Override
    public void updatePosition(float time) {
        if (Main.player.position.y > 50.0f) {
            Main.player.velocity.y -= 50.0f * time;
        }
        if (Main.player.position.y > 80.0f) {
            Main.player.velocity.y = 0.0f;
            Main.player.position.y = 80.0f;
        }
        if (UserControls.up(Main.window)) {
            this.velocity.y += 80.0f * time;
        }
        if (UserControls.down(Main.window)) {
            this.velocity.y -= 80.0f * time;
        }
        if (UserControls.left(Main.window)) {
            this.velocity.x -= 120.0f * time;
        }
        if (UserControls.right(Main.window)) {
            this.velocity.x += 120.0f * time;
        }
        if (this.velocity.x > 10.0f) {
            this.velocity.x -= 10.0f * time;
        }
        if (this.velocity.y < 10.0f) {
            this.velocity.y += 10.0f * -time;
        }
        if (Main.player.velocity.x > 0.0f) {
            Main.player.velocity.x -= 20.0f * -time;
            if (Main.player.velocity.x < 0.0f) {
                Main.player.velocity.x = 0.0f;
            }
        }
        if (Main.player.velocity.x < 0.0f) {
            Main.player.velocity.x += 20.0f * -time;
            if (Main.player.velocity.x > 0.0f) {
                Main.player.velocity.x = 0.0f;
            }
        }
        Main.player.velocity.x = EnigUtils.clamp(Main.player.velocity.x, -50.0f, 50.0f);
        super.updatePosition(time);
        this.projectiles(time);
        Main.player.hp += 0.05f * -time;
        if (Main.player.hp > 1.0f) {
            Main.player.hp = 1.0f;
        }
        if (Main.player.position.x < Main.gameView.wallPosition) {
            Main.player.hp = (float)((double)Main.player.hp - 0.2 * (double)(-time));
            Main.player.energy = (float)((double)Main.player.energy + 0.4 * (double)(-time));
        }
    }

    public void projectiles(float time) {
        float xposEquivalent = Main.window.cursorXFloat * 50.0f * Main.window.getAspectRatio() + Main.cameraPos.x;
        float yposEquavalent = Main.window.cursorYFloat * 50.0f + Main.cameraPos.y;
        this.energy += 0.25f * -time;
        if (this.energy > 1.0f) {
            this.energy = 1.0f;
        }
        if (Main.window.mouseButtons[0] == 1 && (double)this.energy > 0.3) {
            this.energy -= 0.3f;
            Vector2f impulse = new Vector2f(Main.player.position.x - xposEquivalent, Main.player.position.y - yposEquavalent);
            impulse.normalize();
            impulse.mul(100.0f);
            this.projectiles.add(new Projectile(this.position.x, this.position.y, impulse.x + this.velocity.x, impulse.y + this.velocity.y));
            this.velocity.y -= impulse.y / 4.0f;
            this.velocity.x -= impulse.x / 2.0f;
        }
        for (int i = 0; i < this.projectiles.size(); ++i) {
            Projectile p = this.projectiles.get(i);
            if (p.position.y < 0.0f || p.position.y - this.position.y > 200.0f || p.position.x - this.position.x < -200.0f || p.position.x - this.position.x > 300.0f) {
                this.projectiles.remove(i);
                continue;
            }
            p.updatePosition(time);
            p.render();
        }
    }
}

