/*
 * Decompiled with CFR 0.152.
 */
package game;

import engine.EnigView;
import engine.OpenGL.EnigWindow;
import engine.OpenGL.FBO;
import engine.OpenGL.ShaderProgram;
import engine.OpenGL.Texture;
import engine.OpenGL.VAO;
import game.Enemy;
import game.Entity;
import game.Main;
import game.NumberRenderer;
import game.UserControls;
import java.util.ArrayList;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.lwjgl.opengl.GL11;

public class GameView
extends EnigView {
    private VAO floorVAO;
    private ShaderProgram floorShader;
    private ShaderProgram skyShader;
    private ShaderProgram wallShader;
    private ShaderProgram statusShader;
    private Texture floorTexture;
    private Texture skyTexture;
    private Texture hpTexture;
    private Texture mpTexture;
    private VAO hpVAO;
    private VAO mpVAO;
    private NumberRenderer scoreRenderer;
    private float wallVelocity = 40.0f;
    public float wallPosition = -100.0f;
    public int score = 0;
    public ArrayList<Enemy> enemies = new ArrayList();

    public GameView(EnigWindow swindow) {
        super(swindow);
        this.floorVAO = new VAO(-1.0f, -1.0f, 2.0f, 1.0f);
        this.floorShader = new ShaderProgram("floorShader");
        this.skyShader = new ShaderProgram("skyShader");
        this.wallShader = new ShaderProgram("wallShader");
        this.statusShader = new ShaderProgram("statusShader");
        this.floorTexture = new Texture("res/floor.png");
        this.skyTexture = new Texture("res/sky.png");
        this.hpTexture = new Texture("res/statusBars/hpBar.png");
        this.mpTexture = new Texture("res/statusBars/mpBar.png");
        this.hpTexture.bind();
        GL11.glTexParameteri(3553, 10242, 33071);
        GL11.glTexParameteri(3553, 10243, 33071);
        this.mpTexture.bind();
        GL11.glTexParameteri(3553, 10242, 33071);
        GL11.glTexParameteri(3553, 10243, 33071);
        this.hpVAO = new VAO(-1.0f, 0.75f, 1.0f / this.window.getAspectRatio(), 0.25f);
        this.mpVAO = new VAO(1.0f - 1.0f / this.window.getAspectRatio(), 0.75f, 1.0f / this.window.getAspectRatio(), 0.25f);
        this.scoreRenderer = new NumberRenderer();
        this.scoreRenderer.scale = 0.1f;
        this.scoreRenderer.xPos = 10.0f;
        this.scoreRenderer.yPos = -9.0f;
        this.scoreRenderer.color = new Vector3f(1.0f, 1.0f, 1.0f);
        Main.audio.startSong();
    }

    @Override
    public boolean loop() {
        Main.mainFrameBuffer.prepareForTexture();
        if (Main.player.hp > 0.0f) {
            this.updateCamera();
        } else {
            if (Main.player.position.x > -25.0f) {
                Main.audio.playEnd();
            }
            Main.player.position.x = -50.0f;
            Main.player.hp = -50.0f;
        }
        this.renderBackground();
        this.updateEntities();
        this.renderScene();
        if (Main.player.hp > 0.0f) {
            this.renderStatus();
        }
        this.scoreRenderer.render(this.score);
        FBO.prepareDefaultRender();
        Main.fboShader.enable();
        Main.mainFrameBuffer.getBoundTexture().bind();
        Main.screenVAO.fullRender();
        if (Main.player.hp < 0.0f && this.wallPosition - Main.cameraPos.x > 50.0f * this.window.getAspectRatio()) {
            Main.pauseView.runLoop(Main.mainFrameBuffer.getBoundTexture());
            if (Main.pauseView.buttonPressed == 1) {
                return true;
            }
            this.reset();
            this.frameStartTime = (float)System.nanoTime() / 1.0E9f;
        }
        for (int i : UserControls.quit) {
            if (this.window.keys[i] != 1) continue;
            this.window.keys[i] = 2;
            Main.pauseView.runLoop(Main.mainFrameBuffer.getBoundTexture());
            if (Main.pauseView.buttonPressed == 1) {
                return true;
            }
            this.frameStartTime = (float)System.nanoTime() / 1.0E9f;
            break;
        }
        return false;
    }

    public void reset() {
        this.enemies = new ArrayList();
        this.score = 0;
        this.wallVelocity = 40.0f;
        this.wallPosition = -100.0f;
        Main.player.reset();
        Main.audio.startSong();
    }

    public void renderStatus() {
        this.statusShader.enable();
        this.statusShader.shaders[2].uniforms[0].set(Main.player.hp);
        this.hpTexture.bind();
        this.hpVAO.fullRender();
        this.statusShader.shaders[2].uniforms[0].set(Main.player.energy);
        this.mpTexture.bind();
        this.mpVAO.fullRender();
    }

    public void updateCamera() {
        Main.cameraPos.x = Main.player.position.x;
        if (Main.cameraPos.y < 30.0f) {
            Main.cameraPos.y = 30.0f;
        }
    }

    public void renderBackground() {
        this.skyShader.enable();
        this.skyShader.shaders[0].uniforms[0].set(Main.cameraPos);
        this.skyShader.shaders[0].uniforms[1].set(2.0f / this.window.getAspectRatio());
        this.skyTexture.bind();
        Main.screenVAO.fullRender();
    }

    public void updateEntities() {
        if (Main.player.position.x > this.wallPosition && this.enemies.size() < 10) {
            double advantage = Main.player.position.x - this.wallPosition;
            this.score += (int)(advantage * (double)(-this.deltaTime));
            if (advantage < 100.0) {
                double thresh = (double)(-this.deltaTime) * 0.06 * (10.0 - (double)this.enemies.size());
                if (Math.random() < thresh) {
                    this.enemies.add(new Enemy());
                }
            } else {
                double max = 5.0 + advantage / 5.0;
                double thresh = (double)(-this.deltaTime) * 0.05 * (max - (double)this.enemies.size());
                if (Math.random() < thresh) {
                    this.enemies.add(new Enemy());
                }
            }
        }
        Entity.entityVAO.prepareRender();
        Entity.entityProgram.enable();
        Main.player.render(this.frameStartTime);
        Main.player.updatePosition(this.deltaTime);
        Enemy.enemyShader.enable();
        for (int i = 0; i < this.enemies.size(); ++i) {
            Enemy e = this.enemies.get(i);
            e.updatePosition(this.deltaTime);
            e.render(this.frameStartTime);
            Vector2f vector2f = new Vector2f();
            if (e.position.sub(Main.player.position, vector2f).lengthSquared() < 25.0f) {
                if (Main.player.velocity.x < 50.0f) {
                    Main.player.velocity.x = 50.0f;
                }
                Main.player.hp = (float)((double)Main.player.hp - 0.02);
            }
            if (!(e.position.x + 5.0f < this.wallPosition)) continue;
            if (e.taggedTimer < -0.5f) {
                this.wallVelocity += 500.0f / this.wallVelocity;
            }
            this.enemies.remove(i);
        }
        Entity.entityVAO.unbind();
    }

    public void renderScene() {
        this.floorShader.enable();
        this.floorTexture.bind();
        this.floorShader.shaders[0].uniforms[0].set(new Vector2f(Main.cameraPos.x / 50.0f, Main.cameraPos.y / 50.0f));
        this.floorShader.shaders[0].uniforms[1].set(this.window.getAspectRatio());
        this.floorVAO.fullRender();
        this.wallPosition += this.wallVelocity * -this.deltaTime;
        if (this.wallVelocity > 40.0f) {
            this.wallVelocity -= 15.0f * -this.deltaTime;
        }
        this.wallShader.enable();
        this.wallShader.shaders[0].uniforms[0].set(Main.cameraPos);
        this.wallShader.shaders[0].uniforms[1].set(this.window.getAspectRatio());
        this.wallShader.shaders[2].uniforms[0].set((Main.cameraPos.x - this.wallPosition) / 100.0f);
        Main.screenVAO.fullRender();
    }
}

