/*
 * Decompiled with CFR 0.152.
 */
package game;

import engine.OpenGL.ShaderProgram;
import engine.OpenGL.Texture;
import game.Entity;
import game.Main;
import game.Projectile;
import org.lwjgl.opengl.GL11;

public class Enemy
extends Entity {
    private static Texture[] frames = new Texture[4];
    public static ShaderProgram enemyShader;
    float taggedTimer = -1.0f;
    private float animFrameOffset;

    public Enemy() {
        this.position.x = Main.player.position.x + 100.0f;
        this.position.y = (float)Math.random() * 80.0f;
        this.velocity.x = 20.0f;
        this.animFrameOffset = (float)Math.random();
    }

    public static void setFrames() {
        Enemy.frames[0] = new Texture("res/enemy/frame1.png");
        frames[0].bind();
        GL11.glTexParameteri(3553, 10242, 33071);
        GL11.glTexParameteri(3553, 10243, 33071);
        Enemy.frames[1] = new Texture("res/enemy/frame2.png");
        frames[1].bind();
        GL11.glTexParameteri(3553, 10242, 33071);
        GL11.glTexParameteri(3553, 10243, 33071);
        Enemy.frames[2] = new Texture("res/enemy/frame3.png");
        frames[2].bind();
        GL11.glTexParameteri(3553, 10242, 33071);
        GL11.glTexParameteri(3553, 10243, 33071);
        Enemy.frames[3] = new Texture("res/enemy/frame4.png");
        frames[3].bind();
        GL11.glTexParameteri(3553, 10242, 33071);
        GL11.glTexParameteri(3553, 10243, 33071);
        enemyShader = new ShaderProgram("enemyShaders");
    }

    @Override
    public void updatePosition(float time) {
        this.velocity.x += (20.0f - this.velocity.x) * 0.1f;
        float ydiff = Main.player.position.y - this.position.y;
        if (ydiff > 0.0f) {
            this.velocity.y += 60.0f * time;
        }
        if (this.taggedTimer > -0.5f) {
            this.taggedTimer -= time * 10.0f;
        }
        for (int i = 0; i < Main.player.projectiles.size(); ++i) {
            Projectile proj = Main.player.projectiles.get(i);
            float xdist = proj.position.x - this.position.x;
            float ydist = proj.position.y - this.position.y;
            if (!(xdist * xdist + ydist * ydist < 20.0f)) continue;
            Main.audio.playContact();
            Main.gameView.score += 100;
            this.taggedTimer = 0.0f;
            this.velocity.add(proj.velocity);
            Main.player.projectiles.remove(i);
        }
        super.updatePosition(time);
    }

    public void render(float time) {
        int animFrame = (int)((time + this.animFrameOffset) % 0.2f / 0.1f);
        if (this.taggedTimer > -0.5f) {
            animFrame += 2;
        }
        frames[animFrame].bind();
        Enemy.enemyShader.shaders[0].uniforms[0].set(Main.getptpm().translate(this.position.x, this.position.y, 0.0f));
        if (this.taggedTimer > -0.5f) {
            Enemy.enemyShader.shaders[2].uniforms[0].set(this.taggedTimer * this.taggedTimer);
        } else {
            Enemy.enemyShader.shaders[2].uniforms[0].set(-1.0f);
        }
        entityVAO.drawTriangles();
    }
}

