/*
 * Decompiled with CFR 0.152.
 */
package game;

import engine.OpenGL.ShaderProgram;
import engine.OpenGL.Texture;
import engine.OpenGL.VAO;
import game.Main;

public class Button {
    private static ShaderProgram shader;
    private static VAO vao;
    private Texture texture;
    private float height;
    private float hoverTimer;

    public Button(String path, float height) {
        this.texture = new Texture(path);
        this.height = height;
    }

    public void reset() {
        this.hoverTimer = 0.0f;
    }

    public static void setStatics() {
        shader = new ShaderProgram("buttonShader");
        vao = new VAO(-0.5f, -0.125f, 1.0f, 0.25f);
    }

    public boolean render(float frameStart) {
        boolean ret = false;
        if ((double)(Main.window.cursorYFloat - this.height) > -0.125 && (double)(Main.window.cursorYFloat - this.height) < 0.125 && Main.window.cursorXFloat * Main.window.getAspectRatio() > -0.5f && Main.window.cursorXFloat * Main.window.getAspectRatio() < 0.5f) {
            this.hoverTimer = (float)((double)this.hoverTimer + 0.75);
            if (Main.window.mouseButtons[0] == 1) {
                ret = true;
            }
        }
        this.hoverTimer = (float)((double)this.hoverTimer - 0.375);
        if (this.hoverTimer < 0.0f) {
            this.hoverTimer = 0.0f;
        }
        if (this.hoverTimer > 11.0f) {
            this.hoverTimer = 11.0f;
        }
        shader.enable();
        Button.shader.shaders[0].uniforms[0].set(this.height);
        Button.shader.shaders[0].uniforms[1].set(1.0f / Main.window.getAspectRatio());
        Button.shader.shaders[2].uniforms[0].set(this.hoverTimer);
        float theBrit = Math.abs(0.25f - frameStart % 5.0f / 10.0f);
        Button.shader.shaders[2].uniforms[1].set(theBrit);
        this.texture.bind();
        vao.fullRender();
        return ret;
    }
}

