/*
 * Decompiled with CFR 0.152.
 */
package game;

import engine.OpenAL.Sound;
import engine.OpenAL.SoundSource;

public class Audio {
    private Sound song;
    private Sound blast;
    private Sound endingChime;
    private Sound menuMusic;
    private SoundSource player;
    private SoundSource[] blastSources = new SoundSource[5];
    private Sound[] contacts = new Sound[5];
    private int blastIndex = 0;

    public Audio() {
        int i;
        for (i = 0; i < 5; ++i) {
            this.contacts[i] = new Sound("res/sfx/hit" + (i + 1) + ".wav");
        }
        this.song = new Sound("res/sfx/song.wav");
        this.blast = new Sound("res/sfx/blast.wav");
        this.endingChime = new Sound("res/sfx/end.wav");
        this.menuMusic = new Sound("res/sfx/menu.wav");
        this.player = new SoundSource();
        for (i = 0; i < 5; ++i) {
            this.blastSources[i] = new SoundSource();
        }
    }

    public void startSong() {
        this.player.stop();
        this.player.setLoop();
        this.player.playSound(this.song);
    }

    public void stopPlaying() {
        this.player.pause();
    }

    public void playBlast() {
        this.blastSources[this.blastIndex].setPitch((float)Math.random() * 0.2f + 0.9f);
        this.blastSources[this.blastIndex].playSound(this.blast);
        ++this.blastIndex;
        if (this.blastIndex == 5) {
            this.blastIndex = 0;
        }
    }

    public void playContact() {
        this.blastSources[this.blastIndex].setPitch(2.0f);
        this.blastSources[this.blastIndex].playSound(this.contacts[(int)(Math.random() * 5.0)]);
        ++this.blastIndex;
        if (this.blastIndex == 5) {
            this.blastIndex = 0;
        }
    }

    public void playEnd() {
        this.player.stop();
        this.player.setNoLoop();
        this.player.playSound(this.endingChime);
    }

    public void playMenu() {
        this.player.stop();
        this.player.setLoop();
        this.player.playSound(this.menuMusic);
    }
}

