/*
 * Decompiled with CFR 0.152.
 */
package engine.Platform;

import engine.EnigUtils;
import engine.OpenGL.VAO;
import engine.Platform.Simplex2v3d;
import org.joml.Vector2f;
import org.joml.Vector3f;

public abstract class PlatformSegment {
    public Vector2f getOffset(float xPos, float zPos, float xVelocity, float zVelocity) {
        Simplex2v3d tangentPlane = this.getTangentPlane(xPos, zPos);
        Vector3f unscaledOffset = new Vector3f(xVelocity, tangentPlane.gety(xVelocity, zVelocity), zVelocity);
        unscaledOffset.y -= tangentPlane.gety(0.0f, 0.0f);
        Vector3f fullVector = EnigUtils.resizeVector(unscaledOffset, (float)Math.sqrt(xVelocity * xVelocity + zVelocity * zVelocity));
        Vector2f ret = new Vector2f(fullVector.x, fullVector.z);
        return ret;
    }

    public Vector2f getOffset(Vector2f pos, Vector2f velocity) {
        return this.getOffset(pos.x, pos.y, velocity.x, velocity.y);
    }

    public Vector2f getOffset(float posx, float posy, Vector2f velocity) {
        return this.getOffset(posx, posy, velocity.x, velocity.y);
    }

    public Vector2f getOffset(Vector2f pos, float xvelocity, float yvelocity) {
        return this.getOffset(pos.x, pos.y, xvelocity, yvelocity);
    }

    public abstract float getHeight(float var1, float var2);

    public float getHeight(Vector2f pos) {
        return this.getHeight(pos.x, pos.y);
    }

    public abstract Simplex2v3d getTangentPlane(float var1, float var2);

    public Simplex2v3d getTangentPlane(Vector2f pos) {
        return this.getTangentPlane(pos.x, pos.y);
    }

    public VAO getSurfaceModel(float minx, float maxx, float minz, float maxz, int pointsX, int pointsZ) {
        float[] xVals = new float[pointsX * pointsZ];
        float[] yVals = new float[pointsX * pointsZ];
        float[] zVals = new float[pointsX * pointsZ];
        int pointNum = 0;
        float xRange = maxx - minx;
        float zRange = maxz - minz;
        float xSegment = xRange / ((float)pointsX - 1.0f);
        float zSegment = zRange / ((float)pointsZ - 1.0f);
        for (int x = 0; x < pointsX; ++x) {
            for (int y = 0; y < pointsZ; ++y) {
                float yPos = minz + (float)y * zSegment;
                xVals[pointNum] = minx + (float)x * xSegment;
                zVals[pointNum] = minz + (float)y * zSegment;
                yVals[pointNum] = this.getHeight(xVals[pointNum], zVals[pointNum]);
                ++pointNum;
            }
        }
        float[] combined = new float[3 * pointsX * pointsZ];
        int[] indices = new int[6 * (pointsX - 1) * (pointsX - 1)];
        int indNum = 0;
        for (int i = 0; i < xVals.length; ++i) {
            combined[3 * i] = xVals[i];
            combined[3 * i + 1] = yVals[i];
            combined[3 * i + 2] = zVals[i];
            if ((i + 1) % pointsX == 0 || indNum >= indices.length) continue;
            indices[indNum] = i;
            indices[++indNum] = i + 1;
            indices[++indNum] = pointsX + i;
            indices[++indNum] = i + 1;
            indices[++indNum] = pointsX + i + 1;
            indices[++indNum] = pointsX + i;
            ++indNum;
        }
        return new VAO(combined, indices, 3);
    }

    public VAO getSurfaceModel(Vector2f a, Vector2f b, int pointsX, int pointsZ) {
        return this.getSurfaceModel(Math.min(a.x, b.x), Math.max(a.x, b.x), Math.min(a.y, b.y), Math.max(a.y, b.y), pointsX, pointsZ);
    }
}

