/*
 * Decompiled with CFR 0.152.
 */
package engine.Platform;

import engine.OpenGL.ShaderProgram;
import engine.OpenGL.VAO;
import engine.Platform.Box2d;
import engine.Platform.PlatformSegment;
import engine.Platform.Simplex2v2d;
import engine.Platform.Simplex2v3d;
import java.util.ArrayList;
import org.joml.Vector3f;

public class ModelPlatform
extends PlatformSegment {
    private VAO object;
    private Simplex2v2d[] triangles;
    private Simplex2v3d[] planes;
    private Box2d range;
    private ArrayList<Integer>[][] sections;
    private Simplex2v3d defaultPlane = new Simplex2v3d(0.0f, 0.0f, new Vector3f(0.0f, 0.0f, 0.0f));

    public ModelPlatform(String path, float minX, float maxX, float minZ, float maxZ, int xSteps, int zSteps) {
        this.range = new Box2d(minX, minZ, maxX, maxZ);
        this.object = new VAO(path);
        this.init(minX, maxX, minZ, maxZ, xSteps, zSteps);
    }

    public ModelPlatform(VAO vao, float minX, float maxX, float minZ, float maxZ, int xSteps, int zSteps) {
        this.range = new Box2d(minX, minZ, maxX, maxZ);
        this.object = vao;
        this.init(minX, maxX, minZ, maxZ, xSteps, zSteps);
    }

    public ModelPlatform(String path, int xSteps, int zSteps) {
        this.object = new VAO(path);
        float minX = this.object.boundingBox.minx;
        float minZ = this.object.boundingBox.minz;
        float maxX = this.object.boundingBox.maxx;
        float maxZ = this.object.boundingBox.maxz;
        this.range = new Box2d(minX, minZ, maxX, maxZ);
        this.init(minX, maxX, minZ, maxZ, xSteps, zSteps);
    }

    public ModelPlatform(VAO vao, int xSteps, int zSteps) {
        this.object = vao;
        float minX = this.object.boundingBox.minx;
        float minZ = this.object.boundingBox.minz;
        float maxX = this.object.boundingBox.maxx;
        float maxZ = this.object.boundingBox.maxz;
        this.range = new Box2d(minX, minZ, maxX, maxZ);
        this.init(minX, maxX, minZ, maxZ, xSteps, zSteps);
    }

    public ModelPlatform(String path) {
        this.object = new VAO(path);
        float minX = this.object.boundingBox.minx;
        float minZ = this.object.boundingBox.minz;
        float maxX = this.object.boundingBox.maxx;
        float maxZ = this.object.boundingBox.maxz;
        this.range = new Box2d(minX, minZ, maxX, maxZ);
        float density = (float)this.object.getIndices().length / 3.0f;
        this.init(minX, maxX, minZ, maxZ, (int)Math.sqrt(density * (maxX - minX) / (maxZ - minZ)), (int)Math.sqrt(density * (maxZ - minZ) / (maxX - minX)));
    }

    public ModelPlatform(VAO vao) {
        this.object = vao;
        float minX = this.object.boundingBox.minx;
        float minZ = this.object.boundingBox.minz;
        float maxX = this.object.boundingBox.maxx;
        float maxZ = this.object.boundingBox.maxz;
        this.range = new Box2d(minX, minZ, maxX, maxZ);
        float density = (float)this.object.getIndices().length / 3.0f;
        this.init(minX, maxX, minZ, maxZ, (int)Math.sqrt(density * (maxX - minX) / (maxZ - minZ)), (int)Math.sqrt(density * (maxZ - minZ) / (maxX - minX)));
    }

    public ModelPlatform(String path, float minX, float maxX, float minZ, float maxZ) {
        this.object = new VAO(path);
        this.range = new Box2d(minX, minZ, maxX, maxZ);
        float density = (float)this.object.getIndices().length / 3.0f;
        this.init(minX, maxX, minZ, maxZ, (int)Math.sqrt(density * (maxX - minX) / (maxZ - minZ)), (int)Math.sqrt(density * (maxZ - minZ) / (maxX - minX)));
    }

    public ModelPlatform(VAO vao, float minX, float maxX, float minZ, float maxZ) {
        this.object = vao;
        this.range = new Box2d(minX, minZ, maxX, maxZ);
        float density = (float)this.object.getIndices().length / 3.0f;
        this.init(minX, maxX, minZ, maxZ, (int)Math.sqrt(density * (maxX - minX) / (maxZ - minZ)), (int)Math.sqrt(density * (maxZ - minZ) / (maxX - minX)));
    }

    private void init(float minX, float maxX, float minZ, float maxZ, int xSteps, int ySteps) {
        float[] vertexInfo = this.object.vbos[0].getData();
        int[] indices = this.object.getIndices();
        this.triangles = new Simplex2v2d[indices.length / 3];
        this.planes = new Simplex2v3d[indices.length / 3];
        for (int i = 0; i < indices.length; i += 3) {
            int vertA = indices[i];
            int vertB = indices[i + 1];
            int vertC = indices[i + 2];
            this.triangles[i / 3] = new Simplex2v2d(vertexInfo[vertA * 3], vertexInfo[vertA * 3 + 2], vertexInfo[vertB * 3], vertexInfo[vertB * 3 + 2], vertexInfo[vertC * 3], vertexInfo[vertC * 3 + 2]);
            this.planes[i / 3] = new Simplex2v3d(vertexInfo[vertA * 3], vertexInfo[vertA * 3 + 1], vertexInfo[vertA * 3 + 2], vertexInfo[vertB * 3], vertexInfo[vertB * 3 + 1], vertexInfo[vertB * 3 + 2], vertexInfo[vertC * 3], vertexInfo[vertC * 3 + 1], vertexInfo[vertC * 3 + 2]);
        }
        float xRange = maxX - minX;
        float yRange = maxZ - minZ;
        float xWidth = xRange / (float)xSteps;
        float yWidth = yRange / (float)ySteps;
        this.sections = new ArrayList[xSteps][ySteps];
        for (int x = 0; x < this.sections.length; ++x) {
            for (int y = 0; y < this.sections[x].length; ++y) {
                Box2d area = new Box2d((float)x * xWidth + minX, (float)y * yWidth + minZ, (float)x * xWidth + minX + xWidth, (float)y * yWidth + minZ + yWidth);
                this.sections[x][y] = new ArrayList();
                for (int i = 0; i < this.triangles.length; ++i) {
                    if (!this.triangles[i].touches(area)) continue;
                    this.sections[x][y].add(i);
                }
            }
        }
    }

    @Override
    public float getHeight(float xPos, float zPos) {
        int x = Math.round((xPos - this.range.minx) * (float)this.sections.length / this.range.width() - 0.5f);
        int y = Math.round((zPos - this.range.miny) * (float)this.sections[0].length / this.range.height() - 0.5f);
        if (x < 0) {
            x = 0;
        } else if (x >= this.sections.length) {
            x = this.sections.length - 1;
        }
        if (y < 0) {
            y = 0;
        } else if (y >= this.sections[0].length) {
            y = this.sections[0].length - 1;
        }
        ArrayList<Integer> section = this.sections[x][y];
        for (int i = 0; i < section.size(); ++i) {
            if (!this.triangles[section.get(i)].containsPoint(xPos, zPos)) continue;
            int[] ind = this.object.getIndices();
            ShaderProgram.currentShaderProgram.shaders[0].uniforms[1].set(ind[section.get(i) * 3]);
            ShaderProgram.currentShaderProgram.shaders[0].uniforms[2].set(ind[section.get(i) * 3 + 1]);
            ShaderProgram.currentShaderProgram.shaders[0].uniforms[3].set(ind[section.get(i) * 3 + 2]);
            return this.planes[section.get(i)].gety(xPos, zPos);
        }
        for (int xoff = -1; xoff <= 1; ++xoff) {
            for (int yoff = -1; yoff <= 1; ++yoff) {
                if (xoff == 0 && yoff == 0 || x + xoff < 0 || x + xoff >= this.sections.length || y + yoff < 0 || y + yoff >= this.sections[0].length) continue;
                section = this.sections[x + xoff][y + yoff];
                for (int i = 0; i < section.size(); ++i) {
                    if (!this.triangles[section.get(i)].containsPoint(xPos, zPos)) continue;
                    int[] ind = this.object.getIndices();
                    ShaderProgram.currentShaderProgram.shaders[0].uniforms[1].set(ind[section.get(i) * 3]);
                    ShaderProgram.currentShaderProgram.shaders[0].uniforms[2].set(ind[section.get(i) * 3 + 1]);
                    ShaderProgram.currentShaderProgram.shaders[0].uniforms[3].set(ind[section.get(i) * 3 + 2]);
                    return this.planes[section.get(i)].gety(xPos, zPos);
                }
            }
        }
        return this.defaultPlane.gety(xPos, zPos);
    }

    @Override
    public Simplex2v3d getTangentPlane(float xPos, float zPos) {
        int x = Math.round((xPos - this.range.minx) * (float)this.sections.length / this.range.width() - 0.5f);
        int y = Math.round((zPos - this.range.miny) * (float)this.sections[0].length / this.range.height() - 0.5f);
        if (x < 0) {
            x = 0;
        } else if (x >= this.sections.length) {
            x = this.sections.length - 1;
        }
        if (y < 0) {
            y = 0;
        } else if (y >= this.sections[0].length) {
            y = this.sections[0].length - 1;
        }
        ArrayList<Integer> section = this.sections[x][y];
        for (int i = 0; i < section.size(); ++i) {
            if (!this.triangles[section.get(i)].containsPoint(xPos, zPos, 0.001f)) continue;
            return this.planes[section.get(i)];
        }
        for (int xoff = -1; xoff <= 1; ++xoff) {
            for (int yoff = -1; yoff <= 1; ++yoff) {
                if (xoff == 0 && yoff == 0 || x + xoff < 0 || x + xoff >= this.sections.length || y + yoff < 0 || y + yoff >= this.sections[0].length) continue;
                section = this.sections[x + xoff][y + yoff];
                for (int i = 0; i < section.size(); ++i) {
                    if (!this.triangles[section.get(i)].containsPoint(xPos, zPos, 0.001f)) continue;
                    return this.planes[section.get(i)];
                }
            }
        }
        return this.defaultPlane;
    }

    public VAO getObject() {
        return this.object;
    }

    public Simplex2v2d[] getTriangles() {
        return this.triangles;
    }

    public Simplex2v3d[] getPlanes() {
        return this.planes;
    }

    public Box2d getRange() {
        return this.range;
    }

    public ArrayList<Integer>[][] getSections() {
        return this.sections;
    }

    public Simplex2v3d getDefaultPlane() {
        return this.defaultPlane;
    }

    public void setDefaultPlane(Simplex2v3d defaultPlane) {
        this.defaultPlane = defaultPlane;
    }

    public boolean isDefaultPlane(Simplex2v3d other) {
        return other == this.defaultPlane;
    }
}

