/*
 * Decompiled with CFR 0.152.
 */
package engine.Platform;

import engine.OpenGL.VAO;
import org.joml.Vector3f;

public class Box3d {
    float minx;
    float maxx;
    float miny;
    float maxy;
    float minz;
    float maxz;

    public Box3d(float xmin, float ymin, float zmin, float xmax, float ymax, float zmax) {
        this.minx = xmin;
        this.maxx = xmax;
        this.miny = ymin;
        this.maxy = ymax;
        this.minz = zmin;
        this.maxz = zmax;
    }

    public Box3d(Vector3f a, Vector3f b) {
        this.minx = Math.min(a.x, b.x);
        this.maxx = Math.max(a.x, b.x);
        this.miny = Math.min(a.y, b.y);
        this.maxy = Math.max(a.y, b.y);
        this.minz = Math.min(a.z, b.z);
        this.maxz = Math.max(a.z, b.z);
    }

    public Vector3f getCenter() {
        return new Vector3f((this.minx + this.maxx) / 2.0f, (this.miny + this.maxy) / 2.0f, (this.minz + this.maxz) / 2.0f);
    }

    public boolean contains(Vector3f point) {
        return this.minx < point.x && this.maxx > point.x && this.miny < point.y && this.maxy > point.y && this.minz < point.z && this.maxz > point.z;
    }

    public boolean contains(float x, float y, float z) {
        return this.minx < x && this.maxx > x && this.miny < y && this.maxy > y && this.minz < z && this.maxz > z;
    }

    public boolean contains(Box3d other) {
        return this.minx < other.minx && this.maxx > other.maxx && this.miny < other.miny && this.maxy > other.maxy && this.minz < other.minz && this.maxz > other.maxz;
    }

    public boolean touching(Box3d other) {
        return this.contains(other.minx, other.miny, other.minz) || this.contains(other.minx, other.miny, other.maxz) || this.contains(other.minx, other.maxy, other.maxz) || this.contains(other.minx, other.maxy, other.minz) || this.contains(other.maxx, other.miny, other.minz) || this.contains(other.maxx, other.miny, other.maxz) || this.contains(other.maxx, other.maxy, other.maxz) || this.contains(other.maxx, other.maxy, other.minz);
    }

    public boolean touches(Vector3f[] points) {
        for (Vector3f point : points) {
            if (!this.contains(point)) continue;
            return true;
        }
        return false;
    }

    public boolean touches(float[] points) {
        for (int i = 0; i < points.length; i += 3) {
            if (!this.contains(points[i], points[i + 1], points[i + 2])) continue;
            return true;
        }
        return false;
    }

    public boolean touches(VAO object) {
        return this.touches(object.vbos[0].getData());
    }

    public VAO getVAO() {
        float[] vertices = new float[]{this.minx, this.miny, this.minz, this.minx, this.miny, this.maxz, this.maxx, this.miny, this.maxz, this.maxx, this.miny, this.minz, this.minx, this.maxy, this.minz, this.maxx, this.maxy, this.minz, this.minx, this.miny, this.minz, this.minx, this.miny, this.maxz, this.minx, this.maxy, this.maxz, this.minx, this.maxy, this.minz, this.maxx, this.miny, this.maxz, this.maxx, this.maxy, this.maxz, this.maxx, this.miny, this.minz, this.maxx, this.miny, this.maxz, this.maxx, this.maxy, this.maxz, this.maxx, this.maxy, this.minz, this.minx, this.maxy, this.minz, this.minx, this.maxy, this.maxz};
        float[] textureCoordinates = new float[]{0.5f, 0.33333334f, 0.0f, 0.33333334f, 0.0f, 0.0f, 0.5f, 0.0f, 1.0f, 0.33333334f, 1.0f, 0.0f, 0.0f, 0.33333334f, 0.5f, 0.33333334f, 0.5f, 0.6666667f, 0.0f, 0.6666667f, 1.0f, 0.33333334f, 1.0f, 0.6666667f, 0.0f, 0.6666667f, 0.0f, 1.0f, 0.5f, 1.0f, 0.5f, 0.6666667f, 1.0f, 0.6666667f, 1.0f, 1.0f};
        int[] indices = new int[]{0, 2, 1, 0, 3, 2, 4, 5, 0, 5, 3, 0, 8, 6, 7, 9, 6, 8, 8, 10, 11, 8, 7, 10, 15, 14, 13, 15, 13, 12, 17, 14, 15, 17, 15, 16};
        VAO ret = new VAO(vertices, indices);
        ret.addVBO(textureCoordinates, 2);
        return ret;
    }

    public String toString() {
        return "x ranges from " + this.minx + " to " + this.maxx + "\ny ranges from " + this.miny + " to " + this.maxy + "\nz ranges from " + this.minz + " to " + this.maxz;
    }
}

