/*
 * Decompiled with CFR 0.152.
 */
package engine.OpenGL;

import engine.OpenGL.VAO;
import java.util.ArrayList;
import org.lwjgl.opengl.GL15;

public class VBO {
    public static ArrayList<Integer> vboIDs = new ArrayList();
    private int vecSize;
    private float[] data;
    private int id;

    public VBO(float[] array, int size) {
        this.vecSize = size;
        this.id = GL15.glGenBuffers();
        vboIDs.add(this.id);
        this.setData(array);
    }

    public int getVecSize() {
        return this.vecSize;
    }

    public int getId() {
        return this.id;
    }

    public float[] getData() {
        return this.data;
    }

    public void setData(float[] ndata) {
        this.data = ndata;
        GL15.glBindBuffer(34962, this.id);
        GL15.glBufferData(34962, this.data, 35044);
    }

    public void delete() {
        GL15.glDeleteBuffers(this.id);
        for (int i = 0; i < vboIDs.size(); ++i) {
            if (vboIDs.get(i) != this.id) continue;
            vboIDs.remove(i);
            break;
        }
    }

    public int getVertexCount() {
        return this.data.length / this.vecSize;
    }

    public static VBO squareTCBO() {
        return new VBO(VAO.squareTC(), 2);
    }
}

