/*
 * Decompiled with CFR 0.152.
 */
package engine.OpenGL;

import engine.Entities.PositionInfo;
import engine.OpenGL.OBJInformation;
import engine.OpenGL.Uniform;
import engine.OpenGL.VBO;
import engine.Platform.Box3d;
import java.util.ArrayList;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;

public class VAO {
    public static ArrayList<Integer> vaoIDs = new ArrayList();
    private int id;
    private int ibo;
    private int[] indices;
    public VBO[] vbos;
    private int verticesPerShape = 3;
    public Box3d boundingBox;

    public VAO(float[] vertices, int[] ind) {
        this.vbos = new VBO[1];
        this.id = GL30.glGenVertexArrays();
        vaoIDs.add(this.id);
        GL30.glBindVertexArray(this.id);
        this.vbos[0] = new VBO(vertices, 3);
        GL30.glVertexAttribPointer(0, 3, 5126, false, 0, 0L);
        this.ibo = GL30.glGenBuffers();
        VBO.vboIDs.add(this.ibo);
        this.indices = ind;
        GL30.glBindBuffer(34963, this.ibo);
        GL30.glBufferData(34963, this.indices, 35044);
        this.verticesPerShape = 3;
        float minX = Float.POSITIVE_INFINITY;
        float maxX = Float.NEGATIVE_INFINITY;
        float minY = Float.POSITIVE_INFINITY;
        float maxY = Float.NEGATIVE_INFINITY;
        float minZ = Float.POSITIVE_INFINITY;
        float maxZ = Float.NEGATIVE_INFINITY;
        for (int vertStart = 0; vertStart < vertices.length; vertStart += 3) {
            if (vertices[vertStart] < minX) {
                minX = vertices[vertStart];
            }
            if (vertices[vertStart] > maxX) {
                maxX = vertices[vertStart];
            }
            if (vertices[vertStart + 1] < minY) {
                minY = vertices[vertStart + 1];
            }
            if (vertices[vertStart + 1] > maxY) {
                maxY = vertices[vertStart];
            }
            if (vertices[vertStart + 2] < minZ) {
                minZ = vertices[vertStart];
            }
            if (!(vertices[vertStart + 2] > maxZ)) continue;
            maxZ = vertices[vertStart];
        }
        this.boundingBox = new Box3d(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public VAO(float[] vertices, int[] ind, int vps) {
        this.vbos = new VBO[1];
        this.id = GL30.glGenVertexArrays();
        vaoIDs.add(this.id);
        GL30.glBindVertexArray(this.id);
        this.vbos[0] = new VBO(vertices, 3);
        GL30.glVertexAttribPointer(0, 3, 5126, false, 0, 0L);
        this.ibo = GL30.glGenBuffers();
        VBO.vboIDs.add(this.ibo);
        this.indices = ind;
        GL30.glBindBuffer(34963, this.ibo);
        GL30.glBufferData(34963, this.indices, 35044);
        this.verticesPerShape = vps;
        float minX = Float.POSITIVE_INFINITY;
        float maxX = Float.NEGATIVE_INFINITY;
        float minY = Float.POSITIVE_INFINITY;
        float maxY = Float.NEGATIVE_INFINITY;
        float minZ = Float.POSITIVE_INFINITY;
        float maxZ = Float.NEGATIVE_INFINITY;
        for (int vertStart = 0; vertStart < vertices.length; vertStart += 3) {
            if (vertices[vertStart] < minX) {
                minX = vertices[vertStart];
            }
            if (vertices[vertStart] > maxX) {
                maxX = vertices[vertStart];
            }
            if (vertices[vertStart + 1] < minY) {
                minY = vertices[vertStart + 1];
            }
            if (vertices[vertStart + 1] > maxY) {
                maxY = vertices[vertStart];
            }
            if (vertices[vertStart + 2] < minZ) {
                minZ = vertices[vertStart];
            }
            if (!(vertices[vertStart + 2] > maxZ)) continue;
            maxZ = vertices[vertStart];
        }
        this.boundingBox = new Box3d(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public VAO(float x, float y, float width, float height) {
        this.vbos = new VBO[1];
        this.id = GL30.glGenVertexArrays();
        vaoIDs.add(this.id);
        GL30.glBindVertexArray(this.id);
        this.vbos[0] = new VBO(new float[]{x, y + height, 0.0f, x, y, 0.0f, x + width, y, 0.0f, x + width, y + height, 0.0f}, 3);
        GL30.glVertexAttribPointer(0, 3, 5126, false, 0, 0L);
        this.addVBO(VBO.squareTCBO());
        this.ibo = GL30.glGenBuffers();
        VBO.vboIDs.add(this.ibo);
        this.indices = VAO.squareIndices();
        GL30.glBindBuffer(34963, this.ibo);
        GL30.glBufferData(34963, this.indices, 35044);
        this.verticesPerShape = 3;
        float minX = x;
        float maxX = x + width;
        float minY = y;
        float maxY = y + height;
        float minZ = 0.0f;
        float maxZ = 0.0f;
        this.boundingBox = new Box3d(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public VAO(String path) {
        OBJInformation info = new OBJInformation().getInfo(path);
        this.vbos = new VBO[1];
        this.id = GL30.glGenVertexArrays();
        vaoIDs.add(this.id);
        GL30.glBindVertexArray(this.id);
        this.vbos[0] = new VBO(info.vertices, 3);
        GL30.glVertexAttribPointer(0, 3, 5126, false, 0, 0L);
        this.ibo = GL30.glGenBuffers();
        VBO.vboIDs.add(this.ibo);
        this.indices = info.indexArray;
        GL30.glBindBuffer(34963, this.ibo);
        GL30.glBufferData(34963, this.indices, 35044);
        this.verticesPerShape = 3;
        float minX = Float.POSITIVE_INFINITY;
        float maxX = Float.NEGATIVE_INFINITY;
        float minY = Float.POSITIVE_INFINITY;
        float maxY = Float.NEGATIVE_INFINITY;
        float minZ = Float.POSITIVE_INFINITY;
        float maxZ = Float.NEGATIVE_INFINITY;
        for (int vertStart = 0; vertStart < info.vertices.length; vertStart += 3) {
            if (info.vertices[vertStart] < minX) {
                minX = info.vertices[vertStart];
            }
            if (info.vertices[vertStart] > maxX) {
                maxX = info.vertices[vertStart];
            }
            if (info.vertices[vertStart + 1] < minY) {
                minY = info.vertices[vertStart + 1];
            }
            if (info.vertices[vertStart + 1] > maxY) {
                maxY = info.vertices[vertStart + 1];
            }
            if (info.vertices[vertStart + 2] < minZ) {
                minZ = info.vertices[vertStart + 2];
            }
            if (!(info.vertices[vertStart + 2] > maxZ)) continue;
            maxZ = info.vertices[vertStart + 2];
        }
        this.boundingBox = new Box3d(minX, minY, minZ, maxX, maxY, maxZ);
        this.addVBO(info.textCoords, 2);
        this.addVBO(info.normals, 3);
    }

    public void fullRender() {
        this.prepareRender();
        this.draw();
        this.unbind();
    }

    public void prepareRender() {
        GL30.glBindVertexArray(this.id);
        for (int i = 0; i < this.vbos.length; ++i) {
            GL20.glEnableVertexAttribArray(i);
        }
    }

    public void drawPoints() {
        GL30.glDrawElements(0, this.indices.length, 5125, 0L);
    }

    public void drawLines() {
        GL30.glDrawElements(1, this.indices.length, 5125, 0L);
    }

    public void drawTriangles() {
        GL30.glDrawElements(4, this.indices.length, 5125, 0L);
    }

    public void draw() {
        if (this.verticesPerShape == 1) {
            GL30.glDrawElements(0, this.indices.length, 5125, 0L);
        } else if (this.verticesPerShape == 2) {
            GL30.glDrawElements(1, this.indices.length, 5125, 0L);
        } else if (this.verticesPerShape == 3) {
            GL30.glDrawElements(4, this.indices.length, 5125, 0L);
        }
    }

    public void unbind() {
        for (int i = 0; i < this.vbos.length; ++i) {
            GL30.glDisableVertexAttribArray(i);
        }
        GL30.glBindVertexArray(0);
    }

    public void prepareRender(int[] vboset) {
        GL30.glBindVertexArray(this.id);
        for (int i : vboset) {
            GL20.glEnableVertexAttribArray(i);
        }
    }

    public void unbind(int[] vboset) {
        for (int i : vboset) {
            GL30.glDisableVertexAttribArray(i);
        }
        GL30.glBindVertexArray(0);
    }

    public void fullRender(Matrix4f camMatrix, PositionInfo[] info, Uniform uniform) {
        GL30.glBindVertexArray(this.id);
        for (int i = 0; i < this.vbos.length; ++i) {
            GL20.glEnableVertexAttribArray(i);
        }
        if (this.verticesPerShape == 1) {
            for (PositionInfo p : info) {
                uniform.set(p.translateMatrix(camMatrix));
                GL30.glDrawElements(0, this.indices.length, 5125, 0L);
            }
        } else if (this.verticesPerShape == 2) {
            for (PositionInfo p : info) {
                uniform.set(p.translateMatrix(camMatrix));
                GL30.glDrawElements(1, this.indices.length, 5125, 0L);
            }
        } else if (this.verticesPerShape == 3) {
            for (PositionInfo p : info) {
                uniform.set(p.translateMatrix(camMatrix));
                GL30.glDrawElements(4, this.indices.length, 5125, 0L);
            }
        }
        for (int i = 0; i < this.vbos.length; ++i) {
            GL30.glDisableVertexAttribArray(i);
        }
    }

    public void fullRender(Matrix4f camMatrix, PositionInfo[] info, Uniform matUniform, float[][][] uniformInfo, Uniform[] uniforms) {
        int unif;
        int number;
        int i;
        GL30.glBindVertexArray(this.id);
        for (i = 0; i < this.vbos.length; ++i) {
            GL20.glEnableVertexAttribArray(i);
        }
        if (this.verticesPerShape == 1) {
            for (number = 0; number < info.length; ++number) {
                matUniform.set(info[number].translateMatrix(camMatrix));
                for (unif = 0; unif < uniforms.length; ++unif) {
                    uniforms[unif].set(uniformInfo[number][unif]);
                }
                GL30.glDrawElements(0, this.indices.length, 5125, 0L);
            }
        } else if (this.verticesPerShape == 2) {
            for (number = 0; number < info.length; ++number) {
                matUniform.set(info[number].translateMatrix(camMatrix));
                for (unif = 0; unif < uniforms.length; ++unif) {
                    uniforms[unif].set(uniformInfo[number][unif]);
                }
                GL30.glDrawElements(1, this.indices.length, 5125, 0L);
            }
        } else if (this.verticesPerShape == 3) {
            for (number = 0; number < info.length; ++number) {
                matUniform.set(info[number].translateMatrix(camMatrix));
                for (unif = 0; unif < uniforms.length; ++unif) {
                    uniforms[unif].set(uniformInfo[number][unif]);
                }
                GL30.glDrawElements(4, this.indices.length, 5125, 0L);
            }
        }
        for (i = 0; i < this.vbos.length; ++i) {
            GL30.glDisableVertexAttribArray(i);
        }
    }

    public void addVBO(VBO newVBO) {
        VBO[] tempVBOL = new VBO[this.vbos.length + 1];
        for (int i = 0; i < this.vbos.length; ++i) {
            tempVBOL[i] = this.vbos[i];
        }
        tempVBOL[this.vbos.length] = newVBO;
        GL30.glBindVertexArray(this.id);
        GL30.glVertexAttribPointer(this.vbos.length, newVBO.getVecSize(), 5126, false, 0, 0L);
        this.vbos = tempVBOL;
    }

    public void addVBO(float[] info, int size) {
        this.addVBO(new VBO(info, size));
    }

    public int getID() {
        return this.id;
    }

    public int[] getIndices() {
        return this.indices;
    }

    public int getVerticesPerShape() {
        return this.verticesPerShape;
    }

    public int getVertxCount() {
        return this.vbos[0].getVertexCount();
    }

    public void delete() {
        int i;
        GL30.glDeleteVertexArrays(this.id);
        GL30.glDeleteBuffers(this.ibo);
        for (i = 0; i < vaoIDs.size(); ++i) {
            if (vaoIDs.get(i) != this.id) continue;
            vaoIDs.remove(i);
        }
        for (i = 0; i < VBO.vboIDs.size(); ++i) {
            if (VBO.vboIDs.get(i) != this.ibo) continue;
            VBO.vboIDs.remove(i);
            break;
        }
    }

    public void deleteVBOS() {
        for (VBO v : this.vbos) {
            v.delete();
        }
    }

    public static int[] squareIndices() {
        return new int[]{0, 1, 3, 3, 1, 2};
    }

    public static float[] squareTC() {
        return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f};
    }
}

