/*
 * Decompiled with CFR 0.152.
 */
package engine.OpenGL;

import engine.OpenGL.EnigWindow;
import engine.OpenGL.Texture;
import java.util.ArrayList;
import org.lwjgl.opengl.GL30;
import org.lwjgl.opengl.GL32;

public class FBO {
    public static ArrayList<Integer> fboIDs = new ArrayList();
    public static ArrayList<Integer> renderBufferIDs = new ArrayList();
    private int id = GL30.glGenFramebuffers();
    private int depthRenderBufferID;
    private Texture boundTexture;

    public FBO(Texture tex) {
        fboIDs.add(this.id);
        GL30.glBindFramebuffer(36160, this.id);
        GL30.glDrawBuffer(36064);
        this.bindTexture(tex);
    }

    public void bindTexture(Texture tex) {
        GL30.glBindFramebuffer(36160, this.id);
        GL32.glFramebufferTexture(36160, 36064, tex.getId(), 0);
        this.boundTexture = tex;
        this.bindDepthRenderBuffer(tex.getWidth(), tex.getHeight());
    }

    private void bindDepthRenderBuffer(int w, int h) {
        this.depthRenderBufferID = GL30.glGenRenderbuffers();
        renderBufferIDs.add(this.depthRenderBufferID);
        GL30.glBindRenderbuffer(36161, this.depthRenderBufferID);
        GL30.glRenderbufferStorage(36161, 6402, w, h);
        GL30.glFramebufferRenderbuffer(36160, 36096, 36161, this.depthRenderBufferID);
    }

    public void bind() {
        GL30.glBindFramebuffer(36160, this.id);
    }

    public void prepareForTexture() {
        GL30.glBindTexture(3553, 0);
        this.bind();
        GL30.glViewport(0, 0, this.boundTexture.getWidth(), this.boundTexture.getHeight());
        FBO.clearCurrentFrameBuffer();
    }

    public static void bindDefault() {
        GL30.glBindFramebuffer(36160, 0);
    }

    public static void prepareDefaultRender() {
        FBO.bindDefault();
        GL30.glViewport(0, 0, EnigWindow.mainWindow.getWidth(), EnigWindow.mainWindow.getHeight());
        FBO.clearCurrentFrameBuffer();
    }

    public static void clearCurrentFrameBuffer() {
        GL30.glClear(16640);
    }

    public Texture getBoundTexture() {
        return this.boundTexture;
    }

    public int getId() {
        return this.id;
    }

    public int getDepthRenderBufferID() {
        return this.depthRenderBufferID;
    }
}

