/*
 * Decompiled with CFR 0.152.
 */
package engine.OpenAL;

import engine.Entities.Camera;
import engine.Entities.PositionInfo;
import engine.OpenAL.Sound;
import java.util.ArrayList;
import org.joml.Vector4f;
import org.lwjgl.openal.AL10;

public class SoundSource
extends PositionInfo {
    public static ArrayList<Integer> sourceIDs = new ArrayList();
    private int id = AL10.alGenSources();
    private float volume;
    private float pitch;

    public SoundSource() {
        this.setVolume(1.0f);
        this.setPitch(1.0f);
        this.updateSourcePosition();
    }

    public void setVolume(float newValue) {
        this.volume = newValue;
        AL10.alSourcef(this.id, 4106, this.volume);
    }

    public void setPitch(float newValue) {
        this.pitch = newValue;
        AL10.alSourcef(this.id, 4099, this.pitch);
    }

    public void updateSourcePosition() {
        AL10.alSource3f(this.id, 4100, this.x, this.y, this.z);
    }

    public void updateSourcePosition(Camera camera) {
        Vector4f tempPos = new Vector4f(this.x, this.y, this.z, 1.0f);
        tempPos.x -= camera.x;
        tempPos.y -= camera.y;
        tempPos.z -= camera.z;
        tempPos.mul(camera.rotationMatrix);
        AL10.alSource3f(this.id, 4100, tempPos.x, tempPos.y, tempPos.z);
    }

    public void playSound(Sound sound) {
        AL10.alSourcei(this.id, 4105, sound.getID());
        AL10.alSourcePlay(this.id);
    }

    public void play() {
        AL10.alSourcePlay(this.id);
    }

    public void pause() {
        AL10.alSourcePause(this.id);
    }

    public void stop() {
        AL10.alSourceStop(this.id);
    }

    public void setLoop() {
        AL10.alSourcei(this.id, 4103, 1);
    }

    public void setNoLoop() {
        AL10.alSourcei(this.id, 4103, 0);
    }
}

