/*
 * Decompiled with CFR 0.152.
 */
package engine.Entities;

import engine.EnigUtils;
import engine.Entities.Camera;
import engine.OpenGL.EnigWindow;
import engine.Platform.PlatformSegment;
import game.UserControls;
import org.joml.Vector2f;
import org.joml.Vector3f;

public class Player
extends Camera {
    public int health;
    public int mana;
    public float speed;
    public float yVel = 0.0f;

    public Player(int hp, int mna, float sped) {
        super(70.0f, 0.1f, 1000.0f);
        this.health = hp;
        this.mana = mna;
        this.speed = sped;
    }

    public float height() {
        return 1.0f;
    }

    @Override
    public Vector3f getPos() {
        return super.getPos().add(0.0f, this.height(), 0.0f);
    }

    public void moveAlongPlane(float dx, float dz, PlatformSegment plane) {
        Vector3f pos = this.getPos();
        Vector2f npos = plane.getOffset(pos.x, pos.z, dx * this.speed, dz * this.speed);
        npos.add(pos.x, pos.z);
        Vector3f nextPosition = new Vector3f(npos.x, plane.getHeight(npos) + this.height(), npos.y);
        this.setPos(nextPosition);
    }

    public void moveAlongPlane(Vector2f dir, PlatformSegment plane) {
        this.moveAlongPlane(dir.x, dir.y, plane);
    }

    @Override
    public String toString() {
        return "(x = " + EnigUtils.format(this.x, 4) + " y = " + EnigUtils.format(this.y, 4) + " z = " + EnigUtils.format(this.z, 4) + ") hp = " + this.health + " mana = " + this.mana;
    }

    public void updatePosition(PlatformSegment plane, EnigWindow w) {
        if (UserControls.left(w)) {
            this.moveAlongPlane(this.getRotated2DVector(-1.0f, 0.0f, 1.0f), plane);
        } else if (UserControls.right(w)) {
            this.moveAlongPlane(this.getRotated2DVector(1.0f, 0.0f, 1.0f), plane);
        }
    }

    @Override
    public void updateRotations() {
        this.yaw(-((float)EnigWindow.mainWindow.cursorXOffset) * UserControls.sensitivity);
        this.pitch(-((float)EnigWindow.mainWindow.cursorYOffset) * UserControls.sensitivity);
        if ((double)this.getPitch() > 1.5707963267948966) {
            this.setPitch(1.5707964f);
        } else if ((double)this.getPitch() < -1.5707963267948966) {
            this.setPitch(-1.5707964f);
        }
    }
}

