/*
 * Decompiled with CFR 0.152.
 */
package org.lwjglx.debug.org.objectweb.asm.util;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.lwjglx.debug.org.objectweb.asm.Attribute;
import org.lwjglx.debug.org.objectweb.asm.ClassReader;
import org.lwjglx.debug.org.objectweb.asm.Handle;
import org.lwjglx.debug.org.objectweb.asm.Label;
import org.lwjglx.debug.org.objectweb.asm.TypePath;
import org.lwjglx.debug.org.objectweb.asm.util.TraceClassVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Printer {
    public static final String[] OPCODES = new String[]{"NOP", "ACONST_NULL", "ICONST_M1", "ICONST_0", "ICONST_1", "ICONST_2", "ICONST_3", "ICONST_4", "ICONST_5", "LCONST_0", "LCONST_1", "FCONST_0", "FCONST_1", "FCONST_2", "DCONST_0", "DCONST_1", "BIPUSH", "SIPUSH", "LDC", "LDC_W", "LDC2_W", "ILOAD", "LLOAD", "FLOAD", "DLOAD", "ALOAD", "ILOAD_0", "ILOAD_1", "ILOAD_2", "ILOAD_3", "LLOAD_0", "LLOAD_1", "LLOAD_2", "LLOAD_3", "FLOAD_0", "FLOAD_1", "FLOAD_2", "FLOAD_3", "DLOAD_0", "DLOAD_1", "DLOAD_2", "DLOAD_3", "ALOAD_0", "ALOAD_1", "ALOAD_2", "ALOAD_3", "IALOAD", "LALOAD", "FALOAD", "DALOAD", "AALOAD", "BALOAD", "CALOAD", "SALOAD", "ISTORE", "LSTORE", "FSTORE", "DSTORE", "ASTORE", "ISTORE_0", "ISTORE_1", "ISTORE_2", "ISTORE_3", "LSTORE_0", "LSTORE_1", "LSTORE_2", "LSTORE_3", "FSTORE_0", "FSTORE_1", "FSTORE_2", "FSTORE_3", "DSTORE_0", "DSTORE_1", "DSTORE_2", "DSTORE_3", "ASTORE_0", "ASTORE_1", "ASTORE_2", "ASTORE_3", "IASTORE", "LASTORE", "FASTORE", "DASTORE", "AASTORE", "BASTORE", "CASTORE", "SASTORE", "POP", "POP2", "DUP", "DUP_X1", "DUP_X2", "DUP2", "DUP2_X1", "DUP2_X2", "SWAP", "IADD", "LADD", "FADD", "DADD", "ISUB", "LSUB", "FSUB", "DSUB", "IMUL", "LMUL", "FMUL", "DMUL", "IDIV", "LDIV", "FDIV", "DDIV", "IREM", "LREM", "FREM", "DREM", "INEG", "LNEG", "FNEG", "DNEG", "ISHL", "LSHL", "ISHR", "LSHR", "IUSHR", "LUSHR", "IAND", "LAND", "IOR", "LOR", "IXOR", "LXOR", "IINC", "I2L", "I2F", "I2D", "L2I", "L2F", "L2D", "F2I", "F2L", "F2D", "D2I", "D2L", "D2F", "I2B", "I2C", "I2S", "LCMP", "FCMPL", "FCMPG", "DCMPL", "DCMPG", "IFEQ", "IFNE", "IFLT", "IFGE", "IFGT", "IFLE", "IF_ICMPEQ", "IF_ICMPNE", "IF_ICMPLT", "IF_ICMPGE", "IF_ICMPGT", "IF_ICMPLE", "IF_ACMPEQ", "IF_ACMPNE", "GOTO", "JSR", "RET", "TABLESWITCH", "LOOKUPSWITCH", "IRETURN", "LRETURN", "FRETURN", "DRETURN", "ARETURN", "RETURN", "GETSTATIC", "PUTSTATIC", "GETFIELD", "PUTFIELD", "INVOKEVIRTUAL", "INVOKESPECIAL", "INVOKESTATIC", "INVOKEINTERFACE", "INVOKEDYNAMIC", "NEW", "NEWARRAY", "ANEWARRAY", "ARRAYLENGTH", "ATHROW", "CHECKCAST", "INSTANCEOF", "MONITORENTER", "MONITOREXIT", "WIDE", "MULTIANEWARRAY", "IFNULL", "IFNONNULL"};
    public static final String[] TYPES = new String[]{"", "", "", "", "T_BOOLEAN", "T_CHAR", "T_FLOAT", "T_DOUBLE", "T_BYTE", "T_SHORT", "T_INT", "T_LONG"};
    public static final String[] HANDLE_TAG = new String[]{"", "H_GETFIELD", "H_GETSTATIC", "H_PUTFIELD", "H_PUTSTATIC", "H_INVOKEVIRTUAL", "H_INVOKESTATIC", "H_INVOKESPECIAL", "H_NEWINVOKESPECIAL", "H_INVOKEINTERFACE"};
    private static final String UNSUPPORTED_OPERATION = "Must be overridden";
    protected final int api;
    @Deprecated
    protected final StringBuffer buf;
    protected final StringBuilder stringBuilder;
    public final List<Object> text;

    protected Printer(int api) {
        this.api = api;
        this.buf = null;
        this.stringBuilder = new StringBuilder();
        this.text = new ArrayList<Object>();
    }

    public abstract void visit(int var1, int var2, String var3, String var4, String var5, String[] var6);

    public abstract void visitSource(String var1, String var2);

    public Printer visitModule(String name, int access, String version) {
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION);
    }

    @Deprecated
    public void visitNestHostExperimental(String nestHost) {
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION);
    }

    public abstract void visitOuterClass(String var1, String var2, String var3);

    public abstract Printer visitClassAnnotation(String var1, boolean var2);

    public Printer visitClassTypeAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION);
    }

    public abstract void visitClassAttribute(Attribute var1);

    @Deprecated
    public void visitNestMemberExperimental(String nestMember) {
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION);
    }

    public abstract void visitInnerClass(String var1, String var2, String var3, int var4);

    public abstract Printer visitField(int var1, String var2, String var3, String var4, Object var5);

    public abstract Printer visitMethod(int var1, String var2, String var3, String var4, String[] var5);

    public abstract void visitClassEnd();

    public void visitMainClass(String mainClass) {
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION);
    }

    public void visitPackage(String packaze) {
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION);
    }

    public void visitRequire(String module, int access, String version) {
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION);
    }

    public void visitExport(String packaze, int access, String ... modules) {
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION);
    }

    public void visitOpen(String packaze, int access, String ... modules) {
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION);
    }

    public void visitUse(String service) {
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION);
    }

    public void visitProvide(String service, String ... providers) {
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION);
    }

    public void visitModuleEnd() {
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION);
    }

    public abstract void visit(String var1, Object var2);

    public abstract void visitEnum(String var1, String var2, String var3);

    public abstract Printer visitAnnotation(String var1, String var2);

    public abstract Printer visitArray(String var1);

    public abstract void visitAnnotationEnd();

    public abstract Printer visitFieldAnnotation(String var1, boolean var2);

    public Printer visitFieldTypeAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION);
    }

    public abstract void visitFieldAttribute(Attribute var1);

    public abstract void visitFieldEnd();

    public void visitParameter(String name, int access) {
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION);
    }

    public abstract Printer visitAnnotationDefault();

    public abstract Printer visitMethodAnnotation(String var1, boolean var2);

    public Printer visitMethodTypeAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION);
    }

    public Printer visitAnnotableParameterCount(int parameterCount, boolean visible) {
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION);
    }

    public abstract Printer visitParameterAnnotation(int var1, String var2, boolean var3);

    public abstract void visitMethodAttribute(Attribute var1);

    public abstract void visitCode();

    public abstract void visitFrame(int var1, int var2, Object[] var3, int var4, Object[] var5);

    public abstract void visitInsn(int var1);

    public abstract void visitIntInsn(int var1, int var2);

    public abstract void visitVarInsn(int var1, int var2);

    public abstract void visitTypeInsn(int var1, String var2);

    public abstract void visitFieldInsn(int var1, String var2, String var3, String var4);

    @Deprecated
    public void visitMethodInsn(int opcode, String owner, String name, String descriptor) {
        if (this.api >= 327680) {
            boolean isInterface = opcode == 185;
            this.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
            return;
        }
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION);
    }

    public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
        if (this.api < 327680) {
            if (isInterface != (opcode == 185)) {
                throw new IllegalArgumentException("INVOKESPECIAL/STATIC on interfaces require ASM 5");
            }
            this.visitMethodInsn(opcode, owner, name, descriptor);
            return;
        }
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION);
    }

    public abstract void visitInvokeDynamicInsn(String var1, String var2, Handle var3, Object ... var4);

    public abstract void visitJumpInsn(int var1, Label var2);

    public abstract void visitLabel(Label var1);

    public abstract void visitLdcInsn(Object var1);

    public abstract void visitIincInsn(int var1, int var2);

    public abstract void visitTableSwitchInsn(int var1, int var2, Label var3, Label ... var4);

    public abstract void visitLookupSwitchInsn(Label var1, int[] var2, Label[] var3);

    public abstract void visitMultiANewArrayInsn(String var1, int var2);

    public Printer visitInsnAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION);
    }

    public abstract void visitTryCatchBlock(Label var1, Label var2, Label var3, String var4);

    public Printer visitTryCatchAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION);
    }

    public abstract void visitLocalVariable(String var1, String var2, String var3, Label var4, Label var5, int var6);

    public Printer visitLocalVariableAnnotation(int typeRef, TypePath typePath, Label[] start, Label[] end, int[] index, String descriptor, boolean visible) {
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION);
    }

    public abstract void visitLineNumber(int var1, Label var2);

    public abstract void visitMaxs(int var1, int var2);

    public abstract void visitMethodEnd();

    public List<Object> getText() {
        return this.text;
    }

    public void print(PrintWriter printWriter) {
        Printer.printList(printWriter, this.text);
    }

    static void printList(PrintWriter printWriter, List<?> list) {
        for (Object o : list) {
            if (o instanceof List) {
                Printer.printList(printWriter, (List)o);
                continue;
            }
            printWriter.print(o.toString());
        }
    }

    @Deprecated
    public static void appendString(StringBuffer stringBuffer, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        Printer.appendString(stringBuilder, string);
        stringBuffer.append(stringBuilder.toString());
    }

    public static void appendString(StringBuilder stringBuilder, String string) {
        stringBuilder.append('\"');
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\n') {
                stringBuilder.append("\\n");
                continue;
            }
            if (c == '\r') {
                stringBuilder.append("\\r");
                continue;
            }
            if (c == '\\') {
                stringBuilder.append("\\\\");
                continue;
            }
            if (c == '\"') {
                stringBuilder.append("\\\"");
                continue;
            }
            if (c < ' ' || c > '\u007f') {
                stringBuilder.append("\\u");
                if (c < '\u0010') {
                    stringBuilder.append("000");
                } else if (c < '\u0100') {
                    stringBuilder.append("00");
                } else if (c < '\u1000') {
                    stringBuilder.append('0');
                }
                stringBuilder.append(Integer.toString(c, 16));
                continue;
            }
            stringBuilder.append(c);
        }
        stringBuilder.append('\"');
    }

    static void main(String usage, Printer printer, String[] args) throws IOException {
        int parsingOptions;
        String className;
        if (args.length < 1 || args.length > 2 || args[0].equals("-debug") && args.length != 2) {
            System.err.println(usage);
            return;
        }
        TraceClassVisitor traceClassVisitor = new TraceClassVisitor(null, printer, new PrintWriter(System.out));
        if (args[0].equals("-debug")) {
            className = args[1];
            parsingOptions = 2;
        } else {
            className = args[0];
            parsingOptions = 0;
        }
        if (className.endsWith(".class") || className.indexOf(92) != -1 || className.indexOf(47) != -1) {
            new ClassReader(new FileInputStream(className)).accept(traceClassVisitor, parsingOptions);
        } else {
            new ClassReader(className).accept(traceClassVisitor, parsingOptions);
        }
    }
}

