/*
 * Decompiled with CFR 0.152.
 */
package org.lwjglx.debug.opengl;

import java.nio.IntBuffer;
import org.lwjglx.debug.Context;
import org.lwjglx.debug.Properties;
import org.lwjglx.debug.RT;

public class EXTFramebufferObject {
    public static void glGenerateMipmapEXT(int target) {
        org.lwjgl.opengl.EXTFramebufferObject.glGenerateMipmapEXT(target);
        if (Properties.PROFILE.enabled) {
            RT.generateMipmap(target);
        }
    }

    public static void glGenFramebuffersEXT(IntBuffer framebuffers) {
        org.lwjgl.opengl.EXTFramebufferObject.glGenFramebuffersEXT(framebuffers);
        if (Properties.VALIDATE.enabled) {
            Context ctx = Context.CURRENT_CONTEXT.get();
            int pos = framebuffers.position();
            for (int i = 0; i < framebuffers.remaining(); ++i) {
                int handle = framebuffers.get(pos + i);
                Context.FBO fbo = new Context.FBO(handle);
                ctx.fbos.put(handle, fbo);
            }
        }
    }

    public static int glGenFramebuffersEXT() {
        int handle = org.lwjgl.opengl.EXTFramebufferObject.glGenFramebuffersEXT();
        if (Properties.VALIDATE.enabled) {
            Context.FBO fbo = new Context.FBO(handle);
            Context ctx = Context.CURRENT_CONTEXT.get();
            ctx.fbos.put(handle, fbo);
        }
        return handle;
    }

    public static void glGenFramebuffersEXT(int[] framebuffers) {
        org.lwjgl.opengl.EXTFramebufferObject.glGenFramebuffersEXT(framebuffers);
        if (Properties.VALIDATE.enabled) {
            Context ctx = Context.CURRENT_CONTEXT.get();
            for (int i = 0; i < framebuffers.length; ++i) {
                int handle = framebuffers[i];
                Context.FBO fbo = new Context.FBO(handle);
                ctx.fbos.put(handle, fbo);
            }
        }
    }

    public static void glBindFramebufferEXT(int target, int framebuffer) {
        if (Properties.VALIDATE.enabled) {
            Context ctx = Context.CURRENT_CONTEXT.get();
            Context.FBO fbo = ctx.fbos.get(framebuffer);
            if (fbo == null && ctx.shareGroup != null) {
                for (Context c : ctx.shareGroup.contexts) {
                    if (!c.fbos.containsKey(framebuffer)) continue;
                    RT.throwISEOrLogError("Trying to bind unknown FBO [" + framebuffer + "] from shared context [" + c.counter + "]");
                }
            }
            ctx.currentFbo = fbo;
        }
        org.lwjgl.opengl.EXTFramebufferObject.glBindFramebufferEXT(target, framebuffer);
    }

    public static void glDeleteFramebuffersEXT(IntBuffer framebuffers) {
        org.lwjgl.opengl.EXTFramebufferObject.glDeleteFramebuffersEXT(framebuffers);
        if (Properties.VALIDATE.enabled) {
            Context context = Context.CURRENT_CONTEXT.get();
            int pos = framebuffers.position();
            for (int i = 0; i < framebuffers.remaining(); ++i) {
                int framebuffer = framebuffers.get(pos + i);
                if (framebuffer == 0) continue;
                Context.FBO fbo = context.fbos.get(framebuffer);
                if (fbo != null && fbo == context.currentFbo) {
                    context.currentFbo = context.defaultFbo;
                }
                context.fbos.remove(framebuffer);
            }
        }
    }

    public static void glDeleteFramebuffersEXT(int framebuffer) {
        org.lwjgl.opengl.EXTFramebufferObject.glDeleteFramebuffersEXT(framebuffer);
        if (Properties.VALIDATE.enabled) {
            if (framebuffer == 0) {
                return;
            }
            Context context = Context.CURRENT_CONTEXT.get();
            Context.FBO fbo = context.fbos.get(framebuffer);
            if (fbo != null && fbo == context.currentFbo) {
                context.currentFbo = context.defaultFbo;
            }
            context.fbos.remove(framebuffer);
        }
    }

    public static void glDeleteFramebuffersEXT(int[] framebuffers) {
        org.lwjgl.opengl.EXTFramebufferObject.glDeleteFramebuffersEXT(framebuffers);
        if (Properties.VALIDATE.enabled) {
            Context context = Context.CURRENT_CONTEXT.get();
            for (int i = 0; i < framebuffers.length; ++i) {
                int framebuffer = framebuffers[i];
                if (framebuffer == 0) continue;
                Context.FBO fbo = context.fbos.get(framebuffer);
                if (fbo != null && fbo == context.currentFbo) {
                    context.currentFbo = context.defaultFbo;
                }
                context.fbos.remove(framebuffer);
            }
        }
    }
}

