/*
 * Decompiled with CFR 0.152.
 */
package org.lwjglx.debug.opengl;

import java.nio.IntBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryUtil;
import org.lwjglx.debug.Context;
import org.lwjglx.debug.Log;
import org.lwjglx.debug.Properties;
import org.lwjglx.debug.RT;

public class ARBSeparateShaderObjects {
    public static void glGenProgramPipelines(IntBuffer pipelines) {
        org.lwjgl.opengl.ARBSeparateShaderObjects.glGenProgramPipelines(pipelines);
        if (Properties.VALIDATE.enabled) {
            int position = pipelines.position();
            Context context = Context.CURRENT_CONTEXT.get();
            for (int i = 0; i < pipelines.remaining(); ++i) {
                Context.ProgramPipeline pp = new Context.ProgramPipeline();
                context.programPipelines.put(pipelines.get(position + i), pp);
            }
        }
    }

    public static int glGenProgramPipelines() {
        int index = org.lwjgl.opengl.ARBSeparateShaderObjects.glGenProgramPipelines();
        if (Properties.VALIDATE.enabled) {
            Context context = Context.CURRENT_CONTEXT.get();
            Context.ProgramPipeline pp = new Context.ProgramPipeline();
            context.programPipelines.put(index, pp);
        }
        return index;
    }

    public static void glGenProgramPipelines(int[] pipelines) {
        org.lwjgl.opengl.ARBSeparateShaderObjects.glGenProgramPipelines(pipelines);
        if (Properties.VALIDATE.enabled) {
            Context context = Context.CURRENT_CONTEXT.get();
            for (int i = 0; i < pipelines.length; ++i) {
                Context.ProgramPipeline pp = new Context.ProgramPipeline();
                context.programPipelines.put(pipelines[i], pp);
            }
        }
    }

    public static void glBindProgramPipeline(int pipeline) {
        if (Properties.VALIDATE.enabled) {
            Context ctx = Context.CURRENT_CONTEXT.get();
            Context.ProgramPipeline pp = ctx.programPipelines.get(pipeline);
            if (pp == null && ctx.shareGroup != null) {
                for (Context c : ctx.shareGroup.contexts) {
                    if (!c.programPipelines.containsKey(pipeline)) continue;
                    RT.throwISEOrLogError("Trying to bind unknown Program Pipeline [" + pipeline + "] from shared context [" + c.counter + "]");
                }
            }
            ctx.currentProgramPipeline = pp;
        }
        org.lwjgl.opengl.ARBSeparateShaderObjects.glBindProgramPipeline(pipeline);
    }

    public static void glDeleteProgramPipelines(IntBuffer pipelines) {
        org.lwjgl.opengl.ARBSeparateShaderObjects.glDeleteProgramPipelines(pipelines);
        if (Properties.VALIDATE.enabled) {
            Context.deletePipelines(pipelines);
        }
    }

    public static void glDeleteProgramPipelines(int pipeline) {
        org.lwjgl.opengl.ARBSeparateShaderObjects.glDeleteProgramPipelines(pipeline);
        if (Properties.VALIDATE.enabled) {
            Context.deletePipeline(pipeline);
        }
    }

    public static void glDeleteProgramPipelines(int[] pipelines) {
        org.lwjgl.opengl.ARBSeparateShaderObjects.glDeleteProgramPipelines(pipelines);
        if (Properties.VALIDATE.enabled) {
            Context.deletePipelines(pipelines);
        }
    }

    public static int glCreateShaderProgramv(int type, PointerBuffer strings) {
        int shader = org.lwjgl.opengl.ARBSeparateShaderObjects.glCreateShaderProgramv(type, strings);
        if (Properties.TRACE.enabled) {
            StringBuilder sb = new StringBuilder();
            if (strings != null) {
                int stringsPos = strings.position();
                for (int i = 0; i < strings.remaining(); ++i) {
                    String source = MemoryUtil.memASCII(strings.get(stringsPos + i));
                    sb.append(source);
                }
            }
            Log.trace("Shader source for shader [" + shader + "]:\n" + sb.toString());
        }
        return shader;
    }

    public static int glCreateShaderProgramv(int type, CharSequence ... strings) {
        int shader = org.lwjgl.opengl.ARBSeparateShaderObjects.glCreateShaderProgramv(type, strings);
        if (Properties.TRACE.enabled) {
            StringBuilder sb = new StringBuilder();
            if (strings != null) {
                for (int i = 0; i < strings.length; ++i) {
                    sb.append(strings[i]);
                }
            }
            Log.trace("Shader source for shader [" + shader + "]:\n" + sb.toString());
        }
        return shader;
    }

    public static int glCreateShaderProgramv(int type, CharSequence string) {
        int shader = org.lwjgl.opengl.ARBSeparateShaderObjects.glCreateShaderProgramv(type, string);
        if (Properties.TRACE.enabled) {
            Log.trace("Shader source for shader [" + shader + "]:\n" + string);
        }
        return shader;
    }
}

