/*
 * Decompiled with CFR 0.152.
 */
package org.lwjglx.debug.opengl;

import java.nio.IntBuffer;
import org.lwjglx.debug.Context;
import org.lwjglx.debug.Properties;
import org.lwjglx.debug.RT;

public class ARBFramebufferObject {
    public static void glGenerateMipmap(int target) {
        org.lwjgl.opengl.ARBFramebufferObject.glGenerateMipmap(target);
        if (Properties.PROFILE.enabled) {
            RT.generateMipmap(target);
        }
    }

    public static void glGenFramebuffers(IntBuffer framebuffers) {
        org.lwjgl.opengl.ARBFramebufferObject.glGenFramebuffers(framebuffers);
        if (Properties.VALIDATE.enabled) {
            Context ctx = Context.CURRENT_CONTEXT.get();
            int pos = framebuffers.position();
            for (int i = 0; i < framebuffers.remaining(); ++i) {
                int handle = framebuffers.get(pos + i);
                Context.FBO fbo = new Context.FBO(handle);
                ctx.fbos.put(handle, fbo);
            }
        }
    }

    public static int glGenFramebuffers() {
        int handle = org.lwjgl.opengl.ARBFramebufferObject.glGenFramebuffers();
        if (Properties.VALIDATE.enabled) {
            Context.FBO fbo = new Context.FBO(handle);
            Context ctx = Context.CURRENT_CONTEXT.get();
            ctx.fbos.put(handle, fbo);
        }
        return handle;
    }

    public static void glGenFramebuffers(int[] framebuffers) {
        org.lwjgl.opengl.ARBFramebufferObject.glGenFramebuffers(framebuffers);
        if (Properties.VALIDATE.enabled) {
            Context ctx = Context.CURRENT_CONTEXT.get();
            for (int i = 0; i < framebuffers.length; ++i) {
                int handle = framebuffers[i];
                Context.FBO fbo = new Context.FBO(handle);
                ctx.fbos.put(handle, fbo);
            }
        }
    }

    public static void glBindFramebuffer(int target, int framebuffer) {
        if (Properties.VALIDATE.enabled) {
            Context ctx = Context.CURRENT_CONTEXT.get();
            Context.FBO fbo = ctx.fbos.get(framebuffer);
            if (fbo == null && ctx.shareGroup != null) {
                for (Context c : ctx.shareGroup.contexts) {
                    if (!c.fbos.containsKey(framebuffer)) continue;
                    RT.throwISEOrLogError("Trying to bind unknown FBO [" + framebuffer + "] from shared context [" + c.counter + "]");
                }
            }
            ctx.currentFbo = fbo;
        }
        org.lwjgl.opengl.ARBFramebufferObject.glBindFramebuffer(target, framebuffer);
    }

    public static void glDeleteFramebuffers(IntBuffer framebuffers) {
        org.lwjgl.opengl.ARBFramebufferObject.glDeleteFramebuffers(framebuffers);
        if (Properties.VALIDATE.enabled) {
            Context context = Context.CURRENT_CONTEXT.get();
            int pos = framebuffers.position();
            for (int i = 0; i < framebuffers.remaining(); ++i) {
                int framebuffer = framebuffers.get(pos + i);
                if (framebuffer == 0) continue;
                Context.FBO fbo = context.fbos.get(framebuffer);
                if (fbo != null && fbo == context.currentFbo) {
                    context.currentFbo = context.defaultFbo;
                }
                context.fbos.remove(framebuffer);
            }
        }
    }

    public static void glDeleteFramebuffers(int framebuffer) {
        org.lwjgl.opengl.ARBFramebufferObject.glDeleteFramebuffers(framebuffer);
        if (Properties.VALIDATE.enabled) {
            if (framebuffer == 0) {
                return;
            }
            Context context = Context.CURRENT_CONTEXT.get();
            Context.FBO fbo = context.fbos.get(framebuffer);
            if (fbo != null && fbo == context.currentFbo) {
                context.currentFbo = context.defaultFbo;
            }
            context.fbos.remove(framebuffer);
        }
    }

    public static void glDeleteFramebuffers(int[] framebuffers) {
        org.lwjgl.opengl.ARBFramebufferObject.glDeleteFramebuffers(framebuffers);
        if (Properties.VALIDATE.enabled) {
            Context context = Context.CURRENT_CONTEXT.get();
            for (int i = 0; i < framebuffers.length; ++i) {
                int framebuffer = framebuffers[i];
                if (framebuffer == 0) continue;
                Context.FBO fbo = context.fbos.get(framebuffer);
                if (fbo != null && fbo == context.currentFbo) {
                    context.currentFbo = context.defaultFbo;
                }
                context.fbos.remove(framebuffer);
            }
        }
    }
}

