/*
 * Decompiled with CFR 0.152.
 */
package org.lwjglx.debug.glfw;

import java.nio.ByteBuffer;
import java.util.Map;
import org.lwjgl.glfw.GLFWErrorCallback;
import org.lwjgl.glfw.GLFWVidMode;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Platform;
import org.lwjglx.debug.Context;
import org.lwjglx.debug.Log;
import org.lwjglx.debug.MethodCall;
import org.lwjglx.debug.Properties;
import org.lwjglx.debug.RT;

public class GLFW {
    private static GLFWErrorCallback userCallback;
    private static GLFWErrorCallback errorCallback;

    public static boolean glfwInit() {
        boolean ret;
        if (Properties.VALIDATE.enabled) {
            Log.debug("Registering GLFWErrorCallback");
            errorCallback = new GLFWErrorCallback(){
                private final Map<Integer, String> ERROR_CODES = APIUtil.apiClassTokens((field, value) -> 65536 < value && value < 131072, null, org.lwjgl.glfw.GLFW.class);

                @Override
                public void invoke(int error, long description) {
                    String msg = 1.getDescription(description);
                    System.err.printf("[LWJGL] %s error\n", this.ERROR_CODES.get(error));
                    System.err.println("\tDescription : " + msg);
                    System.err.println("\tStacktrace  :");
                    StackTraceElement[] stack = Thread.currentThread().getStackTrace();
                    for (int i = 4; i < stack.length; ++i) {
                        System.err.print("\t\t");
                        System.err.println(stack[i].toString());
                    }
                    if (userCallback != null) {
                        userCallback.invoke(error, description);
                    }
                }
            };
            userCallback = org.lwjgl.glfw.GLFW.glfwSetErrorCallback(errorCallback);
            ret = org.lwjgl.glfw.GLFW.glfwInit();
            if (!ret) {
                Log.error("glfwInit returned false");
            }
        } else {
            ret = org.lwjgl.glfw.GLFW.glfwInit();
        }
        RT.glfwInitialized = ret;
        return ret;
    }

    public static void glfwTerminate() {
        if (Properties.VALIDATE.enabled) {
            org.lwjgl.glfw.GLFW.glfwSetErrorCallback(userCallback);
        }
        org.lwjgl.glfw.GLFW.glfwTerminate();
        if (Properties.VALIDATE.enabled) {
            Log.debug("Freeing GLFWErrorCallback");
            if (errorCallback != null) {
                errorCallback.free();
            }
        }
        RT.glfwInitialized = false;
    }

    private static void printBoolean(MethodCall mc, int value) {
        switch (value) {
            case 1: {
                mc.paramEnum("GLFW_TRUE");
                break;
            }
            case 0: {
                mc.paramEnum("GLFW_FALSE");
                break;
            }
            default: {
                mc.param(value);
            }
        }
    }

    public static void glfwCreateStandardCursor(int shape, long ret, MethodCall mc) {
        switch (shape) {
            case 221185: {
                mc.paramEnum("GLFW_ARROW_CURSOR");
                break;
            }
            case 221186: {
                mc.paramEnum("GLFW_IBEAM_CURSOR");
                break;
            }
            case 221187: {
                mc.paramEnum("GLFW_CROSSHAIR_CURSOR");
                break;
            }
            case 221188: {
                mc.paramEnum("GLFW_HAND_CURSOR");
                break;
            }
            case 221189: {
                mc.paramEnum("GLFW_HRESIZE_CURSOR");
                break;
            }
            case 221190: {
                mc.paramEnum("GLFW_VRESIZE_CURSOR");
                break;
            }
            default: {
                mc.param(shape);
            }
        }
        mc.returnValue(ret);
    }

    public static void glfwWindowHint(int hint, int value, Void ret, MethodCall mc) {
        block0 : switch (hint) {
            case 131075: {
                mc.paramEnum("GLFW_RESIZABLE");
                GLFW.printBoolean(mc, value);
                break;
            }
            case 131076: {
                mc.paramEnum("GLFW_VISIBLE");
                GLFW.printBoolean(mc, value);
                break;
            }
            case 131077: {
                mc.paramEnum("GLFW_DECORATED");
                GLFW.printBoolean(mc, value);
                break;
            }
            case 131073: {
                mc.paramEnum("GLFW_FOCUSED");
                GLFW.printBoolean(mc, value);
                break;
            }
            case 131078: {
                mc.paramEnum("GLFW_AUTO_ICONIFY");
                GLFW.printBoolean(mc, value);
                break;
            }
            case 131079: {
                mc.paramEnum("GLFW_AUTO_FLOATING");
                GLFW.printBoolean(mc, value);
                break;
            }
            case 131080: {
                mc.paramEnum("GLFW_AUTO_MAXIMIZED");
                GLFW.printBoolean(mc, value);
                break;
            }
            case 131081: {
                mc.paramEnum("GLFW_CENTER_CURSOR");
                GLFW.printBoolean(mc, value);
                break;
            }
            case 135169: {
                mc.paramEnum("GLFW_RED_BITS");
                mc.param(value);
                break;
            }
            case 135170: {
                mc.paramEnum("GLFW_GREEN_BITS");
                mc.param(value);
                break;
            }
            case 135171: {
                mc.paramEnum("GLFW_BLUE_BITS");
                mc.param(value);
                break;
            }
            case 135172: {
                mc.paramEnum("GLFW_ALPHA_BITS");
                mc.param(value);
                break;
            }
            case 135173: {
                mc.paramEnum("GLFW_DEPTH_BITS");
                mc.param(value);
                break;
            }
            case 135174: {
                mc.paramEnum("GLFW_STENCIL_BITS");
                mc.param(value);
                break;
            }
            case 135175: {
                mc.paramEnum("GLFW_ACCUM_RED_BITS");
                mc.param(value);
                break;
            }
            case 135176: {
                mc.paramEnum("GLFW_ACCUM_GREEN_BITS");
                mc.param(value);
                break;
            }
            case 135177: {
                mc.paramEnum("GLFW_ACCUM_BLUE_BITS");
                mc.param(value);
                break;
            }
            case 135178: {
                mc.paramEnum("GLFW_ACCUM_ALPHA_BITS");
                mc.param(value);
                break;
            }
            case 135179: {
                mc.paramEnum("GLFW_AUX_BUFFERS");
                mc.param(value);
                break;
            }
            case 135181: {
                mc.paramEnum("GLFW_SAMPLES");
                mc.param(value);
                break;
            }
            case 135183: {
                mc.paramEnum("GLFW_REFRESH_RATE");
                mc.param(value);
                break;
            }
            case 135180: {
                mc.paramEnum("GLFW_STEREO");
                GLFW.printBoolean(mc, value);
                break;
            }
            case 135182: {
                mc.paramEnum("GLFW_SRGB_CAPABLE");
                GLFW.printBoolean(mc, value);
                break;
            }
            case 135184: {
                mc.paramEnum("GLFW_DOUBLEBUFFER");
                GLFW.printBoolean(mc, value);
                break;
            }
            case 139265: {
                mc.paramEnum("GLFW_CLIENT_API");
                switch (value) {
                    case 0: {
                        mc.paramEnum("GLFW_NO_API");
                        break block0;
                    }
                    case 196609: {
                        mc.paramEnum("GLFW_OPENGL_API");
                        break block0;
                    }
                    case 196610: {
                        mc.paramEnum("GLFW_OPENGL_ES_API");
                        break block0;
                    }
                }
                mc.param(value);
                break;
            }
            case 139275: {
                mc.paramEnum("GLFW_CONTEXT_CREATION_API");
                switch (value) {
                    case 221185: {
                        mc.paramEnum("GLFW_NATIVE_CONTEXT_API");
                        break block0;
                    }
                    case 221186: {
                        mc.paramEnum("GLFW_EGL_CONTEXT_API");
                        break block0;
                    }
                    case 221187: {
                        mc.paramEnum("GLFW_OSMESA_CONTEXT_API");
                        break block0;
                    }
                }
                mc.param(value);
                break;
            }
            case 139266: {
                mc.paramEnum("GLFW_CONTEXT_VERSION_MAJOR");
                mc.param(value);
                break;
            }
            case 139267: {
                mc.paramEnum("GLFW_CONTEXT_VERSION_MINOR");
                mc.param(value);
                break;
            }
            case 139269: {
                mc.paramEnum("GLFW_CONTEXT_ROBUSTNESS");
                switch (value) {
                    case 0: {
                        mc.paramEnum("GLFW_NO_ROBUSTNESS");
                        break block0;
                    }
                    case 200705: {
                        mc.paramEnum("NO_RESET_NOTIFICATION");
                        break block0;
                    }
                    case 200706: {
                        mc.paramEnum("GLFW_LOSE_CONTEXT_ON_RESET");
                        break block0;
                    }
                }
                mc.param(value);
                break;
            }
            case 139273: {
                mc.paramEnum("GLFW_CONTEXT_RELEASE_BEHAVIOR");
                switch (value) {
                    case 0: {
                        mc.paramEnum("GLFW_ANY_RELEASE_BEHAVIOR");
                        break block0;
                    }
                    case 217089: {
                        mc.paramEnum("GLFW_RELEASE_BEHAVIOR_FLUSH");
                        break block0;
                    }
                    case 217090: {
                        mc.paramEnum("GLFW_RELEASE_BEHAVIOR_NONE");
                        break block0;
                    }
                }
                mc.param(value);
                break;
            }
            case 139274: {
                mc.paramEnum("GLFW_CONTEXT_NO_ERROR");
                GLFW.printBoolean(mc, value);
                break;
            }
            case 139270: {
                mc.paramEnum("GLFW_OPENGL_FORWARD_COMPAT");
                GLFW.printBoolean(mc, value);
                break;
            }
            case 139271: {
                mc.paramEnum("GLFW_OPENGL_DEBUG_CONTEXT");
                GLFW.printBoolean(mc, value);
                break;
            }
            case 139272: {
                mc.paramEnum("GLFW_OPENGL_PROFILE");
                switch (value) {
                    case 0: {
                        mc.paramEnum("GLFW_OPENGL_ANY_PROFILE");
                        break block0;
                    }
                    case 204801: {
                        mc.paramEnum("GLFW_OPENGL_CORE_PROFILE");
                        break block0;
                    }
                    case 204802: {
                        mc.paramEnum("GLFW_OPENGL_COMPAT_PROFILE");
                        break block0;
                    }
                }
                mc.param(value);
                break;
            }
            case 143361: {
                mc.paramEnum("GLFW_COCOA_RETINA_FRAMEBUFFER");
                GLFW.printBoolean(mc, value);
                break;
            }
            case 143363: {
                mc.paramEnum("GLFW_COCOA_GRAPHICS_SWITCHING");
                GLFW.printBoolean(mc, value);
                break;
            }
            default: {
                mc.param(hint);
                mc.param(value);
            }
        }
    }

    public static long glfwCreateWindow(int width, int height, ByteBuffer title, long monitor, long share) {
        if (Properties.VALIDATE.enabled) {
            Context ctx;
            RT.checkGlfwMonitor(monitor);
            RT.checkGlfwWindow(share);
            org.lwjgl.glfw.GLFW.glfwWindowHint(139271, 1);
            if ((Platform.get() == Platform.WINDOWS || Properties.STRICT.enabled) && (ctx = Context.CONTEXTS.get(share)) != null && ctx.currentInThread != null && ctx.currentInThread != Thread.currentThread()) {
                RT.throwISEOrLogError("Context of share window[" + ctx.counter + "] is current in another thread [" + ctx.currentInThread + "]");
            }
        }
        long window = org.lwjgl.glfw.GLFW.glfwCreateWindow(width, height, title, monitor, share);
        GLFW.createWindow(window, share);
        return window;
    }

    public static long glfwCreateWindow(int width, int height, CharSequence title, long monitor, long share) {
        if (Properties.VALIDATE.enabled) {
            Context ctx;
            RT.checkGlfwMonitor(monitor);
            RT.checkGlfwWindow(share);
            org.lwjgl.glfw.GLFW.glfwWindowHint(139271, 1);
            if ((Platform.get() == Platform.WINDOWS || Properties.STRICT.enabled) && (ctx = Context.CONTEXTS.get(share)) != null && ctx.currentInThread != null && ctx.currentInThread != Thread.currentThread()) {
                RT.throwISEOrLogError("Context of share window[" + ctx.counter + "] is current in another thread [" + ctx.currentInThread + "]");
            }
        }
        long window = org.lwjgl.glfw.GLFW.glfwCreateWindow(width, height, title, monitor, share);
        GLFW.createWindow(window, share);
        return window;
    }

    public static void glfwMakeContextCurrent(long window) {
        Context ctx;
        if (window != 0L && Properties.VALIDATE.enabled && (ctx = Context.CONTEXTS.get(window)) != null && ctx.currentInThread != null && ctx.currentInThread != Thread.currentThread()) {
            RT.throwISEOrLogError("Context of window[" + ctx.counter + "] is current in another thread [" + Thread.currentThread() + "]");
        }
        org.lwjgl.glfw.GLFW.glfwMakeContextCurrent(window);
        if (window == 0L) {
            ctx = Context.CURRENT_CONTEXT.get();
            Context.CURRENT_CONTEXT.remove();
            if (ctx != null) {
                ctx.currentInThread = null;
            }
        } else {
            ctx = Context.CONTEXTS.get(window);
            Context.CURRENT_CONTEXT.set(ctx);
            if (ctx != null) {
                ctx.currentInThread = Thread.currentThread();
            }
        }
    }

    public static void glfwDestroyWindow(long window) {
        Context context;
        org.lwjgl.glfw.GLFW.glfwDestroyWindow(window);
        if (window == 0L) {
            return;
        }
        Context currentContext = Context.CURRENT_CONTEXT.get();
        if (currentContext != null && currentContext.window == window) {
            Context.CURRENT_CONTEXT.remove();
        }
        if ((context = Context.CONTEXTS.get(window)) != null) {
            context.destroy();
        }
        Context.CONTEXTS.remove(window);
    }

    private static void createWindow(long window, long share) {
        if (window != 0L) {
            Context.create(window, share);
        } else {
            Log.error("Failed to create GLFW window");
        }
    }

    public static void glfwSwapInterval(int interval, Void ret, MethodCall mc) {
        Context ctx = Context.CURRENT_CONTEXT.get();
        if (ctx != null && interval != 0) {
            long monitor = org.lwjgl.glfw.GLFW.glfwGetWindowMonitor(ctx.window);
            if (monitor == 0L) {
                monitor = org.lwjgl.glfw.GLFW.glfwGetPrimaryMonitor();
            }
            GLFWVidMode mode = org.lwjgl.glfw.GLFW.glfwGetVideoMode(monitor);
            int refreshRate = mode.refreshRate();
            mc.comment(refreshRate / Math.abs(interval) + " Hz");
        }
        mc.param(interval);
    }

    public static void glfwSwapBuffers(long window) {
        org.lwjgl.glfw.GLFW.glfwSwapBuffers(window);
        RT.frame();
    }
}

