/*
 * Decompiled with CFR 0.152.
 */
package org.lwjglx.debug;

import org.lwjglx.debug.org.objectweb.asm.MethodVisitor;

class Util {
    Util() {
    }

    static boolean isBuffer(String internalName) {
        return internalName.equals("java/nio/Buffer") || internalName.equals("java/nio/ByteBuffer") || internalName.equals("java/nio/CharBuffer") || internalName.equals("java/nio/ShortBuffer") || internalName.equals("java/nio/IntBuffer") || internalName.equals("java/nio/LongBuffer") || internalName.equals("java/nio/FloatBuffer") || internalName.equals("java/nio/DoubleBuffer");
    }

    static boolean isMultiByteWrite(String owner, String name) {
        if (owner.equals("java/nio/ByteBuffer") && (name.equals("putChar") || name.equals("putShort") || name.equals("putInt") || name.equals("putLong") || name.equals("putFloat") || name.equals("putDouble"))) {
            return true;
        }
        if (owner.equals("java/nio/CharBuffer") && name.equals("put")) {
            return true;
        }
        if (owner.equals("java/nio/ShortBuffer") && name.equals("put")) {
            return true;
        }
        if (owner.equals("java/nio/IntBuffer") && name.equals("put")) {
            return true;
        }
        if (owner.equals("java/nio/LongBuffer") && name.equals("put")) {
            return true;
        }
        if (owner.equals("java/nio/FloatBuffer") && name.equals("put")) {
            return true;
        }
        return owner.equals("java/nio/DoubleBuffer") && name.equals("put");
    }

    static boolean isTypedViewMethod(String name) {
        return name.equals("asCharBuffer") || name.equals("asShortBuffer") || name.equals("asIntBuffer") || name.equals("asLongBuffer") || name.equals("asFloatBuffer") || name.equals("asDoubleBuffer");
    }

    static void ldcI(MethodVisitor mv, int i) {
        if (i >= -1 && i <= 5) {
            mv.visitInsn(3 + i);
        } else if (i >= -128 && i <= 127) {
            mv.visitIntInsn(16, i);
        } else if (i >= Short.MIN_VALUE && i <= Short.MAX_VALUE) {
            mv.visitIntInsn(17, i);
        } else {
            mv.visitLdcInsn(i);
        }
    }
}

