/*
 * Decompiled with CFR 0.152.
 */
package org.lwjglx.debug;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import org.lwjgl.system.MemoryUtil;
import org.lwjglx.debug.Profiling;
import org.lwjglx.debug.org.eclipse.jetty.websocket.api.Session;
import org.lwjglx.debug.org.eclipse.jetty.websocket.api.WebSocketListener;

class ProfilingConnection
implements WebSocketListener {
    public static final List<ProfilingConnection> connections = new ArrayList<ProfilingConnection>();
    Session outbound;
    ByteBuffer buffer = ByteBuffer.allocateDirect(1024).order(ByteOrder.BIG_ENDIAN);
    long bufferAddr = MemoryUtil.memAddress0(this.buffer);
    Future<Void> lastSend = null;

    ProfilingConnection() {
    }

    public void send(long addr, int size) {
        if (this.lastSend != null && !this.lastSend.isDone()) {
            try {
                this.lastSend.get();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        MemoryUtil.memCopy(addr, this.bufferAddr, size);
        this.buffer.rewind();
        this.buffer.limit(size);
        this.lastSend = this.outbound.getRemote().sendBytesByFuture(this.buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onWebSocketClose(int statusCode, String reason) {
        this.outbound = null;
        List<ProfilingConnection> list = connections;
        synchronized (list) {
            connections.remove(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onWebSocketConnect(Session session) {
        this.outbound = session;
        List<ProfilingConnection> list = connections;
        synchronized (list) {
            connections.add(this);
        }
        Profiling.frontendConnected.countDown();
    }

    @Override
    public void onWebSocketError(Throwable cause) {
    }

    @Override
    public void onWebSocketText(String message) {
    }

    @Override
    public void onWebSocketBinary(byte[] arg0, int arg1, int arg2) {
    }
}

