/*
 * Decompiled with CFR 0.152.
 */
package org.lwjglx.debug;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.function.Supplier;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.lwjglx.debug.Context;
import org.lwjglx.debug.Properties;
import org.lwjglx.debug.RT;

public class Log {
    public static int maxSourceLength = 1;
    public static int maxLineNumberLength = 1;
    public static final PrintStream OUTPUT;

    private static void log(String level, String message) {
        Log.log(level, message, 2);
    }

    private static void log(String level, String message, int multiline) {
        Log.log(level, message, multiline, null);
    }

    private static void log(String level, String message, Throwable t) {
        Log.log(level, message, 2, t);
    }

    private static void log(String level, String message, int multiline, Throwable t) {
        Context context = Context.CURRENT_CONTEXT.get();
        String prefix = context != null ? "[" + level + "][" + context.counter + "] " : "[" + level + "] ";
        int indent = prefix.length();
        StringBuilder msg = new StringBuilder();
        String[] lines = message.split("(\r)?\n");
        int numLines = lines.length;
        int maxLineNumberLength = Integer.toString(numLines).length();
        indent -= maxLineNumberLength + 2;
        int lineNumber = 1;
        for (String line : lines) {
            for (int i = 0; lineNumber >= multiline && i < indent; ++i) {
                msg.append(" ");
            }
            if (lineNumber >= multiline) {
                msg.append(String.format("%1$" + maxLineNumberLength + "d", lineNumber - multiline + 1)).append("  ");
            }
            msg.append(line).append("\n");
            ++lineNumber;
        }
        indent = 2;
        if (t != null) {
            for (int i = 0; i < indent; ++i) {
                msg.append(" ");
            }
            indent += "Stacktrace: ".length();
            msg.append("Stacktrace: ");
            StackTraceElement[] st = t.getStackTrace();
            for (int i = 0; i < st.length; ++i) {
                if (i > 0) {
                    for (int ii = 0; ii < indent; ++ii) {
                        msg.append(" ");
                    }
                }
                msg.append(st[i].toString()).append("\n");
            }
        }
        OUTPUT.print(prefix + msg.toString());
    }

    public static void info(String message) {
        Log.log("info ", message, 2);
    }

    public static void info(String message, int multiline) {
        Log.log("info ", message, multiline);
    }

    public static void debug(String message) {
        if (Properties.DEBUG.enabled) {
            Log.log("debug", message);
        }
    }

    public static void error(String message) {
        Log.error(message, null);
    }

    public static void error(String message, Throwable t) {
        Log.log("error", message, t);
    }

    public static void warn(String message, Throwable t, int offset) {
        t = RT.filterStackTrace(t, offset);
        Log.log("warn", message, t);
    }

    public static void trace(String message) {
        Log.log("trace", message);
    }

    static {
        PrintStream outStream = System.err;
        if (Properties.OUTPUT != null && !Properties.OUTPUT.trim().isEmpty()) {
            File out = new File(Properties.OUTPUT).getAbsoluteFile();
            if (!out.getParentFile().exists()) {
                throw new AssertionError((Object)("Directory to create log output file in does not exist: " + out.getParentFile().getAbsolutePath()));
            }
            try {
                OutputStream os = new FileOutputStream(out);
                if (out.getName().toLowerCase().endsWith(".zip")) {
                    final ZipOutputStream zos = new ZipOutputStream(os);
                    zos.setLevel(9);
                    zos.putNextEntry(new ZipEntry(out.getName().substring(0, out.getName().length() - 4)));
                    os = zos;
                    Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                zos.closeEntry();
                                zos.finish();
                                zos.flush();
                                zos.close();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    }));
                } else if (out.getName().toLowerCase().endsWith(".gz")) {
                    final GZIPOutputStream zos = new GZIPOutputStream(os);
                    os = zos;
                    Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                zos.finish();
                                zos.flush();
                                zos.close();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    }));
                }
                outStream = new PrintStream(os);
            }
            catch (Exception e) {
                throw new AssertionError((Object)("Failed to create log output file: " + out.getAbsolutePath()));
            }
        }
        OUTPUT = outStream;
    }

    public static class LineBreakingStringBuilder {
        private final int indent = 4;
        private final int maxLength = 80;
        private final StringBuilder sb = new StringBuilder();
        private int currentLength = 0;

        public void append(String str) {
            if (this.currentLength + str.length() > 80) {
                this.sb.append("\n");
                for (int i = 0; i < 4; ++i) {
                    this.sb.append(" ");
                }
                this.currentLength = 0;
            }
            this.sb.append(str);
            this.currentLength += str.length();
        }

        public String toString() {
            return this.sb.toString();
        }
    }

    public static class DebugStreamFactory
    implements Supplier<PrintStream> {
        @Override
        public PrintStream get() {
            return OUTPUT;
        }
    }
}

