/*
 * Decompiled with CFR 0.152.
 */
package org.lwjglx.debug;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjglx.debug.ClassKey;
import org.lwjglx.debug.ClassMetadata;
import org.lwjglx.debug.ClassUtils;
import org.lwjglx.debug.GLmetadata;
import org.lwjglx.debug.InterceptedCall;
import org.lwjglx.debug.Log;
import org.lwjglx.debug.Method;
import org.lwjglx.debug.Properties;
import org.lwjglx.debug.RT;
import org.lwjglx.debug.Util;
import org.lwjglx.debug.org.objectweb.asm.ClassReader;
import org.lwjglx.debug.org.objectweb.asm.ClassVisitor;
import org.lwjglx.debug.org.objectweb.asm.ClassWriter;
import org.lwjglx.debug.org.objectweb.asm.MethodVisitor;
import org.lwjglx.debug.org.objectweb.asm.Opcodes;
import org.lwjglx.debug.org.objectweb.asm.Type;
import org.lwjglx.debug.org.objectweb.asm.util.TraceClassVisitor;

class InterceptClassGenerator
implements Opcodes {
    private static final String MethodCall_InternalName = "org/lwjglx/debug/MethodCall";
    private static final String MethodCall_Desc = "Lorg/lwjglx/debug/MethodCall;";
    private static final String RT_InternalName = "org/lwjglx/debug/RT";
    private static final Map<ClassKey, HashSet<Method>> declaredMethods = new ConcurrentHashMap<ClassKey, HashSet<Method>>();

    InterceptClassGenerator() {
    }

    private static boolean isGLcall(InterceptedCall call) {
        return (call.name.startsWith("gl") || call.name.startsWith("ngl")) && call.resolvedReceiverInternalName.startsWith("org/lwjgl/opengl/") && (!Properties.PROFILE.enabled || !call.resolvedReceiverInternalName.equals("org/lwjgl/opengl/GREMEDYStringMarker") && !call.resolvedReceiverInternalName.equals("org/lwjgl/opengl/GREMEDYFrameTerminator"));
    }

    private static String glCall(InterceptedCall call) {
        if (!InterceptClassGenerator.isGLcall(call)) {
            return null;
        }
        String name = call.name;
        if (name.startsWith("ngl")) {
            name = name.substring(1);
        }
        try {
            GLCapabilities.class.getField(name);
            return name;
        }
        catch (Exception e) {
            String nameV = name + "v";
            try {
                GLCapabilities.class.getField(nameV);
                return nameV;
            }
            catch (Exception e2) {
                if (Properties.DEBUG.enabled) {
                    Log.debug("Expected field GLCapabilities." + name + " to exist");
                }
                return null;
            }
        }
    }

    private static boolean isMainThreadMethod(InterceptedCall call) {
        if (call.resolvedReceiverInternalName.equals("org/lwjgl/glfw/GLFW")) {
            return Arrays.asList("glfwInit", "glfwTerminate", "glfwCreateWindow", "glfwDefaultWindowHints", "glfwDestroyWindow", "glfwFocusWindow", "glfwGetFramebufferSize", "glfwGetWindowAttrib", "glfwGetWindowFrameSize", "glfwGetWindowMonitor", "glfwGetWindowPos", "glfwGetWindowSize", "glfwHideWindow", "glfwIconifyWindow", "glfwMaximizeWindow", "glfwPollEvents", "glfwRestoreWindow", "glfwSetFramebufferSizeCallback", "glfwSetWindowAspectRatio", "glfwSetWindowCloseCallback", "glfwSetWindowFocusCallback", "glfwSetWindowIcon", "glfwSetWindowIconifyCallback", "glfwSetWindowMonitor", "glfwSetWindowPos", "glfwSetWindowPosCallback", "glfwSetWindowRefreshCallback", "glfwSetWindowSize", "glfwSetWindowSizeCallback", "glfwSetWindowSizeLimits", "glfwSetWindowTitle", "glfwShowWindow", "glfwWaitEvents", "glfwWaitEventsTimeout", "glfwWindowHint").contains(call.name);
        }
        return false;
    }

    private static boolean requiresGlfwInit(InterceptedCall call) {
        if (call.resolvedReceiverInternalName.equals("org/lwjgl/glfw/GLFW")) {
            return call.name.startsWith("glfw") && !call.name.equals("glfwSetErrorCallback") && !call.name.equals("glfwInit");
        }
        return false;
    }

    private static void checkFunctionSupported(MethodVisitor mv, String name) {
        mv.visitFieldInsn(180, "org/lwjgl/opengl/GLCapabilities", name, "J");
        mv.visitLdcInsn(name);
        mv.visitMethodInsn(184, RT_InternalName, "checkFunction", "(JLjava/lang/String;)V", false);
    }

    private static String getClassForMethod(ClassLoader cl, String desc, InterceptedCall call) {
        Method searched;
        String className = call.resolvedReceiverInternalName.replace("org/lwjgl/", "org/lwjglx/debug/");
        ClassKey key = new ClassKey(cl, className);
        HashSet<Method> dmethods = declaredMethods.get(key);
        if (dmethods == null) {
            ClassReader cr;
            dmethods = new HashSet();
            declaredMethods.put(key, dmethods);
            InputStream is = cl.getResourceAsStream(className + ".class");
            if (is == null) {
                return null;
            }
            try {
                cr = new ClassReader(is);
            }
            catch (IOException e) {
                return null;
            }
            final HashSet<Method> methods = dmethods;
            cr.accept(new ClassVisitor(393216){

                @Override
                public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                    boolean isPublic;
                    boolean isStatic = (access & 8) != 0;
                    boolean bl = isPublic = (access & 1) != 0;
                    if (!isStatic || !isPublic) {
                        return null;
                    }
                    methods.add(new Method(name, desc));
                    return null;
                }
            }, 7);
        }
        if (dmethods.contains(searched = new Method(call.name, desc))) {
            return className;
        }
        return null;
    }

    public static Class<?> generate(ClassLoader classLoader, String proxyInternalName, String callerName, Collection<InterceptedCall> calls, String source) {
        ClassWriter cw = new ClassWriter(1);
        cw.visit(50, 4129, proxyInternalName, null, "java/lang/Object", null);
        MethodVisitor ctor = cw.visitMethod(4098, "<init>", "()V", null, null);
        ctor.visitCode();
        ctor.visitVarInsn(25, 0);
        ctor.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
        ctor.visitInsn(177);
        ctor.visitMaxs(-1, -1);
        ctor.visitEnd();
        for (InterceptedCall call : calls) {
            String effectiveDesc = call.desc;
            if (Properties.TRACE.enabled) {
                effectiveDesc = call.desc.substring(0, call.desc.lastIndexOf(41)) + "I" + call.desc.substring(call.desc.lastIndexOf(41));
            }
            MethodVisitor mv = cw.visitMethod(4105, call.generatedMethodName, effectiveDesc, null, null);
            mv.visitCode();
            if (Properties.VALIDATE.enabled) {
                if (InterceptClassGenerator.isMainThreadMethod(call)) {
                    mv.visitLdcInsn(call.name);
                    mv.visitMethodInsn(184, RT_InternalName, "checkMainThread", "(Ljava/lang/String;)V", false);
                }
                if (InterceptClassGenerator.requiresGlfwInit(call)) {
                    mv.visitLdcInsn(call.name);
                    mv.visitMethodInsn(184, RT_InternalName, "checkGlfwInitialized", "(Ljava/lang/String;)V", false);
                }
            }
            Type[] paramTypes = Type.getArgumentTypes(call.desc);
            Type retType = Type.getReturnType(call.desc);
            ClassMetadata classMetadata = ClassMetadata.create(call.resolvedReceiverInternalName, classLoader);
            ClassMetadata.MethodInfo minfo = classMetadata.methods.get(call.name + call.desc);
            int var = InterceptClassGenerator.loadArgumentsAndValidateArguments(mv, paramTypes, classMetadata, minfo);
            int lineVar = var++;
            call.glName = InterceptClassGenerator.glCall(call);
            if (call.glName != null) {
                if (Properties.VALIDATE.enabled) {
                    mv.visitMethodInsn(184, "org/lwjgl/opengl/GL", "getCapabilities", "()Lorg/lwjgl/opengl/GLCapabilities;", false);
                    InterceptClassGenerator.checkFunctionSupported(mv, call.glName);
                }
                if (Properties.PROFILE.enabled) {
                    mv.visitMethodInsn(184, RT_InternalName, "glCall", "()V", false);
                }
            }
            InterceptClassGenerator.sleep(mv);
            if (Properties.TRACE.enabled) {
                String traceMethodDesc = InterceptClassGenerator.buildTraceMethodDesc(call, retType);
                if (source != null) {
                    mv.visitLdcInsn(source);
                } else {
                    mv.visitInsn(1);
                }
                mv.visitVarInsn(21, lineVar);
                mv.visitLdcInsn(call.name);
                mv.visitMethodInsn(184, RT_InternalName, "methodCall", "(Ljava/lang/String;ILjava/lang/String;)Lorg/lwjglx/debug/MethodCall;", false);
                int methodCallVar = var++;
                String traceMethodOwnerName = InterceptClassGenerator.getClassForMethod(classLoader, traceMethodDesc, call);
                if (traceMethodOwnerName != null) {
                    mv.visitVarInsn(58, methodCallVar);
                    InterceptClassGenerator.callUserMethodOrDirect(classLoader, call, mv);
                    int retVar = var++;
                    if (retType.getSort() != 0) {
                        mv.visitVarInsn(retType.getOpcode(54), retVar);
                    }
                    InterceptClassGenerator.loadArguments(mv, paramTypes);
                    if (retType.getSort() != 0) {
                        mv.visitVarInsn(retType.getOpcode(21), retVar);
                    } else {
                        mv.visitInsn(1);
                    }
                    mv.visitVarInsn(25, methodCallVar);
                    mv.visitMethodInsn(184, traceMethodOwnerName, call.name, traceMethodDesc, false);
                    mv.visitVarInsn(25, methodCallVar);
                    mv.visitMethodInsn(184, RT_InternalName, "methodCall", "(Lorg/lwjglx/debug/MethodCall;)V", false);
                    if (retType.getSort() != 0) {
                        mv.visitVarInsn(retType.getOpcode(21), retVar);
                    }
                } else {
                    mv.visitInsn(89);
                    mv.visitVarInsn(58, methodCallVar);
                    InterceptClassGenerator.generateDefaultTraceBefore(call, mv, paramTypes, minfo);
                    InterceptClassGenerator.callUserMethodOrDirect(classLoader, call, mv);
                    InterceptClassGenerator.generateDefaultTraceAfter(call, mv, methodCallVar, retType, minfo);
                }
            } else {
                InterceptClassGenerator.callUserMethodOrDirect(classLoader, call, mv);
            }
            mv.visitInsn(retType.getOpcode(172));
            mv.visitMaxs(-1, -1);
            mv.visitEnd();
        }
        cw.visitEnd();
        byte[] arr = cw.toByteArray();
        if (Properties.DEBUG.enabled) {
            Log.debug("Created proxy class for [" + callerName + "] (" + String.format("%,d", arr.length) + " bytes)");
            TraceClassVisitor tcv = new TraceClassVisitor(new PrintWriter(System.err));
            ClassReader tcr = new ClassReader(arr);
            tcr.accept(tcv, 0);
        }
        Class generatedClass = ClassUtils.defineClass(classLoader, RT.class, proxyInternalName, arr);
        return generatedClass;
    }

    private static String buildTraceMethodDesc(InterceptedCall call, Type retType) {
        String traceMethodDesc = call.desc.substring(0, call.desc.lastIndexOf(41));
        traceMethodDesc = retType.getSort() != 0 ? traceMethodDesc + retType.getDescriptor() : traceMethodDesc + "Ljava/lang/Void;";
        traceMethodDesc = traceMethodDesc + MethodCall_Desc;
        traceMethodDesc = traceMethodDesc + ")V";
        return traceMethodDesc;
    }

    private static void sleep(MethodVisitor mv) {
        if (Properties.SLEEP > 0L) {
            mv.visitMethodInsn(184, RT_InternalName, "delay", "()V", false);
        }
    }

    private static int loadArgumentsAndValidateArguments(MethodVisitor mv, Type[] paramTypes, ClassMetadata classMetadata, ClassMetadata.MethodInfo minfo) {
        int var = 0;
        for (int i = 0; i < paramTypes.length; ++i) {
            Type paramType = paramTypes[i];
            mv.visitVarInsn(paramType.getOpcode(21), var);
            if (Properties.VALIDATE.enabled) {
                if (paramType.getSort() == 10 && Util.isBuffer(paramType.getInternalName())) {
                    mv.visitInsn(89);
                    mv.visitLdcInsn(minfo.name);
                    mv.visitMethodInsn(184, RT_InternalName, "checkBuffer", "(" + paramType.getDescriptor() + "Ljava/lang/String;)V", false);
                }
                if (ClassMetadata.hasNullables && (paramType.getSort() == 10 || paramType.getSort() == 9) && !minfo.nullable[i]) {
                    mv.visitInsn(89);
                    mv.visitLdcInsn(i);
                    if (minfo.parameterNames[i] != null) {
                        mv.visitLdcInsn(minfo.parameterNames[i]);
                    } else {
                        mv.visitInsn(1);
                    }
                    mv.visitMethodInsn(184, RT_InternalName, "checkNotNull", "(Ljava/lang/Object;ILjava/lang/String;)V", false);
                }
            }
            var += paramType.getSize();
        }
        return var;
    }

    private static void loadArguments(MethodVisitor mv, Type[] paramTypes) {
        int var = 0;
        for (int i = 0; i < paramTypes.length; ++i) {
            Type paramType = paramTypes[i];
            mv.visitVarInsn(paramType.getOpcode(21), var);
            var += paramType.getSize();
        }
    }

    private static void callUserMethodOrDirect(ClassLoader classLoader, InterceptedCall call, MethodVisitor mv) {
        String validationMethodOwnerName = InterceptClassGenerator.getClassForMethod(classLoader, call.desc, call);
        if (validationMethodOwnerName != null) {
            mv.visitMethodInsn(184, validationMethodOwnerName, call.name, call.desc, false);
        } else {
            mv.visitMethodInsn(184, call.resolvedReceiverInternalName, call.name, call.desc, false);
        }
        if (Properties.VALIDATE.enabled && call.glName != null && !call.glName.equals("glGetError")) {
            mv.visitLdcInsn(call.name);
            mv.visitMethodInsn(184, RT_InternalName, "checkError", "(Ljava/lang/String;)V", false);
        }
    }

    private static int loadGLenum(String name, String helperMethod, MethodVisitor mv, int var, int glEnumIndex) {
        String fieldName = name;
        try {
            GLmetadata.class.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            fieldName = fieldName + "v";
        }
        mv.visitMethodInsn(184, "org/lwjglx/debug/GLmetadata", fieldName, "()Lorg/lwjglx/debug/Command;", false);
        Util.ldcI(mv, glEnumIndex);
        mv.visitVarInsn(21, var);
        mv.visitMethodInsn(184, RT_InternalName, helperMethod, "(Lorg/lwjglx/debug/Command;II)Ljava/lang/String;", false);
        mv.visitMethodInsn(182, MethodCall_InternalName, "paramEnum", "(Ljava/lang/String;)Lorg/lwjglx/debug/MethodCall;", false);
        return ++glEnumIndex;
    }

    private static void loadGLenumReturn(String name, String helperMethod, MethodVisitor mv) {
        String fieldName = name;
        try {
            GLmetadata.class.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            fieldName = fieldName + "v";
        }
        mv.visitMethodInsn(184, "org/lwjglx/debug/GLmetadata", fieldName, "()Lorg/lwjglx/debug/Command;", false);
        mv.visitMethodInsn(184, RT_InternalName, helperMethod, "(ILorg/lwjglx/debug/MethodCall;Lorg/lwjglx/debug/Command;)I", false);
    }

    private static void generateDefaultTraceBefore(InterceptedCall call, MethodVisitor mv, Type[] paramTypes, ClassMetadata.MethodInfo minfo) {
        int var = 0;
        int glEnumIndex = 0;
        for (int i = 0; i < paramTypes.length; ++i) {
            Type paramType = paramTypes[i];
            String nativeType = minfo.parameterNativeTypes[i];
            if ("GLenum".equals(nativeType) || "GLboolean".equals(nativeType)) {
                glEnumIndex = InterceptClassGenerator.loadGLenum(call.glName, "glEnumFor", mv, var, glEnumIndex);
            } else if ("GLbitfield".equals(nativeType)) {
                glEnumIndex = InterceptClassGenerator.loadGLenum(call.glName, "decodeBitField", mv, var, glEnumIndex);
            } else if ("GLFWwindow *".equals(nativeType)) {
                mv.visitVarInsn(paramType.getOpcode(21), var);
                mv.visitMethodInsn(184, RT_InternalName, "paramGlfwWindow", "(Lorg/lwjglx/debug/MethodCall;" + paramType.getDescriptor() + ")" + MethodCall_Desc, false);
            } else if ("GLFWmonitor *".equals(nativeType)) {
                mv.visitVarInsn(paramType.getOpcode(21), var);
                mv.visitMethodInsn(184, RT_InternalName, "paramGlfwMonitor", "(Lorg/lwjglx/debug/MethodCall;" + paramType.getDescriptor() + ")" + MethodCall_Desc, false);
            } else {
                mv.visitVarInsn(paramType.getOpcode(21), var);
                if (paramType.getSort() == 9 || paramType.getSort() == 10) {
                    mv.visitMethodInsn(182, MethodCall_InternalName, "param", "(Ljava/lang/Object;)Lorg/lwjglx/debug/MethodCall;", false);
                } else {
                    mv.visitMethodInsn(182, MethodCall_InternalName, "param", "(" + paramType.getDescriptor() + ")" + MethodCall_Desc, false);
                }
            }
            var += paramType.getSize();
        }
        mv.visitInsn(87);
    }

    private static void generateDefaultTraceAfter(InterceptedCall call, MethodVisitor mv, int mcvar, Type retType, ClassMetadata.MethodInfo minfo) {
        if (retType.getSort() != 0) {
            if (retType.getSort() == 9 || retType.getSort() == 10) {
                mv.visitVarInsn(25, mcvar);
                mv.visitMethodInsn(184, RT_InternalName, "returnValue", "(Ljava/lang/Object;Lorg/lwjglx/debug/MethodCall;)Ljava/lang/Object;", false);
                if (!"java/lang/Object".equals(retType.getInternalName())) {
                    mv.visitTypeInsn(192, retType.getInternalName());
                }
            } else {
                mv.visitVarInsn(25, mcvar);
                String returnNativeType = minfo.returnNativeType;
                if ("GLenum".equals(returnNativeType) || "GLboolean".equals(returnNativeType)) {
                    InterceptClassGenerator.loadGLenumReturn(call.glName, "glEnumReturn", mv);
                } else if ("GLFWwindow *".equals(returnNativeType)) {
                    mv.visitMethodInsn(184, RT_InternalName, "returnValueGlfwWindow", "(" + retType.getDescriptor() + MethodCall_Desc + ")" + retType.getDescriptor(), false);
                } else if ("GLFWmonitor *".equals(returnNativeType)) {
                    mv.visitMethodInsn(184, RT_InternalName, "returnValueGlfwMonitor", "(" + retType.getDescriptor() + MethodCall_Desc + ")" + retType.getDescriptor(), false);
                } else {
                    mv.visitMethodInsn(184, RT_InternalName, "returnValue", "(" + retType.getDescriptor() + MethodCall_Desc + ")" + retType.getDescriptor(), false);
                }
            }
        }
        mv.visitVarInsn(25, mcvar);
        mv.visitMethodInsn(184, RT_InternalName, "methodCall", "(Lorg/lwjglx/debug/MethodCall;)V", false);
    }
}

