/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkXYColorEXT
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int X;
    public static final int Y;

    VkXYColorEXT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkXYColorEXT(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkXYColorEXT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public float x() {
        return VkXYColorEXT.nx(this.address());
    }

    public float y() {
        return VkXYColorEXT.ny(this.address());
    }

    public VkXYColorEXT x(float value) {
        VkXYColorEXT.nx(this.address(), value);
        return this;
    }

    public VkXYColorEXT y(float value) {
        VkXYColorEXT.ny(this.address(), value);
        return this;
    }

    public VkXYColorEXT set(float x, float y) {
        this.x(x);
        this.y(y);
        return this;
    }

    public VkXYColorEXT set(VkXYColorEXT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkXYColorEXT malloc() {
        return VkXYColorEXT.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkXYColorEXT calloc() {
        return VkXYColorEXT.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkXYColorEXT create() {
        return new VkXYColorEXT(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkXYColorEXT create(long address) {
        return new VkXYColorEXT(address, null);
    }

    @Nullable
    public static VkXYColorEXT createSafe(long address) {
        return address == 0L ? null : VkXYColorEXT.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkXYColorEXT.create(VkXYColorEXT.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkXYColorEXT.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkXYColorEXT.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkXYColorEXT.create(address, capacity);
    }

    public static VkXYColorEXT mallocStack() {
        return VkXYColorEXT.mallocStack(MemoryStack.stackGet());
    }

    public static VkXYColorEXT callocStack() {
        return VkXYColorEXT.callocStack(MemoryStack.stackGet());
    }

    public static VkXYColorEXT mallocStack(MemoryStack stack) {
        return VkXYColorEXT.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkXYColorEXT callocStack(MemoryStack stack) {
        return VkXYColorEXT.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkXYColorEXT.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkXYColorEXT.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkXYColorEXT.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkXYColorEXT.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static float nx(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)X);
    }

    public static float ny(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)Y);
    }

    public static void nx(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)X, value);
    }

    public static void ny(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)Y, value);
    }

    static {
        Struct.Layout layout = VkXYColorEXT.__struct(VkXYColorEXT.__member(4), VkXYColorEXT.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        X = layout.offsetof(0);
        Y = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<VkXYColorEXT, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkXYColorEXT newInstance(long address) {
            return new VkXYColorEXT(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        public float x() {
            return VkXYColorEXT.nx(this.address());
        }

        public float y() {
            return VkXYColorEXT.ny(this.address());
        }

        public Buffer x(float value) {
            VkXYColorEXT.nx(this.address(), value);
            return this;
        }

        public Buffer y(float value) {
            VkXYColorEXT.ny(this.address(), value);
            return this;
        }
    }
}

