/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkDescriptorBufferInfo;
import org.lwjgl.vulkan.VkDescriptorImageInfo;

public class VkWriteDescriptorSet
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int DSTSET;
    public static final int DSTBINDING;
    public static final int DSTARRAYELEMENT;
    public static final int DESCRIPTORCOUNT;
    public static final int DESCRIPTORTYPE;
    public static final int PIMAGEINFO;
    public static final int PBUFFERINFO;
    public static final int PTEXELBUFFERVIEW;

    VkWriteDescriptorSet(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkWriteDescriptorSet(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkWriteDescriptorSet.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkWriteDescriptorSet.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkWriteDescriptorSet.npNext(this.address());
    }

    @NativeType(value="VkDescriptorSet")
    public long dstSet() {
        return VkWriteDescriptorSet.ndstSet(this.address());
    }

    @NativeType(value="uint32_t")
    public int dstBinding() {
        return VkWriteDescriptorSet.ndstBinding(this.address());
    }

    @NativeType(value="uint32_t")
    public int dstArrayElement() {
        return VkWriteDescriptorSet.ndstArrayElement(this.address());
    }

    @NativeType(value="uint32_t")
    public int descriptorCount() {
        return VkWriteDescriptorSet.ndescriptorCount(this.address());
    }

    @NativeType(value="VkDescriptorType")
    public int descriptorType() {
        return VkWriteDescriptorSet.ndescriptorType(this.address());
    }

    @Nullable
    @NativeType(value="VkDescriptorImageInfo const *")
    public VkDescriptorImageInfo.Buffer pImageInfo() {
        return VkWriteDescriptorSet.npImageInfo(this.address());
    }

    @Nullable
    @NativeType(value="VkDescriptorBufferInfo const *")
    public VkDescriptorBufferInfo.Buffer pBufferInfo() {
        return VkWriteDescriptorSet.npBufferInfo(this.address());
    }

    @Nullable
    @NativeType(value="VkBufferView const *")
    public LongBuffer pTexelBufferView() {
        return VkWriteDescriptorSet.npTexelBufferView(this.address());
    }

    public VkWriteDescriptorSet sType(@NativeType(value="VkStructureType") int value) {
        VkWriteDescriptorSet.nsType(this.address(), value);
        return this;
    }

    public VkWriteDescriptorSet pNext(@NativeType(value="void const *") long value) {
        VkWriteDescriptorSet.npNext(this.address(), value);
        return this;
    }

    public VkWriteDescriptorSet dstSet(@NativeType(value="VkDescriptorSet") long value) {
        VkWriteDescriptorSet.ndstSet(this.address(), value);
        return this;
    }

    public VkWriteDescriptorSet dstBinding(@NativeType(value="uint32_t") int value) {
        VkWriteDescriptorSet.ndstBinding(this.address(), value);
        return this;
    }

    public VkWriteDescriptorSet dstArrayElement(@NativeType(value="uint32_t") int value) {
        VkWriteDescriptorSet.ndstArrayElement(this.address(), value);
        return this;
    }

    public VkWriteDescriptorSet descriptorType(@NativeType(value="VkDescriptorType") int value) {
        VkWriteDescriptorSet.ndescriptorType(this.address(), value);
        return this;
    }

    public VkWriteDescriptorSet pImageInfo(@Nullable @NativeType(value="VkDescriptorImageInfo const *") VkDescriptorImageInfo.Buffer value) {
        VkWriteDescriptorSet.npImageInfo(this.address(), value);
        return this;
    }

    public VkWriteDescriptorSet pBufferInfo(@Nullable @NativeType(value="VkDescriptorBufferInfo const *") VkDescriptorBufferInfo.Buffer value) {
        VkWriteDescriptorSet.npBufferInfo(this.address(), value);
        return this;
    }

    public VkWriteDescriptorSet pTexelBufferView(@Nullable @NativeType(value="VkBufferView const *") LongBuffer value) {
        VkWriteDescriptorSet.npTexelBufferView(this.address(), value);
        return this;
    }

    public VkWriteDescriptorSet set(int sType, long pNext, long dstSet, int dstBinding, int dstArrayElement, int descriptorType, @Nullable VkDescriptorImageInfo.Buffer pImageInfo, @Nullable VkDescriptorBufferInfo.Buffer pBufferInfo, @Nullable LongBuffer pTexelBufferView) {
        this.sType(sType);
        this.pNext(pNext);
        this.dstSet(dstSet);
        this.dstBinding(dstBinding);
        this.dstArrayElement(dstArrayElement);
        this.descriptorType(descriptorType);
        this.pImageInfo(pImageInfo);
        this.pBufferInfo(pBufferInfo);
        this.pTexelBufferView(pTexelBufferView);
        return this;
    }

    public VkWriteDescriptorSet set(VkWriteDescriptorSet src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkWriteDescriptorSet malloc() {
        return VkWriteDescriptorSet.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkWriteDescriptorSet calloc() {
        return VkWriteDescriptorSet.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkWriteDescriptorSet create() {
        return new VkWriteDescriptorSet(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkWriteDescriptorSet create(long address) {
        return new VkWriteDescriptorSet(address, null);
    }

    @Nullable
    public static VkWriteDescriptorSet createSafe(long address) {
        return address == 0L ? null : VkWriteDescriptorSet.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkWriteDescriptorSet.create(VkWriteDescriptorSet.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkWriteDescriptorSet.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkWriteDescriptorSet.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkWriteDescriptorSet.create(address, capacity);
    }

    public static VkWriteDescriptorSet mallocStack() {
        return VkWriteDescriptorSet.mallocStack(MemoryStack.stackGet());
    }

    public static VkWriteDescriptorSet callocStack() {
        return VkWriteDescriptorSet.callocStack(MemoryStack.stackGet());
    }

    public static VkWriteDescriptorSet mallocStack(MemoryStack stack) {
        return VkWriteDescriptorSet.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkWriteDescriptorSet callocStack(MemoryStack stack) {
        return VkWriteDescriptorSet.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkWriteDescriptorSet.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkWriteDescriptorSet.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkWriteDescriptorSet.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkWriteDescriptorSet.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static long ndstSet(long struct) {
        return MemoryUtil.memGetLong(struct + (long)DSTSET);
    }

    public static int ndstBinding(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DSTBINDING);
    }

    public static int ndstArrayElement(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DSTARRAYELEMENT);
    }

    public static int ndescriptorCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DESCRIPTORCOUNT);
    }

    public static int ndescriptorType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DESCRIPTORTYPE);
    }

    @Nullable
    public static VkDescriptorImageInfo.Buffer npImageInfo(long struct) {
        return VkDescriptorImageInfo.createSafe(MemoryUtil.memGetAddress(struct + (long)PIMAGEINFO), VkWriteDescriptorSet.ndescriptorCount(struct));
    }

    @Nullable
    public static VkDescriptorBufferInfo.Buffer npBufferInfo(long struct) {
        return VkDescriptorBufferInfo.createSafe(MemoryUtil.memGetAddress(struct + (long)PBUFFERINFO), VkWriteDescriptorSet.ndescriptorCount(struct));
    }

    @Nullable
    public static LongBuffer npTexelBufferView(long struct) {
        return MemoryUtil.memLongBufferSafe(MemoryUtil.memGetAddress(struct + (long)PTEXELBUFFERVIEW), VkWriteDescriptorSet.ndescriptorCount(struct));
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void ndstSet(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)DSTSET, value);
    }

    public static void ndstBinding(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)DSTBINDING, value);
    }

    public static void ndstArrayElement(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)DSTARRAYELEMENT, value);
    }

    public static void ndescriptorCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)DESCRIPTORCOUNT, value);
    }

    public static void ndescriptorType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)DESCRIPTORTYPE, value);
    }

    public static void npImageInfo(long struct, @Nullable VkDescriptorImageInfo.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)PIMAGEINFO, MemoryUtil.memAddressSafe(value));
        if (value != null) {
            VkWriteDescriptorSet.ndescriptorCount(struct, value.remaining());
        }
    }

    public static void npBufferInfo(long struct, @Nullable VkDescriptorBufferInfo.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)PBUFFERINFO, MemoryUtil.memAddressSafe(value));
        if (value != null) {
            VkWriteDescriptorSet.ndescriptorCount(struct, value.remaining());
        }
    }

    public static void npTexelBufferView(long struct, @Nullable LongBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PTEXELBUFFERVIEW, MemoryUtil.memAddressSafe(value));
        if (value != null) {
            VkWriteDescriptorSet.ndescriptorCount(struct, value.remaining());
        }
    }

    public static void validate(long struct) {
        int descriptorCount = VkWriteDescriptorSet.ndescriptorCount(struct);
        if (descriptorCount == 0 || MemoryUtil.memGetAddress(struct + (long)PIMAGEINFO) == 0L && MemoryUtil.memGetAddress(struct + (long)PBUFFERINFO) == 0L && MemoryUtil.memGetAddress(struct + (long)PTEXELBUFFERVIEW) == 0L) {
            throw new NullPointerException("At least one of pImageInfo, pBufferInfo, pTexelBufferView must not be null");
        }
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            VkWriteDescriptorSet.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = VkWriteDescriptorSet.__struct(VkWriteDescriptorSet.__member(4), VkWriteDescriptorSet.__member(POINTER_SIZE), VkWriteDescriptorSet.__member(8), VkWriteDescriptorSet.__member(4), VkWriteDescriptorSet.__member(4), VkWriteDescriptorSet.__member(4), VkWriteDescriptorSet.__member(4), VkWriteDescriptorSet.__member(POINTER_SIZE), VkWriteDescriptorSet.__member(POINTER_SIZE), VkWriteDescriptorSet.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        DSTSET = layout.offsetof(2);
        DSTBINDING = layout.offsetof(3);
        DSTARRAYELEMENT = layout.offsetof(4);
        DESCRIPTORCOUNT = layout.offsetof(5);
        DESCRIPTORTYPE = layout.offsetof(6);
        PIMAGEINFO = layout.offsetof(7);
        PBUFFERINFO = layout.offsetof(8);
        PTEXELBUFFERVIEW = layout.offsetof(9);
    }

    public static class Buffer
    extends StructBuffer<VkWriteDescriptorSet, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkWriteDescriptorSet newInstance(long address) {
            return new VkWriteDescriptorSet(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkWriteDescriptorSet.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkWriteDescriptorSet.npNext(this.address());
        }

        @NativeType(value="VkDescriptorSet")
        public long dstSet() {
            return VkWriteDescriptorSet.ndstSet(this.address());
        }

        @NativeType(value="uint32_t")
        public int dstBinding() {
            return VkWriteDescriptorSet.ndstBinding(this.address());
        }

        @NativeType(value="uint32_t")
        public int dstArrayElement() {
            return VkWriteDescriptorSet.ndstArrayElement(this.address());
        }

        @NativeType(value="uint32_t")
        public int descriptorCount() {
            return VkWriteDescriptorSet.ndescriptorCount(this.address());
        }

        @NativeType(value="VkDescriptorType")
        public int descriptorType() {
            return VkWriteDescriptorSet.ndescriptorType(this.address());
        }

        @Nullable
        @NativeType(value="VkDescriptorImageInfo const *")
        public VkDescriptorImageInfo.Buffer pImageInfo() {
            return VkWriteDescriptorSet.npImageInfo(this.address());
        }

        @Nullable
        @NativeType(value="VkDescriptorBufferInfo const *")
        public VkDescriptorBufferInfo.Buffer pBufferInfo() {
            return VkWriteDescriptorSet.npBufferInfo(this.address());
        }

        @Nullable
        @NativeType(value="VkBufferView const *")
        public LongBuffer pTexelBufferView() {
            return VkWriteDescriptorSet.npTexelBufferView(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkWriteDescriptorSet.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkWriteDescriptorSet.npNext(this.address(), value);
            return this;
        }

        public Buffer dstSet(@NativeType(value="VkDescriptorSet") long value) {
            VkWriteDescriptorSet.ndstSet(this.address(), value);
            return this;
        }

        public Buffer dstBinding(@NativeType(value="uint32_t") int value) {
            VkWriteDescriptorSet.ndstBinding(this.address(), value);
            return this;
        }

        public Buffer dstArrayElement(@NativeType(value="uint32_t") int value) {
            VkWriteDescriptorSet.ndstArrayElement(this.address(), value);
            return this;
        }

        public Buffer descriptorType(@NativeType(value="VkDescriptorType") int value) {
            VkWriteDescriptorSet.ndescriptorType(this.address(), value);
            return this;
        }

        public Buffer pImageInfo(@Nullable @NativeType(value="VkDescriptorImageInfo const *") VkDescriptorImageInfo.Buffer value) {
            VkWriteDescriptorSet.npImageInfo(this.address(), value);
            return this;
        }

        public Buffer pBufferInfo(@Nullable @NativeType(value="VkDescriptorBufferInfo const *") VkDescriptorBufferInfo.Buffer value) {
            VkWriteDescriptorSet.npBufferInfo(this.address(), value);
            return this;
        }

        public Buffer pTexelBufferView(@Nullable @NativeType(value="VkBufferView const *") LongBuffer value) {
            VkWriteDescriptorSet.npTexelBufferView(this.address(), value);
            return this;
        }
    }
}

