/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkViewport
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int X;
    public static final int Y;
    public static final int WIDTH;
    public static final int HEIGHT;
    public static final int MINDEPTH;
    public static final int MAXDEPTH;

    VkViewport(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkViewport(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkViewport.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public float x() {
        return VkViewport.nx(this.address());
    }

    public float y() {
        return VkViewport.ny(this.address());
    }

    public float width() {
        return VkViewport.nwidth(this.address());
    }

    public float height() {
        return VkViewport.nheight(this.address());
    }

    public float minDepth() {
        return VkViewport.nminDepth(this.address());
    }

    public float maxDepth() {
        return VkViewport.nmaxDepth(this.address());
    }

    public VkViewport x(float value) {
        VkViewport.nx(this.address(), value);
        return this;
    }

    public VkViewport y(float value) {
        VkViewport.ny(this.address(), value);
        return this;
    }

    public VkViewport width(float value) {
        VkViewport.nwidth(this.address(), value);
        return this;
    }

    public VkViewport height(float value) {
        VkViewport.nheight(this.address(), value);
        return this;
    }

    public VkViewport minDepth(float value) {
        VkViewport.nminDepth(this.address(), value);
        return this;
    }

    public VkViewport maxDepth(float value) {
        VkViewport.nmaxDepth(this.address(), value);
        return this;
    }

    public VkViewport set(float x, float y, float width, float height, float minDepth, float maxDepth) {
        this.x(x);
        this.y(y);
        this.width(width);
        this.height(height);
        this.minDepth(minDepth);
        this.maxDepth(maxDepth);
        return this;
    }

    public VkViewport set(VkViewport src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkViewport malloc() {
        return VkViewport.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkViewport calloc() {
        return VkViewport.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkViewport create() {
        return new VkViewport(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkViewport create(long address) {
        return new VkViewport(address, null);
    }

    @Nullable
    public static VkViewport createSafe(long address) {
        return address == 0L ? null : VkViewport.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkViewport.create(VkViewport.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkViewport.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkViewport.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkViewport.create(address, capacity);
    }

    public static VkViewport mallocStack() {
        return VkViewport.mallocStack(MemoryStack.stackGet());
    }

    public static VkViewport callocStack() {
        return VkViewport.callocStack(MemoryStack.stackGet());
    }

    public static VkViewport mallocStack(MemoryStack stack) {
        return VkViewport.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkViewport callocStack(MemoryStack stack) {
        return VkViewport.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkViewport.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkViewport.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkViewport.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkViewport.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static float nx(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)X);
    }

    public static float ny(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)Y);
    }

    public static float nwidth(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)WIDTH);
    }

    public static float nheight(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)HEIGHT);
    }

    public static float nminDepth(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)MINDEPTH);
    }

    public static float nmaxDepth(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)MAXDEPTH);
    }

    public static void nx(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)X, value);
    }

    public static void ny(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)Y, value);
    }

    public static void nwidth(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)WIDTH, value);
    }

    public static void nheight(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)HEIGHT, value);
    }

    public static void nminDepth(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)MINDEPTH, value);
    }

    public static void nmaxDepth(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)MAXDEPTH, value);
    }

    static {
        Struct.Layout layout = VkViewport.__struct(VkViewport.__member(4), VkViewport.__member(4), VkViewport.__member(4), VkViewport.__member(4), VkViewport.__member(4), VkViewport.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        X = layout.offsetof(0);
        Y = layout.offsetof(1);
        WIDTH = layout.offsetof(2);
        HEIGHT = layout.offsetof(3);
        MINDEPTH = layout.offsetof(4);
        MAXDEPTH = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<VkViewport, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkViewport newInstance(long address) {
            return new VkViewport(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        public float x() {
            return VkViewport.nx(this.address());
        }

        public float y() {
            return VkViewport.ny(this.address());
        }

        public float width() {
            return VkViewport.nwidth(this.address());
        }

        public float height() {
            return VkViewport.nheight(this.address());
        }

        public float minDepth() {
            return VkViewport.nminDepth(this.address());
        }

        public float maxDepth() {
            return VkViewport.nmaxDepth(this.address());
        }

        public Buffer x(float value) {
            VkViewport.nx(this.address(), value);
            return this;
        }

        public Buffer y(float value) {
            VkViewport.ny(this.address(), value);
            return this;
        }

        public Buffer width(float value) {
            VkViewport.nwidth(this.address(), value);
            return this;
        }

        public Buffer height(float value) {
            VkViewport.nheight(this.address(), value);
            return this;
        }

        public Buffer minDepth(float value) {
            VkViewport.nminDepth(this.address(), value);
            return this;
        }

        public Buffer maxDepth(float value) {
            VkViewport.nmaxDepth(this.address(), value);
            return this;
        }
    }
}

