/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkAttachmentReference2KHR;

public class VkSubpassDescription2KHR
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int PIPELINEBINDPOINT;
    public static final int VIEWMASK;
    public static final int INPUTATTACHMENTCOUNT;
    public static final int PINPUTATTACHMENTS;
    public static final int COLORATTACHMENTCOUNT;
    public static final int PCOLORATTACHMENTS;
    public static final int PRESOLVEATTACHMENTS;
    public static final int PDEPTHSTENCILATTACHMENT;
    public static final int PRESERVEATTACHMENTCOUNT;
    public static final int PPRESERVEATTACHMENTS;

    VkSubpassDescription2KHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkSubpassDescription2KHR(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkSubpassDescription2KHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkSubpassDescription2KHR.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkSubpassDescription2KHR.npNext(this.address());
    }

    @NativeType(value="VkSubpassDescriptionFlags")
    public int flags() {
        return VkSubpassDescription2KHR.nflags(this.address());
    }

    @NativeType(value="VkPipelineBindPoint")
    public int pipelineBindPoint() {
        return VkSubpassDescription2KHR.npipelineBindPoint(this.address());
    }

    @NativeType(value="uint32_t")
    public int viewMask() {
        return VkSubpassDescription2KHR.nviewMask(this.address());
    }

    @NativeType(value="uint32_t")
    public int inputAttachmentCount() {
        return VkSubpassDescription2KHR.ninputAttachmentCount(this.address());
    }

    @Nullable
    @NativeType(value="VkAttachmentReference2KHR const *")
    public VkAttachmentReference2KHR.Buffer pInputAttachments() {
        return VkSubpassDescription2KHR.npInputAttachments(this.address());
    }

    @NativeType(value="uint32_t")
    public int colorAttachmentCount() {
        return VkSubpassDescription2KHR.ncolorAttachmentCount(this.address());
    }

    @Nullable
    @NativeType(value="VkAttachmentReference2KHR const *")
    public VkAttachmentReference2KHR.Buffer pColorAttachments() {
        return VkSubpassDescription2KHR.npColorAttachments(this.address());
    }

    @Nullable
    @NativeType(value="VkAttachmentReference2KHR const *")
    public VkAttachmentReference2KHR.Buffer pResolveAttachments() {
        return VkSubpassDescription2KHR.npResolveAttachments(this.address());
    }

    @Nullable
    @NativeType(value="VkAttachmentReference2KHR const *")
    public VkAttachmentReference2KHR pDepthStencilAttachment() {
        return VkSubpassDescription2KHR.npDepthStencilAttachment(this.address());
    }

    @NativeType(value="uint32_t")
    public int preserveAttachmentCount() {
        return VkSubpassDescription2KHR.npreserveAttachmentCount(this.address());
    }

    @Nullable
    @NativeType(value="uint32_t const *")
    public IntBuffer pPreserveAttachments() {
        return VkSubpassDescription2KHR.npPreserveAttachments(this.address());
    }

    public VkSubpassDescription2KHR sType(@NativeType(value="VkStructureType") int value) {
        VkSubpassDescription2KHR.nsType(this.address(), value);
        return this;
    }

    public VkSubpassDescription2KHR pNext(@NativeType(value="void const *") long value) {
        VkSubpassDescription2KHR.npNext(this.address(), value);
        return this;
    }

    public VkSubpassDescription2KHR flags(@NativeType(value="VkSubpassDescriptionFlags") int value) {
        VkSubpassDescription2KHR.nflags(this.address(), value);
        return this;
    }

    public VkSubpassDescription2KHR pipelineBindPoint(@NativeType(value="VkPipelineBindPoint") int value) {
        VkSubpassDescription2KHR.npipelineBindPoint(this.address(), value);
        return this;
    }

    public VkSubpassDescription2KHR viewMask(@NativeType(value="uint32_t") int value) {
        VkSubpassDescription2KHR.nviewMask(this.address(), value);
        return this;
    }

    public VkSubpassDescription2KHR pInputAttachments(@Nullable @NativeType(value="VkAttachmentReference2KHR const *") VkAttachmentReference2KHR.Buffer value) {
        VkSubpassDescription2KHR.npInputAttachments(this.address(), value);
        return this;
    }

    public VkSubpassDescription2KHR colorAttachmentCount(@NativeType(value="uint32_t") int value) {
        VkSubpassDescription2KHR.ncolorAttachmentCount(this.address(), value);
        return this;
    }

    public VkSubpassDescription2KHR pColorAttachments(@Nullable @NativeType(value="VkAttachmentReference2KHR const *") VkAttachmentReference2KHR.Buffer value) {
        VkSubpassDescription2KHR.npColorAttachments(this.address(), value);
        return this;
    }

    public VkSubpassDescription2KHR pResolveAttachments(@Nullable @NativeType(value="VkAttachmentReference2KHR const *") VkAttachmentReference2KHR.Buffer value) {
        VkSubpassDescription2KHR.npResolveAttachments(this.address(), value);
        return this;
    }

    public VkSubpassDescription2KHR pDepthStencilAttachment(@Nullable @NativeType(value="VkAttachmentReference2KHR const *") VkAttachmentReference2KHR value) {
        VkSubpassDescription2KHR.npDepthStencilAttachment(this.address(), value);
        return this;
    }

    public VkSubpassDescription2KHR pPreserveAttachments(@Nullable @NativeType(value="uint32_t const *") IntBuffer value) {
        VkSubpassDescription2KHR.npPreserveAttachments(this.address(), value);
        return this;
    }

    public VkSubpassDescription2KHR set(int sType, long pNext, int flags, int pipelineBindPoint, int viewMask, @Nullable VkAttachmentReference2KHR.Buffer pInputAttachments, int colorAttachmentCount, @Nullable VkAttachmentReference2KHR.Buffer pColorAttachments, @Nullable VkAttachmentReference2KHR.Buffer pResolveAttachments, @Nullable VkAttachmentReference2KHR pDepthStencilAttachment, @Nullable IntBuffer pPreserveAttachments) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.pipelineBindPoint(pipelineBindPoint);
        this.viewMask(viewMask);
        this.pInputAttachments(pInputAttachments);
        this.colorAttachmentCount(colorAttachmentCount);
        this.pColorAttachments(pColorAttachments);
        this.pResolveAttachments(pResolveAttachments);
        this.pDepthStencilAttachment(pDepthStencilAttachment);
        this.pPreserveAttachments(pPreserveAttachments);
        return this;
    }

    public VkSubpassDescription2KHR set(VkSubpassDescription2KHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkSubpassDescription2KHR malloc() {
        return VkSubpassDescription2KHR.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkSubpassDescription2KHR calloc() {
        return VkSubpassDescription2KHR.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkSubpassDescription2KHR create() {
        return new VkSubpassDescription2KHR(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkSubpassDescription2KHR create(long address) {
        return new VkSubpassDescription2KHR(address, null);
    }

    @Nullable
    public static VkSubpassDescription2KHR createSafe(long address) {
        return address == 0L ? null : VkSubpassDescription2KHR.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkSubpassDescription2KHR.create(VkSubpassDescription2KHR.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkSubpassDescription2KHR.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkSubpassDescription2KHR.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkSubpassDescription2KHR.create(address, capacity);
    }

    public static VkSubpassDescription2KHR mallocStack() {
        return VkSubpassDescription2KHR.mallocStack(MemoryStack.stackGet());
    }

    public static VkSubpassDescription2KHR callocStack() {
        return VkSubpassDescription2KHR.callocStack(MemoryStack.stackGet());
    }

    public static VkSubpassDescription2KHR mallocStack(MemoryStack stack) {
        return VkSubpassDescription2KHR.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkSubpassDescription2KHR callocStack(MemoryStack stack) {
        return VkSubpassDescription2KHR.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkSubpassDescription2KHR.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkSubpassDescription2KHR.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkSubpassDescription2KHR.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkSubpassDescription2KHR.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nflags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FLAGS);
    }

    public static int npipelineBindPoint(long struct) {
        return MemoryUtil.memGetInt(struct + (long)PIPELINEBINDPOINT);
    }

    public static int nviewMask(long struct) {
        return MemoryUtil.memGetInt(struct + (long)VIEWMASK);
    }

    public static int ninputAttachmentCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)INPUTATTACHMENTCOUNT);
    }

    @Nullable
    public static VkAttachmentReference2KHR.Buffer npInputAttachments(long struct) {
        return VkAttachmentReference2KHR.createSafe(MemoryUtil.memGetAddress(struct + (long)PINPUTATTACHMENTS), VkSubpassDescription2KHR.ninputAttachmentCount(struct));
    }

    public static int ncolorAttachmentCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)COLORATTACHMENTCOUNT);
    }

    @Nullable
    public static VkAttachmentReference2KHR.Buffer npColorAttachments(long struct) {
        return VkAttachmentReference2KHR.createSafe(MemoryUtil.memGetAddress(struct + (long)PCOLORATTACHMENTS), VkSubpassDescription2KHR.ncolorAttachmentCount(struct));
    }

    @Nullable
    public static VkAttachmentReference2KHR.Buffer npResolveAttachments(long struct) {
        return VkAttachmentReference2KHR.createSafe(MemoryUtil.memGetAddress(struct + (long)PRESOLVEATTACHMENTS), VkSubpassDescription2KHR.ncolorAttachmentCount(struct));
    }

    @Nullable
    public static VkAttachmentReference2KHR npDepthStencilAttachment(long struct) {
        return VkAttachmentReference2KHR.createSafe(MemoryUtil.memGetAddress(struct + (long)PDEPTHSTENCILATTACHMENT));
    }

    public static int npreserveAttachmentCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)PRESERVEATTACHMENTCOUNT);
    }

    @Nullable
    public static IntBuffer npPreserveAttachments(long struct) {
        return MemoryUtil.memIntBufferSafe(MemoryUtil.memGetAddress(struct + (long)PPRESERVEATTACHMENTS), VkSubpassDescription2KHR.npreserveAttachmentCount(struct));
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nflags(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FLAGS, value);
    }

    public static void npipelineBindPoint(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)PIPELINEBINDPOINT, value);
    }

    public static void nviewMask(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)VIEWMASK, value);
    }

    public static void ninputAttachmentCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)INPUTATTACHMENTCOUNT, value);
    }

    public static void npInputAttachments(long struct, @Nullable VkAttachmentReference2KHR.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)PINPUTATTACHMENTS, MemoryUtil.memAddressSafe(value));
        VkSubpassDescription2KHR.ninputAttachmentCount(struct, value == null ? 0 : value.remaining());
    }

    public static void ncolorAttachmentCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)COLORATTACHMENTCOUNT, value);
    }

    public static void npColorAttachments(long struct, @Nullable VkAttachmentReference2KHR.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)PCOLORATTACHMENTS, MemoryUtil.memAddressSafe(value));
    }

    public static void npResolveAttachments(long struct, @Nullable VkAttachmentReference2KHR.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)PRESOLVEATTACHMENTS, MemoryUtil.memAddressSafe(value));
    }

    public static void npDepthStencilAttachment(long struct, @Nullable VkAttachmentReference2KHR value) {
        MemoryUtil.memPutAddress(struct + (long)PDEPTHSTENCILATTACHMENT, MemoryUtil.memAddressSafe(value));
    }

    public static void npreserveAttachmentCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)PRESERVEATTACHMENTCOUNT, value);
    }

    public static void npPreserveAttachments(long struct, @Nullable IntBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PPRESERVEATTACHMENTS, MemoryUtil.memAddressSafe(value));
        VkSubpassDescription2KHR.npreserveAttachmentCount(struct, value == null ? 0 : value.remaining());
    }

    public static void validate(long struct) {
        if (VkSubpassDescription2KHR.ninputAttachmentCount(struct) != 0) {
            Checks.check(MemoryUtil.memGetAddress(struct + (long)PINPUTATTACHMENTS));
        }
        if (VkSubpassDescription2KHR.ncolorAttachmentCount(struct) != 0) {
            Checks.check(MemoryUtil.memGetAddress(struct + (long)PCOLORATTACHMENTS));
        }
        if (VkSubpassDescription2KHR.npreserveAttachmentCount(struct) != 0) {
            Checks.check(MemoryUtil.memGetAddress(struct + (long)PPRESERVEATTACHMENTS));
        }
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            VkSubpassDescription2KHR.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = VkSubpassDescription2KHR.__struct(VkSubpassDescription2KHR.__member(4), VkSubpassDescription2KHR.__member(POINTER_SIZE), VkSubpassDescription2KHR.__member(4), VkSubpassDescription2KHR.__member(4), VkSubpassDescription2KHR.__member(4), VkSubpassDescription2KHR.__member(4), VkSubpassDescription2KHR.__member(POINTER_SIZE), VkSubpassDescription2KHR.__member(4), VkSubpassDescription2KHR.__member(POINTER_SIZE), VkSubpassDescription2KHR.__member(POINTER_SIZE), VkSubpassDescription2KHR.__member(POINTER_SIZE), VkSubpassDescription2KHR.__member(4), VkSubpassDescription2KHR.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        PIPELINEBINDPOINT = layout.offsetof(3);
        VIEWMASK = layout.offsetof(4);
        INPUTATTACHMENTCOUNT = layout.offsetof(5);
        PINPUTATTACHMENTS = layout.offsetof(6);
        COLORATTACHMENTCOUNT = layout.offsetof(7);
        PCOLORATTACHMENTS = layout.offsetof(8);
        PRESOLVEATTACHMENTS = layout.offsetof(9);
        PDEPTHSTENCILATTACHMENT = layout.offsetof(10);
        PRESERVEATTACHMENTCOUNT = layout.offsetof(11);
        PPRESERVEATTACHMENTS = layout.offsetof(12);
    }

    public static class Buffer
    extends StructBuffer<VkSubpassDescription2KHR, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkSubpassDescription2KHR newInstance(long address) {
            return new VkSubpassDescription2KHR(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkSubpassDescription2KHR.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkSubpassDescription2KHR.npNext(this.address());
        }

        @NativeType(value="VkSubpassDescriptionFlags")
        public int flags() {
            return VkSubpassDescription2KHR.nflags(this.address());
        }

        @NativeType(value="VkPipelineBindPoint")
        public int pipelineBindPoint() {
            return VkSubpassDescription2KHR.npipelineBindPoint(this.address());
        }

        @NativeType(value="uint32_t")
        public int viewMask() {
            return VkSubpassDescription2KHR.nviewMask(this.address());
        }

        @NativeType(value="uint32_t")
        public int inputAttachmentCount() {
            return VkSubpassDescription2KHR.ninputAttachmentCount(this.address());
        }

        @Nullable
        @NativeType(value="VkAttachmentReference2KHR const *")
        public VkAttachmentReference2KHR.Buffer pInputAttachments() {
            return VkSubpassDescription2KHR.npInputAttachments(this.address());
        }

        @NativeType(value="uint32_t")
        public int colorAttachmentCount() {
            return VkSubpassDescription2KHR.ncolorAttachmentCount(this.address());
        }

        @Nullable
        @NativeType(value="VkAttachmentReference2KHR const *")
        public VkAttachmentReference2KHR.Buffer pColorAttachments() {
            return VkSubpassDescription2KHR.npColorAttachments(this.address());
        }

        @Nullable
        @NativeType(value="VkAttachmentReference2KHR const *")
        public VkAttachmentReference2KHR.Buffer pResolveAttachments() {
            return VkSubpassDescription2KHR.npResolveAttachments(this.address());
        }

        @Nullable
        @NativeType(value="VkAttachmentReference2KHR const *")
        public VkAttachmentReference2KHR pDepthStencilAttachment() {
            return VkSubpassDescription2KHR.npDepthStencilAttachment(this.address());
        }

        @NativeType(value="uint32_t")
        public int preserveAttachmentCount() {
            return VkSubpassDescription2KHR.npreserveAttachmentCount(this.address());
        }

        @Nullable
        @NativeType(value="uint32_t const *")
        public IntBuffer pPreserveAttachments() {
            return VkSubpassDescription2KHR.npPreserveAttachments(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkSubpassDescription2KHR.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkSubpassDescription2KHR.npNext(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="VkSubpassDescriptionFlags") int value) {
            VkSubpassDescription2KHR.nflags(this.address(), value);
            return this;
        }

        public Buffer pipelineBindPoint(@NativeType(value="VkPipelineBindPoint") int value) {
            VkSubpassDescription2KHR.npipelineBindPoint(this.address(), value);
            return this;
        }

        public Buffer viewMask(@NativeType(value="uint32_t") int value) {
            VkSubpassDescription2KHR.nviewMask(this.address(), value);
            return this;
        }

        public Buffer pInputAttachments(@Nullable @NativeType(value="VkAttachmentReference2KHR const *") VkAttachmentReference2KHR.Buffer value) {
            VkSubpassDescription2KHR.npInputAttachments(this.address(), value);
            return this;
        }

        public Buffer colorAttachmentCount(@NativeType(value="uint32_t") int value) {
            VkSubpassDescription2KHR.ncolorAttachmentCount(this.address(), value);
            return this;
        }

        public Buffer pColorAttachments(@Nullable @NativeType(value="VkAttachmentReference2KHR const *") VkAttachmentReference2KHR.Buffer value) {
            VkSubpassDescription2KHR.npColorAttachments(this.address(), value);
            return this;
        }

        public Buffer pResolveAttachments(@Nullable @NativeType(value="VkAttachmentReference2KHR const *") VkAttachmentReference2KHR.Buffer value) {
            VkSubpassDescription2KHR.npResolveAttachments(this.address(), value);
            return this;
        }

        public Buffer pDepthStencilAttachment(@Nullable @NativeType(value="VkAttachmentReference2KHR const *") VkAttachmentReference2KHR value) {
            VkSubpassDescription2KHR.npDepthStencilAttachment(this.address(), value);
            return this;
        }

        public Buffer pPreserveAttachments(@Nullable @NativeType(value="uint32_t const *") IntBuffer value) {
            VkSubpassDescription2KHR.npPreserveAttachments(this.address(), value);
            return this;
        }
    }
}

