/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkSubpassBeginInfoKHR
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int CONTENTS;

    VkSubpassBeginInfoKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkSubpassBeginInfoKHR(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkSubpassBeginInfoKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkSubpassBeginInfoKHR.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkSubpassBeginInfoKHR.npNext(this.address());
    }

    @NativeType(value="VkSubpassContents")
    public int contents() {
        return VkSubpassBeginInfoKHR.ncontents(this.address());
    }

    public VkSubpassBeginInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkSubpassBeginInfoKHR.nsType(this.address(), value);
        return this;
    }

    public VkSubpassBeginInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkSubpassBeginInfoKHR.npNext(this.address(), value);
        return this;
    }

    public VkSubpassBeginInfoKHR contents(@NativeType(value="VkSubpassContents") int value) {
        VkSubpassBeginInfoKHR.ncontents(this.address(), value);
        return this;
    }

    public VkSubpassBeginInfoKHR set(int sType, long pNext, int contents) {
        this.sType(sType);
        this.pNext(pNext);
        this.contents(contents);
        return this;
    }

    public VkSubpassBeginInfoKHR set(VkSubpassBeginInfoKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkSubpassBeginInfoKHR malloc() {
        return VkSubpassBeginInfoKHR.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkSubpassBeginInfoKHR calloc() {
        return VkSubpassBeginInfoKHR.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkSubpassBeginInfoKHR create() {
        return new VkSubpassBeginInfoKHR(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkSubpassBeginInfoKHR create(long address) {
        return new VkSubpassBeginInfoKHR(address, null);
    }

    @Nullable
    public static VkSubpassBeginInfoKHR createSafe(long address) {
        return address == 0L ? null : VkSubpassBeginInfoKHR.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkSubpassBeginInfoKHR.create(VkSubpassBeginInfoKHR.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkSubpassBeginInfoKHR.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkSubpassBeginInfoKHR.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkSubpassBeginInfoKHR.create(address, capacity);
    }

    public static VkSubpassBeginInfoKHR mallocStack() {
        return VkSubpassBeginInfoKHR.mallocStack(MemoryStack.stackGet());
    }

    public static VkSubpassBeginInfoKHR callocStack() {
        return VkSubpassBeginInfoKHR.callocStack(MemoryStack.stackGet());
    }

    public static VkSubpassBeginInfoKHR mallocStack(MemoryStack stack) {
        return VkSubpassBeginInfoKHR.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkSubpassBeginInfoKHR callocStack(MemoryStack stack) {
        return VkSubpassBeginInfoKHR.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkSubpassBeginInfoKHR.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkSubpassBeginInfoKHR.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkSubpassBeginInfoKHR.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkSubpassBeginInfoKHR.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int ncontents(long struct) {
        return MemoryUtil.memGetInt(struct + (long)CONTENTS);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void ncontents(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)CONTENTS, value);
    }

    static {
        Struct.Layout layout = VkSubpassBeginInfoKHR.__struct(VkSubpassBeginInfoKHR.__member(4), VkSubpassBeginInfoKHR.__member(POINTER_SIZE), VkSubpassBeginInfoKHR.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        CONTENTS = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkSubpassBeginInfoKHR, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkSubpassBeginInfoKHR newInstance(long address) {
            return new VkSubpassBeginInfoKHR(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkSubpassBeginInfoKHR.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkSubpassBeginInfoKHR.npNext(this.address());
        }

        @NativeType(value="VkSubpassContents")
        public int contents() {
            return VkSubpassBeginInfoKHR.ncontents(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkSubpassBeginInfoKHR.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkSubpassBeginInfoKHR.npNext(this.address(), value);
            return this;
        }

        public Buffer contents(@NativeType(value="VkSubpassContents") int value) {
            VkSubpassBeginInfoKHR.ncontents(this.address(), value);
            return this;
        }
    }
}

