/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkSpecializationMapEntry
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int CONSTANTID;
    public static final int OFFSET;
    public static final int SIZE;

    VkSpecializationMapEntry(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkSpecializationMapEntry(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkSpecializationMapEntry.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint32_t")
    public int constantID() {
        return VkSpecializationMapEntry.nconstantID(this.address());
    }

    @NativeType(value="uint32_t")
    public int offset() {
        return VkSpecializationMapEntry.noffset(this.address());
    }

    @NativeType(value="size_t")
    public long size() {
        return VkSpecializationMapEntry.nsize(this.address());
    }

    public VkSpecializationMapEntry constantID(@NativeType(value="uint32_t") int value) {
        VkSpecializationMapEntry.nconstantID(this.address(), value);
        return this;
    }

    public VkSpecializationMapEntry offset(@NativeType(value="uint32_t") int value) {
        VkSpecializationMapEntry.noffset(this.address(), value);
        return this;
    }

    public VkSpecializationMapEntry size(@NativeType(value="size_t") long value) {
        VkSpecializationMapEntry.nsize(this.address(), value);
        return this;
    }

    public VkSpecializationMapEntry set(int constantID, int offset, long size) {
        this.constantID(constantID);
        this.offset(offset);
        this.size(size);
        return this;
    }

    public VkSpecializationMapEntry set(VkSpecializationMapEntry src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkSpecializationMapEntry malloc() {
        return VkSpecializationMapEntry.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkSpecializationMapEntry calloc() {
        return VkSpecializationMapEntry.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkSpecializationMapEntry create() {
        return new VkSpecializationMapEntry(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkSpecializationMapEntry create(long address) {
        return new VkSpecializationMapEntry(address, null);
    }

    @Nullable
    public static VkSpecializationMapEntry createSafe(long address) {
        return address == 0L ? null : VkSpecializationMapEntry.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkSpecializationMapEntry.create(VkSpecializationMapEntry.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkSpecializationMapEntry.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkSpecializationMapEntry.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkSpecializationMapEntry.create(address, capacity);
    }

    public static VkSpecializationMapEntry mallocStack() {
        return VkSpecializationMapEntry.mallocStack(MemoryStack.stackGet());
    }

    public static VkSpecializationMapEntry callocStack() {
        return VkSpecializationMapEntry.callocStack(MemoryStack.stackGet());
    }

    public static VkSpecializationMapEntry mallocStack(MemoryStack stack) {
        return VkSpecializationMapEntry.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkSpecializationMapEntry callocStack(MemoryStack stack) {
        return VkSpecializationMapEntry.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkSpecializationMapEntry.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkSpecializationMapEntry.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkSpecializationMapEntry.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkSpecializationMapEntry.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nconstantID(long struct) {
        return MemoryUtil.memGetInt(struct + (long)CONSTANTID);
    }

    public static int noffset(long struct) {
        return MemoryUtil.memGetInt(struct + (long)OFFSET);
    }

    public static long nsize(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)SIZE);
    }

    public static void nconstantID(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)CONSTANTID, value);
    }

    public static void noffset(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)OFFSET, value);
    }

    public static void nsize(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)SIZE, value);
    }

    static {
        Struct.Layout layout = VkSpecializationMapEntry.__struct(VkSpecializationMapEntry.__member(4), VkSpecializationMapEntry.__member(4), VkSpecializationMapEntry.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        CONSTANTID = layout.offsetof(0);
        OFFSET = layout.offsetof(1);
        SIZE = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkSpecializationMapEntry, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkSpecializationMapEntry newInstance(long address) {
            return new VkSpecializationMapEntry(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="uint32_t")
        public int constantID() {
            return VkSpecializationMapEntry.nconstantID(this.address());
        }

        @NativeType(value="uint32_t")
        public int offset() {
            return VkSpecializationMapEntry.noffset(this.address());
        }

        @NativeType(value="size_t")
        public long size() {
            return VkSpecializationMapEntry.nsize(this.address());
        }

        public Buffer constantID(@NativeType(value="uint32_t") int value) {
            VkSpecializationMapEntry.nconstantID(this.address(), value);
            return this;
        }

        public Buffer offset(@NativeType(value="uint32_t") int value) {
            VkSpecializationMapEntry.noffset(this.address(), value);
            return this;
        }

        public Buffer size(@NativeType(value="size_t") long value) {
            VkSpecializationMapEntry.nsize(this.address(), value);
            return this;
        }
    }
}

