/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkSparseMemoryBind
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int RESOURCEOFFSET;
    public static final int SIZE;
    public static final int MEMORY;
    public static final int MEMORYOFFSET;
    public static final int FLAGS;

    VkSparseMemoryBind(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkSparseMemoryBind(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkSparseMemoryBind.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkDeviceSize")
    public long resourceOffset() {
        return VkSparseMemoryBind.nresourceOffset(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long size() {
        return VkSparseMemoryBind.nsize(this.address());
    }

    @NativeType(value="VkDeviceMemory")
    public long memory() {
        return VkSparseMemoryBind.nmemory(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long memoryOffset() {
        return VkSparseMemoryBind.nmemoryOffset(this.address());
    }

    @NativeType(value="VkSparseMemoryBindFlags")
    public int flags() {
        return VkSparseMemoryBind.nflags(this.address());
    }

    public VkSparseMemoryBind resourceOffset(@NativeType(value="VkDeviceSize") long value) {
        VkSparseMemoryBind.nresourceOffset(this.address(), value);
        return this;
    }

    public VkSparseMemoryBind size(@NativeType(value="VkDeviceSize") long value) {
        VkSparseMemoryBind.nsize(this.address(), value);
        return this;
    }

    public VkSparseMemoryBind memory(@NativeType(value="VkDeviceMemory") long value) {
        VkSparseMemoryBind.nmemory(this.address(), value);
        return this;
    }

    public VkSparseMemoryBind memoryOffset(@NativeType(value="VkDeviceSize") long value) {
        VkSparseMemoryBind.nmemoryOffset(this.address(), value);
        return this;
    }

    public VkSparseMemoryBind flags(@NativeType(value="VkSparseMemoryBindFlags") int value) {
        VkSparseMemoryBind.nflags(this.address(), value);
        return this;
    }

    public VkSparseMemoryBind set(long resourceOffset, long size, long memory, long memoryOffset, int flags) {
        this.resourceOffset(resourceOffset);
        this.size(size);
        this.memory(memory);
        this.memoryOffset(memoryOffset);
        this.flags(flags);
        return this;
    }

    public VkSparseMemoryBind set(VkSparseMemoryBind src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkSparseMemoryBind malloc() {
        return VkSparseMemoryBind.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkSparseMemoryBind calloc() {
        return VkSparseMemoryBind.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkSparseMemoryBind create() {
        return new VkSparseMemoryBind(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkSparseMemoryBind create(long address) {
        return new VkSparseMemoryBind(address, null);
    }

    @Nullable
    public static VkSparseMemoryBind createSafe(long address) {
        return address == 0L ? null : VkSparseMemoryBind.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkSparseMemoryBind.create(VkSparseMemoryBind.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkSparseMemoryBind.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkSparseMemoryBind.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkSparseMemoryBind.create(address, capacity);
    }

    public static VkSparseMemoryBind mallocStack() {
        return VkSparseMemoryBind.mallocStack(MemoryStack.stackGet());
    }

    public static VkSparseMemoryBind callocStack() {
        return VkSparseMemoryBind.callocStack(MemoryStack.stackGet());
    }

    public static VkSparseMemoryBind mallocStack(MemoryStack stack) {
        return VkSparseMemoryBind.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkSparseMemoryBind callocStack(MemoryStack stack) {
        return VkSparseMemoryBind.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkSparseMemoryBind.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkSparseMemoryBind.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkSparseMemoryBind.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkSparseMemoryBind.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nresourceOffset(long struct) {
        return MemoryUtil.memGetLong(struct + (long)RESOURCEOFFSET);
    }

    public static long nsize(long struct) {
        return MemoryUtil.memGetLong(struct + (long)SIZE);
    }

    public static long nmemory(long struct) {
        return MemoryUtil.memGetLong(struct + (long)MEMORY);
    }

    public static long nmemoryOffset(long struct) {
        return MemoryUtil.memGetLong(struct + (long)MEMORYOFFSET);
    }

    public static int nflags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FLAGS);
    }

    public static void nresourceOffset(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)RESOURCEOFFSET, value);
    }

    public static void nsize(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)SIZE, value);
    }

    public static void nmemory(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)MEMORY, value);
    }

    public static void nmemoryOffset(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)MEMORYOFFSET, value);
    }

    public static void nflags(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FLAGS, value);
    }

    static {
        Struct.Layout layout = VkSparseMemoryBind.__struct(VkSparseMemoryBind.__member(8), VkSparseMemoryBind.__member(8), VkSparseMemoryBind.__member(8), VkSparseMemoryBind.__member(8), VkSparseMemoryBind.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        RESOURCEOFFSET = layout.offsetof(0);
        SIZE = layout.offsetof(1);
        MEMORY = layout.offsetof(2);
        MEMORYOFFSET = layout.offsetof(3);
        FLAGS = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<VkSparseMemoryBind, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkSparseMemoryBind newInstance(long address) {
            return new VkSparseMemoryBind(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="VkDeviceSize")
        public long resourceOffset() {
            return VkSparseMemoryBind.nresourceOffset(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long size() {
            return VkSparseMemoryBind.nsize(this.address());
        }

        @NativeType(value="VkDeviceMemory")
        public long memory() {
            return VkSparseMemoryBind.nmemory(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long memoryOffset() {
            return VkSparseMemoryBind.nmemoryOffset(this.address());
        }

        @NativeType(value="VkSparseMemoryBindFlags")
        public int flags() {
            return VkSparseMemoryBind.nflags(this.address());
        }

        public Buffer resourceOffset(@NativeType(value="VkDeviceSize") long value) {
            VkSparseMemoryBind.nresourceOffset(this.address(), value);
            return this;
        }

        public Buffer size(@NativeType(value="VkDeviceSize") long value) {
            VkSparseMemoryBind.nsize(this.address(), value);
            return this;
        }

        public Buffer memory(@NativeType(value="VkDeviceMemory") long value) {
            VkSparseMemoryBind.nmemory(this.address(), value);
            return this;
        }

        public Buffer memoryOffset(@NativeType(value="VkDeviceSize") long value) {
            VkSparseMemoryBind.nmemoryOffset(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="VkSparseMemoryBindFlags") int value) {
            VkSparseMemoryBind.nflags(this.address(), value);
            return this;
        }
    }
}

