/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkSemaphoreCreateInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;

    VkSemaphoreCreateInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkSemaphoreCreateInfo(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkSemaphoreCreateInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkSemaphoreCreateInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkSemaphoreCreateInfo.npNext(this.address());
    }

    @NativeType(value="VkSemaphoreCreateFlags")
    public int flags() {
        return VkSemaphoreCreateInfo.nflags(this.address());
    }

    public VkSemaphoreCreateInfo sType(@NativeType(value="VkStructureType") int value) {
        VkSemaphoreCreateInfo.nsType(this.address(), value);
        return this;
    }

    public VkSemaphoreCreateInfo pNext(@NativeType(value="void const *") long value) {
        VkSemaphoreCreateInfo.npNext(this.address(), value);
        return this;
    }

    public VkSemaphoreCreateInfo flags(@NativeType(value="VkSemaphoreCreateFlags") int value) {
        VkSemaphoreCreateInfo.nflags(this.address(), value);
        return this;
    }

    public VkSemaphoreCreateInfo set(int sType, long pNext, int flags) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        return this;
    }

    public VkSemaphoreCreateInfo set(VkSemaphoreCreateInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkSemaphoreCreateInfo malloc() {
        return VkSemaphoreCreateInfo.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkSemaphoreCreateInfo calloc() {
        return VkSemaphoreCreateInfo.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkSemaphoreCreateInfo create() {
        return new VkSemaphoreCreateInfo(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkSemaphoreCreateInfo create(long address) {
        return new VkSemaphoreCreateInfo(address, null);
    }

    @Nullable
    public static VkSemaphoreCreateInfo createSafe(long address) {
        return address == 0L ? null : VkSemaphoreCreateInfo.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkSemaphoreCreateInfo.create(VkSemaphoreCreateInfo.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkSemaphoreCreateInfo.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkSemaphoreCreateInfo.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkSemaphoreCreateInfo.create(address, capacity);
    }

    public static VkSemaphoreCreateInfo mallocStack() {
        return VkSemaphoreCreateInfo.mallocStack(MemoryStack.stackGet());
    }

    public static VkSemaphoreCreateInfo callocStack() {
        return VkSemaphoreCreateInfo.callocStack(MemoryStack.stackGet());
    }

    public static VkSemaphoreCreateInfo mallocStack(MemoryStack stack) {
        return VkSemaphoreCreateInfo.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkSemaphoreCreateInfo callocStack(MemoryStack stack) {
        return VkSemaphoreCreateInfo.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkSemaphoreCreateInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkSemaphoreCreateInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkSemaphoreCreateInfo.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkSemaphoreCreateInfo.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nflags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FLAGS);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nflags(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FLAGS, value);
    }

    static {
        Struct.Layout layout = VkSemaphoreCreateInfo.__struct(VkSemaphoreCreateInfo.__member(4), VkSemaphoreCreateInfo.__member(POINTER_SIZE), VkSemaphoreCreateInfo.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkSemaphoreCreateInfo, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkSemaphoreCreateInfo newInstance(long address) {
            return new VkSemaphoreCreateInfo(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkSemaphoreCreateInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkSemaphoreCreateInfo.npNext(this.address());
        }

        @NativeType(value="VkSemaphoreCreateFlags")
        public int flags() {
            return VkSemaphoreCreateInfo.nflags(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkSemaphoreCreateInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkSemaphoreCreateInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="VkSemaphoreCreateFlags") int value) {
            VkSemaphoreCreateInfo.nflags(this.address(), value);
            return this;
        }
    }
}

