/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkSamplerCreateInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int MAGFILTER;
    public static final int MINFILTER;
    public static final int MIPMAPMODE;
    public static final int ADDRESSMODEU;
    public static final int ADDRESSMODEV;
    public static final int ADDRESSMODEW;
    public static final int MIPLODBIAS;
    public static final int ANISOTROPYENABLE;
    public static final int MAXANISOTROPY;
    public static final int COMPAREENABLE;
    public static final int COMPAREOP;
    public static final int MINLOD;
    public static final int MAXLOD;
    public static final int BORDERCOLOR;
    public static final int UNNORMALIZEDCOORDINATES;

    VkSamplerCreateInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkSamplerCreateInfo(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkSamplerCreateInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkSamplerCreateInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkSamplerCreateInfo.npNext(this.address());
    }

    @NativeType(value="VkSamplerCreateFlags")
    public int flags() {
        return VkSamplerCreateInfo.nflags(this.address());
    }

    @NativeType(value="VkFilter")
    public int magFilter() {
        return VkSamplerCreateInfo.nmagFilter(this.address());
    }

    @NativeType(value="VkFilter")
    public int minFilter() {
        return VkSamplerCreateInfo.nminFilter(this.address());
    }

    @NativeType(value="VkSamplerMipmapMode")
    public int mipmapMode() {
        return VkSamplerCreateInfo.nmipmapMode(this.address());
    }

    @NativeType(value="VkSamplerAddressMode")
    public int addressModeU() {
        return VkSamplerCreateInfo.naddressModeU(this.address());
    }

    @NativeType(value="VkSamplerAddressMode")
    public int addressModeV() {
        return VkSamplerCreateInfo.naddressModeV(this.address());
    }

    @NativeType(value="VkSamplerAddressMode")
    public int addressModeW() {
        return VkSamplerCreateInfo.naddressModeW(this.address());
    }

    public float mipLodBias() {
        return VkSamplerCreateInfo.nmipLodBias(this.address());
    }

    @NativeType(value="VkBool32")
    public boolean anisotropyEnable() {
        return VkSamplerCreateInfo.nanisotropyEnable(this.address()) != 0;
    }

    public float maxAnisotropy() {
        return VkSamplerCreateInfo.nmaxAnisotropy(this.address());
    }

    @NativeType(value="VkBool32")
    public boolean compareEnable() {
        return VkSamplerCreateInfo.ncompareEnable(this.address()) != 0;
    }

    @NativeType(value="VkCompareOp")
    public int compareOp() {
        return VkSamplerCreateInfo.ncompareOp(this.address());
    }

    public float minLod() {
        return VkSamplerCreateInfo.nminLod(this.address());
    }

    public float maxLod() {
        return VkSamplerCreateInfo.nmaxLod(this.address());
    }

    @NativeType(value="VkBorderColor")
    public int borderColor() {
        return VkSamplerCreateInfo.nborderColor(this.address());
    }

    @NativeType(value="VkBool32")
    public boolean unnormalizedCoordinates() {
        return VkSamplerCreateInfo.nunnormalizedCoordinates(this.address()) != 0;
    }

    public VkSamplerCreateInfo sType(@NativeType(value="VkStructureType") int value) {
        VkSamplerCreateInfo.nsType(this.address(), value);
        return this;
    }

    public VkSamplerCreateInfo pNext(@NativeType(value="void const *") long value) {
        VkSamplerCreateInfo.npNext(this.address(), value);
        return this;
    }

    public VkSamplerCreateInfo flags(@NativeType(value="VkSamplerCreateFlags") int value) {
        VkSamplerCreateInfo.nflags(this.address(), value);
        return this;
    }

    public VkSamplerCreateInfo magFilter(@NativeType(value="VkFilter") int value) {
        VkSamplerCreateInfo.nmagFilter(this.address(), value);
        return this;
    }

    public VkSamplerCreateInfo minFilter(@NativeType(value="VkFilter") int value) {
        VkSamplerCreateInfo.nminFilter(this.address(), value);
        return this;
    }

    public VkSamplerCreateInfo mipmapMode(@NativeType(value="VkSamplerMipmapMode") int value) {
        VkSamplerCreateInfo.nmipmapMode(this.address(), value);
        return this;
    }

    public VkSamplerCreateInfo addressModeU(@NativeType(value="VkSamplerAddressMode") int value) {
        VkSamplerCreateInfo.naddressModeU(this.address(), value);
        return this;
    }

    public VkSamplerCreateInfo addressModeV(@NativeType(value="VkSamplerAddressMode") int value) {
        VkSamplerCreateInfo.naddressModeV(this.address(), value);
        return this;
    }

    public VkSamplerCreateInfo addressModeW(@NativeType(value="VkSamplerAddressMode") int value) {
        VkSamplerCreateInfo.naddressModeW(this.address(), value);
        return this;
    }

    public VkSamplerCreateInfo mipLodBias(float value) {
        VkSamplerCreateInfo.nmipLodBias(this.address(), value);
        return this;
    }

    public VkSamplerCreateInfo anisotropyEnable(@NativeType(value="VkBool32") boolean value) {
        VkSamplerCreateInfo.nanisotropyEnable(this.address(), value ? 1 : 0);
        return this;
    }

    public VkSamplerCreateInfo maxAnisotropy(float value) {
        VkSamplerCreateInfo.nmaxAnisotropy(this.address(), value);
        return this;
    }

    public VkSamplerCreateInfo compareEnable(@NativeType(value="VkBool32") boolean value) {
        VkSamplerCreateInfo.ncompareEnable(this.address(), value ? 1 : 0);
        return this;
    }

    public VkSamplerCreateInfo compareOp(@NativeType(value="VkCompareOp") int value) {
        VkSamplerCreateInfo.ncompareOp(this.address(), value);
        return this;
    }

    public VkSamplerCreateInfo minLod(float value) {
        VkSamplerCreateInfo.nminLod(this.address(), value);
        return this;
    }

    public VkSamplerCreateInfo maxLod(float value) {
        VkSamplerCreateInfo.nmaxLod(this.address(), value);
        return this;
    }

    public VkSamplerCreateInfo borderColor(@NativeType(value="VkBorderColor") int value) {
        VkSamplerCreateInfo.nborderColor(this.address(), value);
        return this;
    }

    public VkSamplerCreateInfo unnormalizedCoordinates(@NativeType(value="VkBool32") boolean value) {
        VkSamplerCreateInfo.nunnormalizedCoordinates(this.address(), value ? 1 : 0);
        return this;
    }

    public VkSamplerCreateInfo set(int sType, long pNext, int flags, int magFilter, int minFilter, int mipmapMode, int addressModeU, int addressModeV, int addressModeW, float mipLodBias, boolean anisotropyEnable, float maxAnisotropy, boolean compareEnable, int compareOp, float minLod, float maxLod, int borderColor, boolean unnormalizedCoordinates) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.magFilter(magFilter);
        this.minFilter(minFilter);
        this.mipmapMode(mipmapMode);
        this.addressModeU(addressModeU);
        this.addressModeV(addressModeV);
        this.addressModeW(addressModeW);
        this.mipLodBias(mipLodBias);
        this.anisotropyEnable(anisotropyEnable);
        this.maxAnisotropy(maxAnisotropy);
        this.compareEnable(compareEnable);
        this.compareOp(compareOp);
        this.minLod(minLod);
        this.maxLod(maxLod);
        this.borderColor(borderColor);
        this.unnormalizedCoordinates(unnormalizedCoordinates);
        return this;
    }

    public VkSamplerCreateInfo set(VkSamplerCreateInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkSamplerCreateInfo malloc() {
        return VkSamplerCreateInfo.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkSamplerCreateInfo calloc() {
        return VkSamplerCreateInfo.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkSamplerCreateInfo create() {
        return new VkSamplerCreateInfo(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkSamplerCreateInfo create(long address) {
        return new VkSamplerCreateInfo(address, null);
    }

    @Nullable
    public static VkSamplerCreateInfo createSafe(long address) {
        return address == 0L ? null : VkSamplerCreateInfo.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkSamplerCreateInfo.create(VkSamplerCreateInfo.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkSamplerCreateInfo.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkSamplerCreateInfo.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkSamplerCreateInfo.create(address, capacity);
    }

    public static VkSamplerCreateInfo mallocStack() {
        return VkSamplerCreateInfo.mallocStack(MemoryStack.stackGet());
    }

    public static VkSamplerCreateInfo callocStack() {
        return VkSamplerCreateInfo.callocStack(MemoryStack.stackGet());
    }

    public static VkSamplerCreateInfo mallocStack(MemoryStack stack) {
        return VkSamplerCreateInfo.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkSamplerCreateInfo callocStack(MemoryStack stack) {
        return VkSamplerCreateInfo.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkSamplerCreateInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkSamplerCreateInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkSamplerCreateInfo.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkSamplerCreateInfo.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nflags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FLAGS);
    }

    public static int nmagFilter(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MAGFILTER);
    }

    public static int nminFilter(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MINFILTER);
    }

    public static int nmipmapMode(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MIPMAPMODE);
    }

    public static int naddressModeU(long struct) {
        return MemoryUtil.memGetInt(struct + (long)ADDRESSMODEU);
    }

    public static int naddressModeV(long struct) {
        return MemoryUtil.memGetInt(struct + (long)ADDRESSMODEV);
    }

    public static int naddressModeW(long struct) {
        return MemoryUtil.memGetInt(struct + (long)ADDRESSMODEW);
    }

    public static float nmipLodBias(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)MIPLODBIAS);
    }

    public static int nanisotropyEnable(long struct) {
        return MemoryUtil.memGetInt(struct + (long)ANISOTROPYENABLE);
    }

    public static float nmaxAnisotropy(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)MAXANISOTROPY);
    }

    public static int ncompareEnable(long struct) {
        return MemoryUtil.memGetInt(struct + (long)COMPAREENABLE);
    }

    public static int ncompareOp(long struct) {
        return MemoryUtil.memGetInt(struct + (long)COMPAREOP);
    }

    public static float nminLod(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)MINLOD);
    }

    public static float nmaxLod(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)MAXLOD);
    }

    public static int nborderColor(long struct) {
        return MemoryUtil.memGetInt(struct + (long)BORDERCOLOR);
    }

    public static int nunnormalizedCoordinates(long struct) {
        return MemoryUtil.memGetInt(struct + (long)UNNORMALIZEDCOORDINATES);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nflags(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FLAGS, value);
    }

    public static void nmagFilter(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)MAGFILTER, value);
    }

    public static void nminFilter(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)MINFILTER, value);
    }

    public static void nmipmapMode(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)MIPMAPMODE, value);
    }

    public static void naddressModeU(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)ADDRESSMODEU, value);
    }

    public static void naddressModeV(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)ADDRESSMODEV, value);
    }

    public static void naddressModeW(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)ADDRESSMODEW, value);
    }

    public static void nmipLodBias(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)MIPLODBIAS, value);
    }

    public static void nanisotropyEnable(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)ANISOTROPYENABLE, value);
    }

    public static void nmaxAnisotropy(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)MAXANISOTROPY, value);
    }

    public static void ncompareEnable(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)COMPAREENABLE, value);
    }

    public static void ncompareOp(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)COMPAREOP, value);
    }

    public static void nminLod(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)MINLOD, value);
    }

    public static void nmaxLod(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)MAXLOD, value);
    }

    public static void nborderColor(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)BORDERCOLOR, value);
    }

    public static void nunnormalizedCoordinates(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)UNNORMALIZEDCOORDINATES, value);
    }

    static {
        Struct.Layout layout = VkSamplerCreateInfo.__struct(VkSamplerCreateInfo.__member(4), VkSamplerCreateInfo.__member(POINTER_SIZE), VkSamplerCreateInfo.__member(4), VkSamplerCreateInfo.__member(4), VkSamplerCreateInfo.__member(4), VkSamplerCreateInfo.__member(4), VkSamplerCreateInfo.__member(4), VkSamplerCreateInfo.__member(4), VkSamplerCreateInfo.__member(4), VkSamplerCreateInfo.__member(4), VkSamplerCreateInfo.__member(4), VkSamplerCreateInfo.__member(4), VkSamplerCreateInfo.__member(4), VkSamplerCreateInfo.__member(4), VkSamplerCreateInfo.__member(4), VkSamplerCreateInfo.__member(4), VkSamplerCreateInfo.__member(4), VkSamplerCreateInfo.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        MAGFILTER = layout.offsetof(3);
        MINFILTER = layout.offsetof(4);
        MIPMAPMODE = layout.offsetof(5);
        ADDRESSMODEU = layout.offsetof(6);
        ADDRESSMODEV = layout.offsetof(7);
        ADDRESSMODEW = layout.offsetof(8);
        MIPLODBIAS = layout.offsetof(9);
        ANISOTROPYENABLE = layout.offsetof(10);
        MAXANISOTROPY = layout.offsetof(11);
        COMPAREENABLE = layout.offsetof(12);
        COMPAREOP = layout.offsetof(13);
        MINLOD = layout.offsetof(14);
        MAXLOD = layout.offsetof(15);
        BORDERCOLOR = layout.offsetof(16);
        UNNORMALIZEDCOORDINATES = layout.offsetof(17);
    }

    public static class Buffer
    extends StructBuffer<VkSamplerCreateInfo, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkSamplerCreateInfo newInstance(long address) {
            return new VkSamplerCreateInfo(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkSamplerCreateInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkSamplerCreateInfo.npNext(this.address());
        }

        @NativeType(value="VkSamplerCreateFlags")
        public int flags() {
            return VkSamplerCreateInfo.nflags(this.address());
        }

        @NativeType(value="VkFilter")
        public int magFilter() {
            return VkSamplerCreateInfo.nmagFilter(this.address());
        }

        @NativeType(value="VkFilter")
        public int minFilter() {
            return VkSamplerCreateInfo.nminFilter(this.address());
        }

        @NativeType(value="VkSamplerMipmapMode")
        public int mipmapMode() {
            return VkSamplerCreateInfo.nmipmapMode(this.address());
        }

        @NativeType(value="VkSamplerAddressMode")
        public int addressModeU() {
            return VkSamplerCreateInfo.naddressModeU(this.address());
        }

        @NativeType(value="VkSamplerAddressMode")
        public int addressModeV() {
            return VkSamplerCreateInfo.naddressModeV(this.address());
        }

        @NativeType(value="VkSamplerAddressMode")
        public int addressModeW() {
            return VkSamplerCreateInfo.naddressModeW(this.address());
        }

        public float mipLodBias() {
            return VkSamplerCreateInfo.nmipLodBias(this.address());
        }

        @NativeType(value="VkBool32")
        public boolean anisotropyEnable() {
            return VkSamplerCreateInfo.nanisotropyEnable(this.address()) != 0;
        }

        public float maxAnisotropy() {
            return VkSamplerCreateInfo.nmaxAnisotropy(this.address());
        }

        @NativeType(value="VkBool32")
        public boolean compareEnable() {
            return VkSamplerCreateInfo.ncompareEnable(this.address()) != 0;
        }

        @NativeType(value="VkCompareOp")
        public int compareOp() {
            return VkSamplerCreateInfo.ncompareOp(this.address());
        }

        public float minLod() {
            return VkSamplerCreateInfo.nminLod(this.address());
        }

        public float maxLod() {
            return VkSamplerCreateInfo.nmaxLod(this.address());
        }

        @NativeType(value="VkBorderColor")
        public int borderColor() {
            return VkSamplerCreateInfo.nborderColor(this.address());
        }

        @NativeType(value="VkBool32")
        public boolean unnormalizedCoordinates() {
            return VkSamplerCreateInfo.nunnormalizedCoordinates(this.address()) != 0;
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkSamplerCreateInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkSamplerCreateInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="VkSamplerCreateFlags") int value) {
            VkSamplerCreateInfo.nflags(this.address(), value);
            return this;
        }

        public Buffer magFilter(@NativeType(value="VkFilter") int value) {
            VkSamplerCreateInfo.nmagFilter(this.address(), value);
            return this;
        }

        public Buffer minFilter(@NativeType(value="VkFilter") int value) {
            VkSamplerCreateInfo.nminFilter(this.address(), value);
            return this;
        }

        public Buffer mipmapMode(@NativeType(value="VkSamplerMipmapMode") int value) {
            VkSamplerCreateInfo.nmipmapMode(this.address(), value);
            return this;
        }

        public Buffer addressModeU(@NativeType(value="VkSamplerAddressMode") int value) {
            VkSamplerCreateInfo.naddressModeU(this.address(), value);
            return this;
        }

        public Buffer addressModeV(@NativeType(value="VkSamplerAddressMode") int value) {
            VkSamplerCreateInfo.naddressModeV(this.address(), value);
            return this;
        }

        public Buffer addressModeW(@NativeType(value="VkSamplerAddressMode") int value) {
            VkSamplerCreateInfo.naddressModeW(this.address(), value);
            return this;
        }

        public Buffer mipLodBias(float value) {
            VkSamplerCreateInfo.nmipLodBias(this.address(), value);
            return this;
        }

        public Buffer anisotropyEnable(@NativeType(value="VkBool32") boolean value) {
            VkSamplerCreateInfo.nanisotropyEnable(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer maxAnisotropy(float value) {
            VkSamplerCreateInfo.nmaxAnisotropy(this.address(), value);
            return this;
        }

        public Buffer compareEnable(@NativeType(value="VkBool32") boolean value) {
            VkSamplerCreateInfo.ncompareEnable(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer compareOp(@NativeType(value="VkCompareOp") int value) {
            VkSamplerCreateInfo.ncompareOp(this.address(), value);
            return this;
        }

        public Buffer minLod(float value) {
            VkSamplerCreateInfo.nminLod(this.address(), value);
            return this;
        }

        public Buffer maxLod(float value) {
            VkSamplerCreateInfo.nmaxLod(this.address(), value);
            return this;
        }

        public Buffer borderColor(@NativeType(value="VkBorderColor") int value) {
            VkSamplerCreateInfo.nborderColor(this.address(), value);
            return this;
        }

        public Buffer unnormalizedCoordinates(@NativeType(value="VkBool32") boolean value) {
            VkSamplerCreateInfo.nunnormalizedCoordinates(this.address(), value ? 1 : 0);
            return this;
        }
    }
}

