/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VkRenderPassMultiviewCreateInfo;

public class VkRenderPassMultiviewCreateInfoKHR
extends VkRenderPassMultiviewCreateInfo {
    VkRenderPassMultiviewCreateInfoKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkRenderPassMultiviewCreateInfoKHR(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkRenderPassMultiviewCreateInfoKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public VkRenderPassMultiviewCreateInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkRenderPassMultiviewCreateInfoKHR.nsType(this.address(), value);
        return this;
    }

    @Override
    public VkRenderPassMultiviewCreateInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkRenderPassMultiviewCreateInfoKHR.npNext(this.address(), value);
        return this;
    }

    @Override
    public VkRenderPassMultiviewCreateInfoKHR pViewMasks(@Nullable @NativeType(value="uint32_t const *") IntBuffer value) {
        VkRenderPassMultiviewCreateInfoKHR.npViewMasks(this.address(), value);
        return this;
    }

    @Override
    public VkRenderPassMultiviewCreateInfoKHR pViewOffsets(@Nullable @NativeType(value="int32_t const *") IntBuffer value) {
        VkRenderPassMultiviewCreateInfoKHR.npViewOffsets(this.address(), value);
        return this;
    }

    @Override
    public VkRenderPassMultiviewCreateInfoKHR pCorrelationMasks(@Nullable @NativeType(value="uint32_t const *") IntBuffer value) {
        VkRenderPassMultiviewCreateInfoKHR.npCorrelationMasks(this.address(), value);
        return this;
    }

    @Override
    public VkRenderPassMultiviewCreateInfoKHR set(int sType, long pNext, @Nullable IntBuffer pViewMasks, @Nullable IntBuffer pViewOffsets, @Nullable IntBuffer pCorrelationMasks) {
        this.sType(sType);
        this.pNext(pNext);
        this.pViewMasks(pViewMasks);
        this.pViewOffsets(pViewOffsets);
        this.pCorrelationMasks(pCorrelationMasks);
        return this;
    }

    public VkRenderPassMultiviewCreateInfoKHR set(VkRenderPassMultiviewCreateInfoKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkRenderPassMultiviewCreateInfoKHR malloc() {
        return VkRenderPassMultiviewCreateInfoKHR.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkRenderPassMultiviewCreateInfoKHR calloc() {
        return VkRenderPassMultiviewCreateInfoKHR.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkRenderPassMultiviewCreateInfoKHR create() {
        return new VkRenderPassMultiviewCreateInfoKHR(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkRenderPassMultiviewCreateInfoKHR create(long address) {
        return new VkRenderPassMultiviewCreateInfoKHR(address, null);
    }

    @Nullable
    public static VkRenderPassMultiviewCreateInfoKHR createSafe(long address) {
        return address == 0L ? null : VkRenderPassMultiviewCreateInfoKHR.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkRenderPassMultiviewCreateInfoKHR.create(VkRenderPassMultiviewCreateInfoKHR.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkRenderPassMultiviewCreateInfoKHR.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkRenderPassMultiviewCreateInfoKHR.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkRenderPassMultiviewCreateInfoKHR.create(address, capacity);
    }

    public static VkRenderPassMultiviewCreateInfoKHR mallocStack() {
        return VkRenderPassMultiviewCreateInfoKHR.mallocStack(MemoryStack.stackGet());
    }

    public static VkRenderPassMultiviewCreateInfoKHR callocStack() {
        return VkRenderPassMultiviewCreateInfoKHR.callocStack(MemoryStack.stackGet());
    }

    public static VkRenderPassMultiviewCreateInfoKHR mallocStack(MemoryStack stack) {
        return VkRenderPassMultiviewCreateInfoKHR.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkRenderPassMultiviewCreateInfoKHR callocStack(MemoryStack stack) {
        return VkRenderPassMultiviewCreateInfoKHR.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkRenderPassMultiviewCreateInfoKHR.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkRenderPassMultiviewCreateInfoKHR.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkRenderPassMultiviewCreateInfoKHR.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkRenderPassMultiviewCreateInfoKHR.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static class Buffer
    extends VkRenderPassMultiviewCreateInfo.Buffer {
        public Buffer(ByteBuffer container) {
            super(container);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkRenderPassMultiviewCreateInfoKHR newInstance(long address) {
            return new VkRenderPassMultiviewCreateInfoKHR(address, this.container);
        }

        @Override
        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkRenderPassMultiviewCreateInfoKHR.nsType(this.address(), value);
            return this;
        }

        @Override
        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkRenderPassMultiviewCreateInfoKHR.npNext(this.address(), value);
            return this;
        }

        @Override
        public Buffer pViewMasks(@Nullable @NativeType(value="uint32_t const *") IntBuffer value) {
            VkRenderPassMultiviewCreateInfoKHR.npViewMasks(this.address(), value);
            return this;
        }

        @Override
        public Buffer pViewOffsets(@Nullable @NativeType(value="int32_t const *") IntBuffer value) {
            VkRenderPassMultiviewCreateInfoKHR.npViewOffsets(this.address(), value);
            return this;
        }

        @Override
        public Buffer pCorrelationMasks(@Nullable @NativeType(value="uint32_t const *") IntBuffer value) {
            VkRenderPassMultiviewCreateInfoKHR.npCorrelationMasks(this.address(), value);
            return this;
        }
    }
}

