/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkExtent2D;
import org.lwjgl.vulkan.VkOffset2D;

public class VkRectLayerKHR
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int OFFSET;
    public static final int EXTENT;
    public static final int LAYER;

    VkRectLayerKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkRectLayerKHR(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkRectLayerKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public VkOffset2D offset() {
        return VkRectLayerKHR.noffset(this.address());
    }

    public VkRectLayerKHR offset(Consumer<VkOffset2D> consumer) {
        consumer.accept(this.offset());
        return this;
    }

    public VkExtent2D extent() {
        return VkRectLayerKHR.nextent(this.address());
    }

    public VkRectLayerKHR extent(Consumer<VkExtent2D> consumer) {
        consumer.accept(this.extent());
        return this;
    }

    @NativeType(value="uint32_t")
    public int layer() {
        return VkRectLayerKHR.nlayer(this.address());
    }

    public VkRectLayerKHR offset(VkOffset2D value) {
        VkRectLayerKHR.noffset(this.address(), value);
        return this;
    }

    public VkRectLayerKHR extent(VkExtent2D value) {
        VkRectLayerKHR.nextent(this.address(), value);
        return this;
    }

    public VkRectLayerKHR layer(@NativeType(value="uint32_t") int value) {
        VkRectLayerKHR.nlayer(this.address(), value);
        return this;
    }

    public VkRectLayerKHR set(VkOffset2D offset, VkExtent2D extent, int layer) {
        this.offset(offset);
        this.extent(extent);
        this.layer(layer);
        return this;
    }

    public VkRectLayerKHR set(VkRectLayerKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkRectLayerKHR malloc() {
        return VkRectLayerKHR.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkRectLayerKHR calloc() {
        return VkRectLayerKHR.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkRectLayerKHR create() {
        return new VkRectLayerKHR(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkRectLayerKHR create(long address) {
        return new VkRectLayerKHR(address, null);
    }

    @Nullable
    public static VkRectLayerKHR createSafe(long address) {
        return address == 0L ? null : VkRectLayerKHR.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkRectLayerKHR.create(VkRectLayerKHR.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkRectLayerKHR.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkRectLayerKHR.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkRectLayerKHR.create(address, capacity);
    }

    public static VkRectLayerKHR mallocStack() {
        return VkRectLayerKHR.mallocStack(MemoryStack.stackGet());
    }

    public static VkRectLayerKHR callocStack() {
        return VkRectLayerKHR.callocStack(MemoryStack.stackGet());
    }

    public static VkRectLayerKHR mallocStack(MemoryStack stack) {
        return VkRectLayerKHR.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkRectLayerKHR callocStack(MemoryStack stack) {
        return VkRectLayerKHR.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkRectLayerKHR.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkRectLayerKHR.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkRectLayerKHR.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkRectLayerKHR.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static VkOffset2D noffset(long struct) {
        return VkOffset2D.create(struct + (long)OFFSET);
    }

    public static VkExtent2D nextent(long struct) {
        return VkExtent2D.create(struct + (long)EXTENT);
    }

    public static int nlayer(long struct) {
        return MemoryUtil.memGetInt(struct + (long)LAYER);
    }

    public static void noffset(long struct, VkOffset2D value) {
        MemoryUtil.memCopy(value.address(), struct + (long)OFFSET, VkOffset2D.SIZEOF);
    }

    public static void nextent(long struct, VkExtent2D value) {
        MemoryUtil.memCopy(value.address(), struct + (long)EXTENT, VkExtent2D.SIZEOF);
    }

    public static void nlayer(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)LAYER, value);
    }

    static {
        Struct.Layout layout = VkRectLayerKHR.__struct(VkRectLayerKHR.__member(VkOffset2D.SIZEOF, VkOffset2D.ALIGNOF), VkRectLayerKHR.__member(VkExtent2D.SIZEOF, VkExtent2D.ALIGNOF), VkRectLayerKHR.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        OFFSET = layout.offsetof(0);
        EXTENT = layout.offsetof(1);
        LAYER = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkRectLayerKHR, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkRectLayerKHR newInstance(long address) {
            return new VkRectLayerKHR(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        public VkOffset2D offset() {
            return VkRectLayerKHR.noffset(this.address());
        }

        public Buffer offset(Consumer<VkOffset2D> consumer) {
            consumer.accept(this.offset());
            return this;
        }

        public VkExtent2D extent() {
            return VkRectLayerKHR.nextent(this.address());
        }

        public Buffer extent(Consumer<VkExtent2D> consumer) {
            consumer.accept(this.extent());
            return this;
        }

        @NativeType(value="uint32_t")
        public int layer() {
            return VkRectLayerKHR.nlayer(this.address());
        }

        public Buffer offset(VkOffset2D value) {
            VkRectLayerKHR.noffset(this.address(), value);
            return this;
        }

        public Buffer extent(VkExtent2D value) {
            VkRectLayerKHR.nextent(this.address(), value);
            return this;
        }

        public Buffer layer(@NativeType(value="uint32_t") int value) {
            VkRectLayerKHR.nlayer(this.address(), value);
            return this;
        }
    }
}

