/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkQueryPoolCreateInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int QUERYTYPE;
    public static final int QUERYCOUNT;
    public static final int PIPELINESTATISTICS;

    VkQueryPoolCreateInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkQueryPoolCreateInfo(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkQueryPoolCreateInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkQueryPoolCreateInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkQueryPoolCreateInfo.npNext(this.address());
    }

    @NativeType(value="VkQueryPoolCreateFlags")
    public int flags() {
        return VkQueryPoolCreateInfo.nflags(this.address());
    }

    @NativeType(value="VkQueryType")
    public int queryType() {
        return VkQueryPoolCreateInfo.nqueryType(this.address());
    }

    @NativeType(value="uint32_t")
    public int queryCount() {
        return VkQueryPoolCreateInfo.nqueryCount(this.address());
    }

    @NativeType(value="VkQueryPipelineStatisticFlags")
    public int pipelineStatistics() {
        return VkQueryPoolCreateInfo.npipelineStatistics(this.address());
    }

    public VkQueryPoolCreateInfo sType(@NativeType(value="VkStructureType") int value) {
        VkQueryPoolCreateInfo.nsType(this.address(), value);
        return this;
    }

    public VkQueryPoolCreateInfo pNext(@NativeType(value="void const *") long value) {
        VkQueryPoolCreateInfo.npNext(this.address(), value);
        return this;
    }

    public VkQueryPoolCreateInfo flags(@NativeType(value="VkQueryPoolCreateFlags") int value) {
        VkQueryPoolCreateInfo.nflags(this.address(), value);
        return this;
    }

    public VkQueryPoolCreateInfo queryType(@NativeType(value="VkQueryType") int value) {
        VkQueryPoolCreateInfo.nqueryType(this.address(), value);
        return this;
    }

    public VkQueryPoolCreateInfo queryCount(@NativeType(value="uint32_t") int value) {
        VkQueryPoolCreateInfo.nqueryCount(this.address(), value);
        return this;
    }

    public VkQueryPoolCreateInfo pipelineStatistics(@NativeType(value="VkQueryPipelineStatisticFlags") int value) {
        VkQueryPoolCreateInfo.npipelineStatistics(this.address(), value);
        return this;
    }

    public VkQueryPoolCreateInfo set(int sType, long pNext, int flags, int queryType, int queryCount, int pipelineStatistics) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.queryType(queryType);
        this.queryCount(queryCount);
        this.pipelineStatistics(pipelineStatistics);
        return this;
    }

    public VkQueryPoolCreateInfo set(VkQueryPoolCreateInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkQueryPoolCreateInfo malloc() {
        return VkQueryPoolCreateInfo.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkQueryPoolCreateInfo calloc() {
        return VkQueryPoolCreateInfo.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkQueryPoolCreateInfo create() {
        return new VkQueryPoolCreateInfo(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkQueryPoolCreateInfo create(long address) {
        return new VkQueryPoolCreateInfo(address, null);
    }

    @Nullable
    public static VkQueryPoolCreateInfo createSafe(long address) {
        return address == 0L ? null : VkQueryPoolCreateInfo.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkQueryPoolCreateInfo.create(VkQueryPoolCreateInfo.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkQueryPoolCreateInfo.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkQueryPoolCreateInfo.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkQueryPoolCreateInfo.create(address, capacity);
    }

    public static VkQueryPoolCreateInfo mallocStack() {
        return VkQueryPoolCreateInfo.mallocStack(MemoryStack.stackGet());
    }

    public static VkQueryPoolCreateInfo callocStack() {
        return VkQueryPoolCreateInfo.callocStack(MemoryStack.stackGet());
    }

    public static VkQueryPoolCreateInfo mallocStack(MemoryStack stack) {
        return VkQueryPoolCreateInfo.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkQueryPoolCreateInfo callocStack(MemoryStack stack) {
        return VkQueryPoolCreateInfo.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkQueryPoolCreateInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkQueryPoolCreateInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkQueryPoolCreateInfo.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkQueryPoolCreateInfo.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nflags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FLAGS);
    }

    public static int nqueryType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)QUERYTYPE);
    }

    public static int nqueryCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)QUERYCOUNT);
    }

    public static int npipelineStatistics(long struct) {
        return MemoryUtil.memGetInt(struct + (long)PIPELINESTATISTICS);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nflags(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FLAGS, value);
    }

    public static void nqueryType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)QUERYTYPE, value);
    }

    public static void nqueryCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)QUERYCOUNT, value);
    }

    public static void npipelineStatistics(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)PIPELINESTATISTICS, value);
    }

    static {
        Struct.Layout layout = VkQueryPoolCreateInfo.__struct(VkQueryPoolCreateInfo.__member(4), VkQueryPoolCreateInfo.__member(POINTER_SIZE), VkQueryPoolCreateInfo.__member(4), VkQueryPoolCreateInfo.__member(4), VkQueryPoolCreateInfo.__member(4), VkQueryPoolCreateInfo.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        QUERYTYPE = layout.offsetof(3);
        QUERYCOUNT = layout.offsetof(4);
        PIPELINESTATISTICS = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<VkQueryPoolCreateInfo, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkQueryPoolCreateInfo newInstance(long address) {
            return new VkQueryPoolCreateInfo(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkQueryPoolCreateInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkQueryPoolCreateInfo.npNext(this.address());
        }

        @NativeType(value="VkQueryPoolCreateFlags")
        public int flags() {
            return VkQueryPoolCreateInfo.nflags(this.address());
        }

        @NativeType(value="VkQueryType")
        public int queryType() {
            return VkQueryPoolCreateInfo.nqueryType(this.address());
        }

        @NativeType(value="uint32_t")
        public int queryCount() {
            return VkQueryPoolCreateInfo.nqueryCount(this.address());
        }

        @NativeType(value="VkQueryPipelineStatisticFlags")
        public int pipelineStatistics() {
            return VkQueryPoolCreateInfo.npipelineStatistics(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkQueryPoolCreateInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkQueryPoolCreateInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="VkQueryPoolCreateFlags") int value) {
            VkQueryPoolCreateInfo.nflags(this.address(), value);
            return this;
        }

        public Buffer queryType(@NativeType(value="VkQueryType") int value) {
            VkQueryPoolCreateInfo.nqueryType(this.address(), value);
            return this;
        }

        public Buffer queryCount(@NativeType(value="uint32_t") int value) {
            VkQueryPoolCreateInfo.nqueryCount(this.address(), value);
            return this;
        }

        public Buffer pipelineStatistics(@NativeType(value="VkQueryPipelineStatisticFlags") int value) {
            VkQueryPoolCreateInfo.npipelineStatistics(this.address(), value);
            return this;
        }
    }
}

