/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkPhysicalDeviceSubgroupProperties
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int SUBGROUPSIZE;
    public static final int SUPPORTEDSTAGES;
    public static final int SUPPORTEDOPERATIONS;
    public static final int QUADOPERATIONSINALLSTAGES;

    VkPhysicalDeviceSubgroupProperties(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkPhysicalDeviceSubgroupProperties(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkPhysicalDeviceSubgroupProperties.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkPhysicalDeviceSubgroupProperties.nsType(this.address());
    }

    @NativeType(value="void *")
    public long pNext() {
        return VkPhysicalDeviceSubgroupProperties.npNext(this.address());
    }

    @NativeType(value="uint32_t")
    public int subgroupSize() {
        return VkPhysicalDeviceSubgroupProperties.nsubgroupSize(this.address());
    }

    @NativeType(value="VkShaderStageFlags")
    public int supportedStages() {
        return VkPhysicalDeviceSubgroupProperties.nsupportedStages(this.address());
    }

    @NativeType(value="VkSubgroupFeatureFlags")
    public int supportedOperations() {
        return VkPhysicalDeviceSubgroupProperties.nsupportedOperations(this.address());
    }

    @NativeType(value="VkBool32")
    public boolean quadOperationsInAllStages() {
        return VkPhysicalDeviceSubgroupProperties.nquadOperationsInAllStages(this.address()) != 0;
    }

    public VkPhysicalDeviceSubgroupProperties sType(@NativeType(value="VkStructureType") int value) {
        VkPhysicalDeviceSubgroupProperties.nsType(this.address(), value);
        return this;
    }

    public VkPhysicalDeviceSubgroupProperties pNext(@NativeType(value="void *") long value) {
        VkPhysicalDeviceSubgroupProperties.npNext(this.address(), value);
        return this;
    }

    public VkPhysicalDeviceSubgroupProperties set(int sType, long pNext) {
        this.sType(sType);
        this.pNext(pNext);
        return this;
    }

    public VkPhysicalDeviceSubgroupProperties set(VkPhysicalDeviceSubgroupProperties src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkPhysicalDeviceSubgroupProperties create(long address) {
        return new VkPhysicalDeviceSubgroupProperties(address, null);
    }

    @Nullable
    public static VkPhysicalDeviceSubgroupProperties createSafe(long address) {
        return address == 0L ? null : VkPhysicalDeviceSubgroupProperties.create(address);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkPhysicalDeviceSubgroupProperties.create(address, capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nsubgroupSize(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SUBGROUPSIZE);
    }

    public static int nsupportedStages(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SUPPORTEDSTAGES);
    }

    public static int nsupportedOperations(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SUPPORTEDOPERATIONS);
    }

    public static int nquadOperationsInAllStages(long struct) {
        return MemoryUtil.memGetInt(struct + (long)QUADOPERATIONSINALLSTAGES);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    static {
        Struct.Layout layout = VkPhysicalDeviceSubgroupProperties.__struct(VkPhysicalDeviceSubgroupProperties.__member(4), VkPhysicalDeviceSubgroupProperties.__member(POINTER_SIZE), VkPhysicalDeviceSubgroupProperties.__member(4), VkPhysicalDeviceSubgroupProperties.__member(4), VkPhysicalDeviceSubgroupProperties.__member(4), VkPhysicalDeviceSubgroupProperties.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        SUBGROUPSIZE = layout.offsetof(2);
        SUPPORTEDSTAGES = layout.offsetof(3);
        SUPPORTEDOPERATIONS = layout.offsetof(4);
        QUADOPERATIONSINALLSTAGES = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<VkPhysicalDeviceSubgroupProperties, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkPhysicalDeviceSubgroupProperties newInstance(long address) {
            return new VkPhysicalDeviceSubgroupProperties(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkPhysicalDeviceSubgroupProperties.nsType(this.address());
        }

        @NativeType(value="void *")
        public long pNext() {
            return VkPhysicalDeviceSubgroupProperties.npNext(this.address());
        }

        @NativeType(value="uint32_t")
        public int subgroupSize() {
            return VkPhysicalDeviceSubgroupProperties.nsubgroupSize(this.address());
        }

        @NativeType(value="VkShaderStageFlags")
        public int supportedStages() {
            return VkPhysicalDeviceSubgroupProperties.nsupportedStages(this.address());
        }

        @NativeType(value="VkSubgroupFeatureFlags")
        public int supportedOperations() {
            return VkPhysicalDeviceSubgroupProperties.nsupportedOperations(this.address());
        }

        @NativeType(value="VkBool32")
        public boolean quadOperationsInAllStages() {
            return VkPhysicalDeviceSubgroupProperties.nquadOperationsInAllStages(this.address()) != 0;
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkPhysicalDeviceSubgroupProperties.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void *") long value) {
            VkPhysicalDeviceSubgroupProperties.npNext(this.address(), value);
            return this;
        }
    }
}

