/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkPhysicalDeviceProperties;

public class VkPhysicalDeviceProperties2
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int PROPERTIES;

    VkPhysicalDeviceProperties2(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkPhysicalDeviceProperties2(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkPhysicalDeviceProperties2.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkPhysicalDeviceProperties2.nsType(this.address());
    }

    @NativeType(value="void *")
    public long pNext() {
        return VkPhysicalDeviceProperties2.npNext(this.address());
    }

    public VkPhysicalDeviceProperties properties() {
        return VkPhysicalDeviceProperties2.nproperties(this.address());
    }

    public VkPhysicalDeviceProperties2 sType(@NativeType(value="VkStructureType") int value) {
        VkPhysicalDeviceProperties2.nsType(this.address(), value);
        return this;
    }

    public VkPhysicalDeviceProperties2 pNext(@NativeType(value="void *") long value) {
        VkPhysicalDeviceProperties2.npNext(this.address(), value);
        return this;
    }

    public VkPhysicalDeviceProperties2 set(int sType, long pNext) {
        this.sType(sType);
        this.pNext(pNext);
        return this;
    }

    public VkPhysicalDeviceProperties2 set(VkPhysicalDeviceProperties2 src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkPhysicalDeviceProperties2 malloc() {
        return VkPhysicalDeviceProperties2.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkPhysicalDeviceProperties2 calloc() {
        return VkPhysicalDeviceProperties2.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkPhysicalDeviceProperties2 create() {
        return new VkPhysicalDeviceProperties2(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkPhysicalDeviceProperties2 create(long address) {
        return new VkPhysicalDeviceProperties2(address, null);
    }

    @Nullable
    public static VkPhysicalDeviceProperties2 createSafe(long address) {
        return address == 0L ? null : VkPhysicalDeviceProperties2.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkPhysicalDeviceProperties2.create(VkPhysicalDeviceProperties2.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkPhysicalDeviceProperties2.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkPhysicalDeviceProperties2.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkPhysicalDeviceProperties2.create(address, capacity);
    }

    public static VkPhysicalDeviceProperties2 mallocStack() {
        return VkPhysicalDeviceProperties2.mallocStack(MemoryStack.stackGet());
    }

    public static VkPhysicalDeviceProperties2 callocStack() {
        return VkPhysicalDeviceProperties2.callocStack(MemoryStack.stackGet());
    }

    public static VkPhysicalDeviceProperties2 mallocStack(MemoryStack stack) {
        return VkPhysicalDeviceProperties2.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkPhysicalDeviceProperties2 callocStack(MemoryStack stack) {
        return VkPhysicalDeviceProperties2.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkPhysicalDeviceProperties2.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkPhysicalDeviceProperties2.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkPhysicalDeviceProperties2.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkPhysicalDeviceProperties2.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static VkPhysicalDeviceProperties nproperties(long struct) {
        return VkPhysicalDeviceProperties.create(struct + (long)PROPERTIES);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    static {
        Struct.Layout layout = VkPhysicalDeviceProperties2.__struct(VkPhysicalDeviceProperties2.__member(4), VkPhysicalDeviceProperties2.__member(POINTER_SIZE), VkPhysicalDeviceProperties2.__member(VkPhysicalDeviceProperties.SIZEOF, VkPhysicalDeviceProperties.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        PROPERTIES = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkPhysicalDeviceProperties2, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkPhysicalDeviceProperties2 newInstance(long address) {
            return new VkPhysicalDeviceProperties2(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkPhysicalDeviceProperties2.nsType(this.address());
        }

        @NativeType(value="void *")
        public long pNext() {
            return VkPhysicalDeviceProperties2.npNext(this.address());
        }

        public VkPhysicalDeviceProperties properties() {
            return VkPhysicalDeviceProperties2.nproperties(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkPhysicalDeviceProperties2.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void *") long value) {
            VkPhysicalDeviceProperties2.npNext(this.address(), value);
            return this;
        }
    }
}

