/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkPhysicalDeviceIDProperties
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int DEVICEUUID;
    public static final int DRIVERUUID;
    public static final int DEVICELUID;
    public static final int DEVICENODEMASK;
    public static final int DEVICELUIDVALID;

    VkPhysicalDeviceIDProperties(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkPhysicalDeviceIDProperties(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkPhysicalDeviceIDProperties.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkPhysicalDeviceIDProperties.nsType(this.address());
    }

    @NativeType(value="void *")
    public long pNext() {
        return VkPhysicalDeviceIDProperties.npNext(this.address());
    }

    @NativeType(value="uint8_t[VK_UUID_SIZE]")
    public ByteBuffer deviceUUID() {
        return VkPhysicalDeviceIDProperties.ndeviceUUID(this.address());
    }

    @NativeType(value="uint8_t")
    public byte deviceUUID(int index) {
        return VkPhysicalDeviceIDProperties.ndeviceUUID(this.address(), index);
    }

    @NativeType(value="uint8_t[VK_UUID_SIZE]")
    public ByteBuffer driverUUID() {
        return VkPhysicalDeviceIDProperties.ndriverUUID(this.address());
    }

    @NativeType(value="uint8_t")
    public byte driverUUID(int index) {
        return VkPhysicalDeviceIDProperties.ndriverUUID(this.address(), index);
    }

    @NativeType(value="uint8_t[VK_LUID_SIZE]")
    public ByteBuffer deviceLUID() {
        return VkPhysicalDeviceIDProperties.ndeviceLUID(this.address());
    }

    @NativeType(value="uint8_t")
    public byte deviceLUID(int index) {
        return VkPhysicalDeviceIDProperties.ndeviceLUID(this.address(), index);
    }

    @NativeType(value="uint32_t")
    public int deviceNodeMask() {
        return VkPhysicalDeviceIDProperties.ndeviceNodeMask(this.address());
    }

    @NativeType(value="VkBool32")
    public boolean deviceLUIDValid() {
        return VkPhysicalDeviceIDProperties.ndeviceLUIDValid(this.address()) != 0;
    }

    public VkPhysicalDeviceIDProperties sType(@NativeType(value="VkStructureType") int value) {
        VkPhysicalDeviceIDProperties.nsType(this.address(), value);
        return this;
    }

    public VkPhysicalDeviceIDProperties pNext(@NativeType(value="void *") long value) {
        VkPhysicalDeviceIDProperties.npNext(this.address(), value);
        return this;
    }

    public VkPhysicalDeviceIDProperties set(int sType, long pNext) {
        this.sType(sType);
        this.pNext(pNext);
        return this;
    }

    public VkPhysicalDeviceIDProperties set(VkPhysicalDeviceIDProperties src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkPhysicalDeviceIDProperties create(long address) {
        return new VkPhysicalDeviceIDProperties(address, null);
    }

    @Nullable
    public static VkPhysicalDeviceIDProperties createSafe(long address) {
        return address == 0L ? null : VkPhysicalDeviceIDProperties.create(address);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkPhysicalDeviceIDProperties.create(address, capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static ByteBuffer ndeviceUUID(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)DEVICEUUID, 16);
    }

    public static byte ndeviceUUID(long struct, int index) {
        return MemoryUtil.memGetByte(struct + (long)DEVICEUUID + Checks.check(index, 16) * 1L);
    }

    public static ByteBuffer ndriverUUID(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)DRIVERUUID, 16);
    }

    public static byte ndriverUUID(long struct, int index) {
        return MemoryUtil.memGetByte(struct + (long)DRIVERUUID + Checks.check(index, 16) * 1L);
    }

    public static ByteBuffer ndeviceLUID(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)DEVICELUID, 8);
    }

    public static byte ndeviceLUID(long struct, int index) {
        return MemoryUtil.memGetByte(struct + (long)DEVICELUID + Checks.check(index, 8) * 1L);
    }

    public static int ndeviceNodeMask(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DEVICENODEMASK);
    }

    public static int ndeviceLUIDValid(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DEVICELUIDVALID);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    static {
        Struct.Layout layout = VkPhysicalDeviceIDProperties.__struct(VkPhysicalDeviceIDProperties.__member(4), VkPhysicalDeviceIDProperties.__member(POINTER_SIZE), VkPhysicalDeviceIDProperties.__array(1, 16), VkPhysicalDeviceIDProperties.__array(1, 16), VkPhysicalDeviceIDProperties.__array(1, 8), VkPhysicalDeviceIDProperties.__member(4), VkPhysicalDeviceIDProperties.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        DEVICEUUID = layout.offsetof(2);
        DRIVERUUID = layout.offsetof(3);
        DEVICELUID = layout.offsetof(4);
        DEVICENODEMASK = layout.offsetof(5);
        DEVICELUIDVALID = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<VkPhysicalDeviceIDProperties, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkPhysicalDeviceIDProperties newInstance(long address) {
            return new VkPhysicalDeviceIDProperties(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkPhysicalDeviceIDProperties.nsType(this.address());
        }

        @NativeType(value="void *")
        public long pNext() {
            return VkPhysicalDeviceIDProperties.npNext(this.address());
        }

        @NativeType(value="uint8_t[VK_UUID_SIZE]")
        public ByteBuffer deviceUUID() {
            return VkPhysicalDeviceIDProperties.ndeviceUUID(this.address());
        }

        @NativeType(value="uint8_t")
        public byte deviceUUID(int index) {
            return VkPhysicalDeviceIDProperties.ndeviceUUID(this.address(), index);
        }

        @NativeType(value="uint8_t[VK_UUID_SIZE]")
        public ByteBuffer driverUUID() {
            return VkPhysicalDeviceIDProperties.ndriverUUID(this.address());
        }

        @NativeType(value="uint8_t")
        public byte driverUUID(int index) {
            return VkPhysicalDeviceIDProperties.ndriverUUID(this.address(), index);
        }

        @NativeType(value="uint8_t[VK_LUID_SIZE]")
        public ByteBuffer deviceLUID() {
            return VkPhysicalDeviceIDProperties.ndeviceLUID(this.address());
        }

        @NativeType(value="uint8_t")
        public byte deviceLUID(int index) {
            return VkPhysicalDeviceIDProperties.ndeviceLUID(this.address(), index);
        }

        @NativeType(value="uint32_t")
        public int deviceNodeMask() {
            return VkPhysicalDeviceIDProperties.ndeviceNodeMask(this.address());
        }

        @NativeType(value="VkBool32")
        public boolean deviceLUIDValid() {
            return VkPhysicalDeviceIDProperties.ndeviceLUIDValid(this.address()) != 0;
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkPhysicalDeviceIDProperties.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void *") long value) {
            VkPhysicalDeviceIDProperties.npNext(this.address(), value);
            return this;
        }
    }
}

