/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkObjectTablePipelineEntryNVX
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int FLAGS;
    public static final int PIPELINE;

    VkObjectTablePipelineEntryNVX(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkObjectTablePipelineEntryNVX(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkObjectTablePipelineEntryNVX.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkObjectEntryTypeNVX")
    public int type() {
        return VkObjectTablePipelineEntryNVX.ntype(this.address());
    }

    @NativeType(value="VkObjectEntryUsageFlagsNVX")
    public int flags() {
        return VkObjectTablePipelineEntryNVX.nflags(this.address());
    }

    @NativeType(value="VkPipeline")
    public long pipeline() {
        return VkObjectTablePipelineEntryNVX.npipeline(this.address());
    }

    public VkObjectTablePipelineEntryNVX type(@NativeType(value="VkObjectEntryTypeNVX") int value) {
        VkObjectTablePipelineEntryNVX.ntype(this.address(), value);
        return this;
    }

    public VkObjectTablePipelineEntryNVX flags(@NativeType(value="VkObjectEntryUsageFlagsNVX") int value) {
        VkObjectTablePipelineEntryNVX.nflags(this.address(), value);
        return this;
    }

    public VkObjectTablePipelineEntryNVX pipeline(@NativeType(value="VkPipeline") long value) {
        VkObjectTablePipelineEntryNVX.npipeline(this.address(), value);
        return this;
    }

    public VkObjectTablePipelineEntryNVX set(int type, int flags, long pipeline) {
        this.type(type);
        this.flags(flags);
        this.pipeline(pipeline);
        return this;
    }

    public VkObjectTablePipelineEntryNVX set(VkObjectTablePipelineEntryNVX src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkObjectTablePipelineEntryNVX malloc() {
        return VkObjectTablePipelineEntryNVX.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkObjectTablePipelineEntryNVX calloc() {
        return VkObjectTablePipelineEntryNVX.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkObjectTablePipelineEntryNVX create() {
        return new VkObjectTablePipelineEntryNVX(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkObjectTablePipelineEntryNVX create(long address) {
        return new VkObjectTablePipelineEntryNVX(address, null);
    }

    @Nullable
    public static VkObjectTablePipelineEntryNVX createSafe(long address) {
        return address == 0L ? null : VkObjectTablePipelineEntryNVX.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkObjectTablePipelineEntryNVX.create(VkObjectTablePipelineEntryNVX.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkObjectTablePipelineEntryNVX.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkObjectTablePipelineEntryNVX.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkObjectTablePipelineEntryNVX.create(address, capacity);
    }

    public static VkObjectTablePipelineEntryNVX mallocStack() {
        return VkObjectTablePipelineEntryNVX.mallocStack(MemoryStack.stackGet());
    }

    public static VkObjectTablePipelineEntryNVX callocStack() {
        return VkObjectTablePipelineEntryNVX.callocStack(MemoryStack.stackGet());
    }

    public static VkObjectTablePipelineEntryNVX mallocStack(MemoryStack stack) {
        return VkObjectTablePipelineEntryNVX.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkObjectTablePipelineEntryNVX callocStack(MemoryStack stack) {
        return VkObjectTablePipelineEntryNVX.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkObjectTablePipelineEntryNVX.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkObjectTablePipelineEntryNVX.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkObjectTablePipelineEntryNVX.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkObjectTablePipelineEntryNVX.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static int nflags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FLAGS);
    }

    public static long npipeline(long struct) {
        return MemoryUtil.memGetLong(struct + (long)PIPELINE);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nflags(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FLAGS, value);
    }

    public static void npipeline(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)PIPELINE, value);
    }

    static {
        Struct.Layout layout = VkObjectTablePipelineEntryNVX.__struct(VkObjectTablePipelineEntryNVX.__member(4), VkObjectTablePipelineEntryNVX.__member(4), VkObjectTablePipelineEntryNVX.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        FLAGS = layout.offsetof(1);
        PIPELINE = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkObjectTablePipelineEntryNVX, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkObjectTablePipelineEntryNVX newInstance(long address) {
            return new VkObjectTablePipelineEntryNVX(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="VkObjectEntryTypeNVX")
        public int type() {
            return VkObjectTablePipelineEntryNVX.ntype(this.address());
        }

        @NativeType(value="VkObjectEntryUsageFlagsNVX")
        public int flags() {
            return VkObjectTablePipelineEntryNVX.nflags(this.address());
        }

        @NativeType(value="VkPipeline")
        public long pipeline() {
            return VkObjectTablePipelineEntryNVX.npipeline(this.address());
        }

        public Buffer type(@NativeType(value="VkObjectEntryTypeNVX") int value) {
            VkObjectTablePipelineEntryNVX.ntype(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="VkObjectEntryUsageFlagsNVX") int value) {
            VkObjectTablePipelineEntryNVX.nflags(this.address(), value);
            return this;
        }

        public Buffer pipeline(@NativeType(value="VkPipeline") long value) {
            VkObjectTablePipelineEntryNVX.npipeline(this.address(), value);
            return this;
        }
    }
}

