/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkObjectTableDescriptorSetEntryNVX
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int FLAGS;
    public static final int PIPELINELAYOUT;
    public static final int DESCRIPTORSET;

    VkObjectTableDescriptorSetEntryNVX(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkObjectTableDescriptorSetEntryNVX(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkObjectTableDescriptorSetEntryNVX.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkObjectEntryTypeNVX")
    public int type() {
        return VkObjectTableDescriptorSetEntryNVX.ntype(this.address());
    }

    @NativeType(value="VkObjectEntryUsageFlagsNVX")
    public int flags() {
        return VkObjectTableDescriptorSetEntryNVX.nflags(this.address());
    }

    @NativeType(value="VkPipelineLayout")
    public long pipelineLayout() {
        return VkObjectTableDescriptorSetEntryNVX.npipelineLayout(this.address());
    }

    @NativeType(value="VkDescriptorSet")
    public long descriptorSet() {
        return VkObjectTableDescriptorSetEntryNVX.ndescriptorSet(this.address());
    }

    public VkObjectTableDescriptorSetEntryNVX type(@NativeType(value="VkObjectEntryTypeNVX") int value) {
        VkObjectTableDescriptorSetEntryNVX.ntype(this.address(), value);
        return this;
    }

    public VkObjectTableDescriptorSetEntryNVX flags(@NativeType(value="VkObjectEntryUsageFlagsNVX") int value) {
        VkObjectTableDescriptorSetEntryNVX.nflags(this.address(), value);
        return this;
    }

    public VkObjectTableDescriptorSetEntryNVX pipelineLayout(@NativeType(value="VkPipelineLayout") long value) {
        VkObjectTableDescriptorSetEntryNVX.npipelineLayout(this.address(), value);
        return this;
    }

    public VkObjectTableDescriptorSetEntryNVX descriptorSet(@NativeType(value="VkDescriptorSet") long value) {
        VkObjectTableDescriptorSetEntryNVX.ndescriptorSet(this.address(), value);
        return this;
    }

    public VkObjectTableDescriptorSetEntryNVX set(int type, int flags, long pipelineLayout, long descriptorSet) {
        this.type(type);
        this.flags(flags);
        this.pipelineLayout(pipelineLayout);
        this.descriptorSet(descriptorSet);
        return this;
    }

    public VkObjectTableDescriptorSetEntryNVX set(VkObjectTableDescriptorSetEntryNVX src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkObjectTableDescriptorSetEntryNVX malloc() {
        return VkObjectTableDescriptorSetEntryNVX.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkObjectTableDescriptorSetEntryNVX calloc() {
        return VkObjectTableDescriptorSetEntryNVX.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkObjectTableDescriptorSetEntryNVX create() {
        return new VkObjectTableDescriptorSetEntryNVX(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkObjectTableDescriptorSetEntryNVX create(long address) {
        return new VkObjectTableDescriptorSetEntryNVX(address, null);
    }

    @Nullable
    public static VkObjectTableDescriptorSetEntryNVX createSafe(long address) {
        return address == 0L ? null : VkObjectTableDescriptorSetEntryNVX.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkObjectTableDescriptorSetEntryNVX.create(VkObjectTableDescriptorSetEntryNVX.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkObjectTableDescriptorSetEntryNVX.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkObjectTableDescriptorSetEntryNVX.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkObjectTableDescriptorSetEntryNVX.create(address, capacity);
    }

    public static VkObjectTableDescriptorSetEntryNVX mallocStack() {
        return VkObjectTableDescriptorSetEntryNVX.mallocStack(MemoryStack.stackGet());
    }

    public static VkObjectTableDescriptorSetEntryNVX callocStack() {
        return VkObjectTableDescriptorSetEntryNVX.callocStack(MemoryStack.stackGet());
    }

    public static VkObjectTableDescriptorSetEntryNVX mallocStack(MemoryStack stack) {
        return VkObjectTableDescriptorSetEntryNVX.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkObjectTableDescriptorSetEntryNVX callocStack(MemoryStack stack) {
        return VkObjectTableDescriptorSetEntryNVX.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkObjectTableDescriptorSetEntryNVX.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkObjectTableDescriptorSetEntryNVX.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkObjectTableDescriptorSetEntryNVX.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkObjectTableDescriptorSetEntryNVX.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static int nflags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FLAGS);
    }

    public static long npipelineLayout(long struct) {
        return MemoryUtil.memGetLong(struct + (long)PIPELINELAYOUT);
    }

    public static long ndescriptorSet(long struct) {
        return MemoryUtil.memGetLong(struct + (long)DESCRIPTORSET);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nflags(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FLAGS, value);
    }

    public static void npipelineLayout(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)PIPELINELAYOUT, value);
    }

    public static void ndescriptorSet(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)DESCRIPTORSET, value);
    }

    static {
        Struct.Layout layout = VkObjectTableDescriptorSetEntryNVX.__struct(VkObjectTableDescriptorSetEntryNVX.__member(4), VkObjectTableDescriptorSetEntryNVX.__member(4), VkObjectTableDescriptorSetEntryNVX.__member(8), VkObjectTableDescriptorSetEntryNVX.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        FLAGS = layout.offsetof(1);
        PIPELINELAYOUT = layout.offsetof(2);
        DESCRIPTORSET = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkObjectTableDescriptorSetEntryNVX, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkObjectTableDescriptorSetEntryNVX newInstance(long address) {
            return new VkObjectTableDescriptorSetEntryNVX(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="VkObjectEntryTypeNVX")
        public int type() {
            return VkObjectTableDescriptorSetEntryNVX.ntype(this.address());
        }

        @NativeType(value="VkObjectEntryUsageFlagsNVX")
        public int flags() {
            return VkObjectTableDescriptorSetEntryNVX.nflags(this.address());
        }

        @NativeType(value="VkPipelineLayout")
        public long pipelineLayout() {
            return VkObjectTableDescriptorSetEntryNVX.npipelineLayout(this.address());
        }

        @NativeType(value="VkDescriptorSet")
        public long descriptorSet() {
            return VkObjectTableDescriptorSetEntryNVX.ndescriptorSet(this.address());
        }

        public Buffer type(@NativeType(value="VkObjectEntryTypeNVX") int value) {
            VkObjectTableDescriptorSetEntryNVX.ntype(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="VkObjectEntryUsageFlagsNVX") int value) {
            VkObjectTableDescriptorSetEntryNVX.nflags(this.address(), value);
            return this;
        }

        public Buffer pipelineLayout(@NativeType(value="VkPipelineLayout") long value) {
            VkObjectTableDescriptorSetEntryNVX.npipelineLayout(this.address(), value);
            return this;
        }

        public Buffer descriptorSet(@NativeType(value="VkDescriptorSet") long value) {
            VkObjectTableDescriptorSetEntryNVX.ndescriptorSet(this.address(), value);
            return this;
        }
    }
}

