/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkMemoryRequirements
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int SIZE;
    public static final int ALIGNMENT;
    public static final int MEMORYTYPEBITS;

    VkMemoryRequirements(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkMemoryRequirements(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkMemoryRequirements.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkDeviceSize")
    public long size() {
        return VkMemoryRequirements.nsize(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long alignment() {
        return VkMemoryRequirements.nalignment(this.address());
    }

    @NativeType(value="uint32_t")
    public int memoryTypeBits() {
        return VkMemoryRequirements.nmemoryTypeBits(this.address());
    }

    public static VkMemoryRequirements malloc() {
        return VkMemoryRequirements.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkMemoryRequirements calloc() {
        return VkMemoryRequirements.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkMemoryRequirements create() {
        return new VkMemoryRequirements(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkMemoryRequirements create(long address) {
        return new VkMemoryRequirements(address, null);
    }

    @Nullable
    public static VkMemoryRequirements createSafe(long address) {
        return address == 0L ? null : VkMemoryRequirements.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkMemoryRequirements.create(VkMemoryRequirements.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkMemoryRequirements.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkMemoryRequirements.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkMemoryRequirements.create(address, capacity);
    }

    public static VkMemoryRequirements mallocStack() {
        return VkMemoryRequirements.mallocStack(MemoryStack.stackGet());
    }

    public static VkMemoryRequirements callocStack() {
        return VkMemoryRequirements.callocStack(MemoryStack.stackGet());
    }

    public static VkMemoryRequirements mallocStack(MemoryStack stack) {
        return VkMemoryRequirements.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkMemoryRequirements callocStack(MemoryStack stack) {
        return VkMemoryRequirements.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkMemoryRequirements.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkMemoryRequirements.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkMemoryRequirements.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkMemoryRequirements.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nsize(long struct) {
        return MemoryUtil.memGetLong(struct + (long)SIZE);
    }

    public static long nalignment(long struct) {
        return MemoryUtil.memGetLong(struct + (long)ALIGNMENT);
    }

    public static int nmemoryTypeBits(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MEMORYTYPEBITS);
    }

    static {
        Struct.Layout layout = VkMemoryRequirements.__struct(VkMemoryRequirements.__member(8), VkMemoryRequirements.__member(8), VkMemoryRequirements.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        SIZE = layout.offsetof(0);
        ALIGNMENT = layout.offsetof(1);
        MEMORYTYPEBITS = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkMemoryRequirements, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkMemoryRequirements newInstance(long address) {
            return new VkMemoryRequirements(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="VkDeviceSize")
        public long size() {
            return VkMemoryRequirements.nsize(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long alignment() {
            return VkMemoryRequirements.nalignment(this.address());
        }

        @NativeType(value="uint32_t")
        public int memoryTypeBits() {
            return VkMemoryRequirements.nmemoryTypeBits(this.address());
        }
    }
}

