/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkMemoryHostPointerPropertiesEXT
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int MEMORYTYPEBITS;

    VkMemoryHostPointerPropertiesEXT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkMemoryHostPointerPropertiesEXT(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkMemoryHostPointerPropertiesEXT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkMemoryHostPointerPropertiesEXT.nsType(this.address());
    }

    @NativeType(value="void *")
    public long pNext() {
        return VkMemoryHostPointerPropertiesEXT.npNext(this.address());
    }

    @NativeType(value="uint32_t")
    public int memoryTypeBits() {
        return VkMemoryHostPointerPropertiesEXT.nmemoryTypeBits(this.address());
    }

    public VkMemoryHostPointerPropertiesEXT sType(@NativeType(value="VkStructureType") int value) {
        VkMemoryHostPointerPropertiesEXT.nsType(this.address(), value);
        return this;
    }

    public VkMemoryHostPointerPropertiesEXT pNext(@NativeType(value="void *") long value) {
        VkMemoryHostPointerPropertiesEXT.npNext(this.address(), value);
        return this;
    }

    public VkMemoryHostPointerPropertiesEXT memoryTypeBits(@NativeType(value="uint32_t") int value) {
        VkMemoryHostPointerPropertiesEXT.nmemoryTypeBits(this.address(), value);
        return this;
    }

    public VkMemoryHostPointerPropertiesEXT set(int sType, long pNext, int memoryTypeBits) {
        this.sType(sType);
        this.pNext(pNext);
        this.memoryTypeBits(memoryTypeBits);
        return this;
    }

    public VkMemoryHostPointerPropertiesEXT set(VkMemoryHostPointerPropertiesEXT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkMemoryHostPointerPropertiesEXT malloc() {
        return VkMemoryHostPointerPropertiesEXT.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkMemoryHostPointerPropertiesEXT calloc() {
        return VkMemoryHostPointerPropertiesEXT.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkMemoryHostPointerPropertiesEXT create() {
        return new VkMemoryHostPointerPropertiesEXT(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkMemoryHostPointerPropertiesEXT create(long address) {
        return new VkMemoryHostPointerPropertiesEXT(address, null);
    }

    @Nullable
    public static VkMemoryHostPointerPropertiesEXT createSafe(long address) {
        return address == 0L ? null : VkMemoryHostPointerPropertiesEXT.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkMemoryHostPointerPropertiesEXT.create(VkMemoryHostPointerPropertiesEXT.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkMemoryHostPointerPropertiesEXT.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkMemoryHostPointerPropertiesEXT.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkMemoryHostPointerPropertiesEXT.create(address, capacity);
    }

    public static VkMemoryHostPointerPropertiesEXT mallocStack() {
        return VkMemoryHostPointerPropertiesEXT.mallocStack(MemoryStack.stackGet());
    }

    public static VkMemoryHostPointerPropertiesEXT callocStack() {
        return VkMemoryHostPointerPropertiesEXT.callocStack(MemoryStack.stackGet());
    }

    public static VkMemoryHostPointerPropertiesEXT mallocStack(MemoryStack stack) {
        return VkMemoryHostPointerPropertiesEXT.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkMemoryHostPointerPropertiesEXT callocStack(MemoryStack stack) {
        return VkMemoryHostPointerPropertiesEXT.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkMemoryHostPointerPropertiesEXT.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkMemoryHostPointerPropertiesEXT.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkMemoryHostPointerPropertiesEXT.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkMemoryHostPointerPropertiesEXT.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nmemoryTypeBits(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MEMORYTYPEBITS);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nmemoryTypeBits(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)MEMORYTYPEBITS, value);
    }

    static {
        Struct.Layout layout = VkMemoryHostPointerPropertiesEXT.__struct(VkMemoryHostPointerPropertiesEXT.__member(4), VkMemoryHostPointerPropertiesEXT.__member(POINTER_SIZE), VkMemoryHostPointerPropertiesEXT.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        MEMORYTYPEBITS = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkMemoryHostPointerPropertiesEXT, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkMemoryHostPointerPropertiesEXT newInstance(long address) {
            return new VkMemoryHostPointerPropertiesEXT(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkMemoryHostPointerPropertiesEXT.nsType(this.address());
        }

        @NativeType(value="void *")
        public long pNext() {
            return VkMemoryHostPointerPropertiesEXT.npNext(this.address());
        }

        @NativeType(value="uint32_t")
        public int memoryTypeBits() {
            return VkMemoryHostPointerPropertiesEXT.nmemoryTypeBits(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkMemoryHostPointerPropertiesEXT.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void *") long value) {
            VkMemoryHostPointerPropertiesEXT.npNext(this.address(), value);
            return this;
        }

        public Buffer memoryTypeBits(@NativeType(value="uint32_t") int value) {
            VkMemoryHostPointerPropertiesEXT.nmemoryTypeBits(this.address(), value);
            return this;
        }
    }
}

