/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkLayerProperties
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int LAYERNAME;
    public static final int SPECVERSION;
    public static final int IMPLEMENTATIONVERSION;
    public static final int DESCRIPTION;

    VkLayerProperties(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkLayerProperties(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkLayerProperties.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="char[VK_MAX_EXTENSION_NAME_SIZE]")
    public ByteBuffer layerName() {
        return VkLayerProperties.nlayerName(this.address());
    }

    @NativeType(value="char[VK_MAX_EXTENSION_NAME_SIZE]")
    public String layerNameString() {
        return VkLayerProperties.nlayerNameString(this.address());
    }

    @NativeType(value="uint32_t")
    public int specVersion() {
        return VkLayerProperties.nspecVersion(this.address());
    }

    @NativeType(value="uint32_t")
    public int implementationVersion() {
        return VkLayerProperties.nimplementationVersion(this.address());
    }

    @NativeType(value="char[VK_MAX_DESCRIPTION_SIZE]")
    public ByteBuffer description() {
        return VkLayerProperties.ndescription(this.address());
    }

    @NativeType(value="char[VK_MAX_DESCRIPTION_SIZE]")
    public String descriptionString() {
        return VkLayerProperties.ndescriptionString(this.address());
    }

    public static VkLayerProperties malloc() {
        return VkLayerProperties.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkLayerProperties calloc() {
        return VkLayerProperties.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkLayerProperties create() {
        return new VkLayerProperties(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkLayerProperties create(long address) {
        return new VkLayerProperties(address, null);
    }

    @Nullable
    public static VkLayerProperties createSafe(long address) {
        return address == 0L ? null : VkLayerProperties.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkLayerProperties.create(VkLayerProperties.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkLayerProperties.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkLayerProperties.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkLayerProperties.create(address, capacity);
    }

    public static VkLayerProperties mallocStack() {
        return VkLayerProperties.mallocStack(MemoryStack.stackGet());
    }

    public static VkLayerProperties callocStack() {
        return VkLayerProperties.callocStack(MemoryStack.stackGet());
    }

    public static VkLayerProperties mallocStack(MemoryStack stack) {
        return VkLayerProperties.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkLayerProperties callocStack(MemoryStack stack) {
        return VkLayerProperties.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkLayerProperties.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkLayerProperties.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkLayerProperties.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkLayerProperties.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static ByteBuffer nlayerName(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)LAYERNAME, 256);
    }

    public static String nlayerNameString(long struct) {
        return MemoryUtil.memUTF8(struct + (long)LAYERNAME);
    }

    public static int nspecVersion(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SPECVERSION);
    }

    public static int nimplementationVersion(long struct) {
        return MemoryUtil.memGetInt(struct + (long)IMPLEMENTATIONVERSION);
    }

    public static ByteBuffer ndescription(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)DESCRIPTION, 256);
    }

    public static String ndescriptionString(long struct) {
        return MemoryUtil.memUTF8(struct + (long)DESCRIPTION);
    }

    static {
        Struct.Layout layout = VkLayerProperties.__struct(VkLayerProperties.__array(1, 256), VkLayerProperties.__member(4), VkLayerProperties.__member(4), VkLayerProperties.__array(1, 256));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        LAYERNAME = layout.offsetof(0);
        SPECVERSION = layout.offsetof(1);
        IMPLEMENTATIONVERSION = layout.offsetof(2);
        DESCRIPTION = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkLayerProperties, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkLayerProperties newInstance(long address) {
            return new VkLayerProperties(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="char[VK_MAX_EXTENSION_NAME_SIZE]")
        public ByteBuffer layerName() {
            return VkLayerProperties.nlayerName(this.address());
        }

        @NativeType(value="char[VK_MAX_EXTENSION_NAME_SIZE]")
        public String layerNameString() {
            return VkLayerProperties.nlayerNameString(this.address());
        }

        @NativeType(value="uint32_t")
        public int specVersion() {
            return VkLayerProperties.nspecVersion(this.address());
        }

        @NativeType(value="uint32_t")
        public int implementationVersion() {
            return VkLayerProperties.nimplementationVersion(this.address());
        }

        @NativeType(value="char[VK_MAX_DESCRIPTION_SIZE]")
        public ByteBuffer description() {
            return VkLayerProperties.ndescription(this.address());
        }

        @NativeType(value="char[VK_MAX_DESCRIPTION_SIZE]")
        public String descriptionString() {
            return VkLayerProperties.ndescriptionString(this.address());
        }
    }
}

