/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VkInputAttachmentAspectReference;

public class VkInputAttachmentAspectReferenceKHR
extends VkInputAttachmentAspectReference {
    VkInputAttachmentAspectReferenceKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkInputAttachmentAspectReferenceKHR(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkInputAttachmentAspectReferenceKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public VkInputAttachmentAspectReferenceKHR subpass(@NativeType(value="uint32_t") int value) {
        VkInputAttachmentAspectReferenceKHR.nsubpass(this.address(), value);
        return this;
    }

    @Override
    public VkInputAttachmentAspectReferenceKHR inputAttachmentIndex(@NativeType(value="uint32_t") int value) {
        VkInputAttachmentAspectReferenceKHR.ninputAttachmentIndex(this.address(), value);
        return this;
    }

    @Override
    public VkInputAttachmentAspectReferenceKHR aspectMask(@NativeType(value="VkImageAspectFlags") int value) {
        VkInputAttachmentAspectReferenceKHR.naspectMask(this.address(), value);
        return this;
    }

    @Override
    public VkInputAttachmentAspectReferenceKHR set(int subpass, int inputAttachmentIndex, int aspectMask) {
        this.subpass(subpass);
        this.inputAttachmentIndex(inputAttachmentIndex);
        this.aspectMask(aspectMask);
        return this;
    }

    public VkInputAttachmentAspectReferenceKHR set(VkInputAttachmentAspectReferenceKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkInputAttachmentAspectReferenceKHR malloc() {
        return VkInputAttachmentAspectReferenceKHR.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkInputAttachmentAspectReferenceKHR calloc() {
        return VkInputAttachmentAspectReferenceKHR.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkInputAttachmentAspectReferenceKHR create() {
        return new VkInputAttachmentAspectReferenceKHR(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkInputAttachmentAspectReferenceKHR create(long address) {
        return new VkInputAttachmentAspectReferenceKHR(address, null);
    }

    @Nullable
    public static VkInputAttachmentAspectReferenceKHR createSafe(long address) {
        return address == 0L ? null : VkInputAttachmentAspectReferenceKHR.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkInputAttachmentAspectReferenceKHR.create(VkInputAttachmentAspectReferenceKHR.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkInputAttachmentAspectReferenceKHR.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkInputAttachmentAspectReferenceKHR.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkInputAttachmentAspectReferenceKHR.create(address, capacity);
    }

    public static VkInputAttachmentAspectReferenceKHR mallocStack() {
        return VkInputAttachmentAspectReferenceKHR.mallocStack(MemoryStack.stackGet());
    }

    public static VkInputAttachmentAspectReferenceKHR callocStack() {
        return VkInputAttachmentAspectReferenceKHR.callocStack(MemoryStack.stackGet());
    }

    public static VkInputAttachmentAspectReferenceKHR mallocStack(MemoryStack stack) {
        return VkInputAttachmentAspectReferenceKHR.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkInputAttachmentAspectReferenceKHR callocStack(MemoryStack stack) {
        return VkInputAttachmentAspectReferenceKHR.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkInputAttachmentAspectReferenceKHR.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkInputAttachmentAspectReferenceKHR.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkInputAttachmentAspectReferenceKHR.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkInputAttachmentAspectReferenceKHR.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static class Buffer
    extends VkInputAttachmentAspectReference.Buffer {
        public Buffer(ByteBuffer container) {
            super(container);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkInputAttachmentAspectReferenceKHR newInstance(long address) {
            return new VkInputAttachmentAspectReferenceKHR(address, this.container);
        }

        @Override
        public Buffer subpass(@NativeType(value="uint32_t") int value) {
            VkInputAttachmentAspectReferenceKHR.nsubpass(this.address(), value);
            return this;
        }

        @Override
        public Buffer inputAttachmentIndex(@NativeType(value="uint32_t") int value) {
            VkInputAttachmentAspectReferenceKHR.ninputAttachmentIndex(this.address(), value);
            return this;
        }

        @Override
        public Buffer aspectMask(@NativeType(value="VkImageAspectFlags") int value) {
            VkInputAttachmentAspectReferenceKHR.naspectMask(this.address(), value);
            return this;
        }
    }
}

