/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VkImagePlaneMemoryRequirementsInfo;

public class VkImagePlaneMemoryRequirementsInfoKHR
extends VkImagePlaneMemoryRequirementsInfo {
    VkImagePlaneMemoryRequirementsInfoKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkImagePlaneMemoryRequirementsInfoKHR(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkImagePlaneMemoryRequirementsInfoKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public VkImagePlaneMemoryRequirementsInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkImagePlaneMemoryRequirementsInfoKHR.nsType(this.address(), value);
        return this;
    }

    @Override
    public VkImagePlaneMemoryRequirementsInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkImagePlaneMemoryRequirementsInfoKHR.npNext(this.address(), value);
        return this;
    }

    @Override
    public VkImagePlaneMemoryRequirementsInfoKHR planeAspect(@NativeType(value="VkImageAspectFlagBits") int value) {
        VkImagePlaneMemoryRequirementsInfoKHR.nplaneAspect(this.address(), value);
        return this;
    }

    @Override
    public VkImagePlaneMemoryRequirementsInfoKHR set(int sType, long pNext, int planeAspect) {
        this.sType(sType);
        this.pNext(pNext);
        this.planeAspect(planeAspect);
        return this;
    }

    public VkImagePlaneMemoryRequirementsInfoKHR set(VkImagePlaneMemoryRequirementsInfoKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkImagePlaneMemoryRequirementsInfoKHR malloc() {
        return VkImagePlaneMemoryRequirementsInfoKHR.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkImagePlaneMemoryRequirementsInfoKHR calloc() {
        return VkImagePlaneMemoryRequirementsInfoKHR.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkImagePlaneMemoryRequirementsInfoKHR create() {
        return new VkImagePlaneMemoryRequirementsInfoKHR(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkImagePlaneMemoryRequirementsInfoKHR create(long address) {
        return new VkImagePlaneMemoryRequirementsInfoKHR(address, null);
    }

    @Nullable
    public static VkImagePlaneMemoryRequirementsInfoKHR createSafe(long address) {
        return address == 0L ? null : VkImagePlaneMemoryRequirementsInfoKHR.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkImagePlaneMemoryRequirementsInfoKHR.create(VkImagePlaneMemoryRequirementsInfoKHR.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkImagePlaneMemoryRequirementsInfoKHR.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkImagePlaneMemoryRequirementsInfoKHR.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkImagePlaneMemoryRequirementsInfoKHR.create(address, capacity);
    }

    public static VkImagePlaneMemoryRequirementsInfoKHR mallocStack() {
        return VkImagePlaneMemoryRequirementsInfoKHR.mallocStack(MemoryStack.stackGet());
    }

    public static VkImagePlaneMemoryRequirementsInfoKHR callocStack() {
        return VkImagePlaneMemoryRequirementsInfoKHR.callocStack(MemoryStack.stackGet());
    }

    public static VkImagePlaneMemoryRequirementsInfoKHR mallocStack(MemoryStack stack) {
        return VkImagePlaneMemoryRequirementsInfoKHR.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkImagePlaneMemoryRequirementsInfoKHR callocStack(MemoryStack stack) {
        return VkImagePlaneMemoryRequirementsInfoKHR.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkImagePlaneMemoryRequirementsInfoKHR.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkImagePlaneMemoryRequirementsInfoKHR.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkImagePlaneMemoryRequirementsInfoKHR.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkImagePlaneMemoryRequirementsInfoKHR.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static class Buffer
    extends VkImagePlaneMemoryRequirementsInfo.Buffer {
        public Buffer(ByteBuffer container) {
            super(container);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkImagePlaneMemoryRequirementsInfoKHR newInstance(long address) {
            return new VkImagePlaneMemoryRequirementsInfoKHR(address, this.container);
        }

        @Override
        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkImagePlaneMemoryRequirementsInfoKHR.nsType(this.address(), value);
            return this;
        }

        @Override
        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkImagePlaneMemoryRequirementsInfoKHR.npNext(this.address(), value);
            return this;
        }

        @Override
        public Buffer planeAspect(@NativeType(value="VkImageAspectFlagBits") int value) {
            VkImagePlaneMemoryRequirementsInfoKHR.nplaneAspect(this.address(), value);
            return this;
        }
    }
}

