/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkImagePlaneMemoryRequirementsInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int PLANEASPECT;

    VkImagePlaneMemoryRequirementsInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkImagePlaneMemoryRequirementsInfo(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkImagePlaneMemoryRequirementsInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkImagePlaneMemoryRequirementsInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkImagePlaneMemoryRequirementsInfo.npNext(this.address());
    }

    @NativeType(value="VkImageAspectFlagBits")
    public int planeAspect() {
        return VkImagePlaneMemoryRequirementsInfo.nplaneAspect(this.address());
    }

    public VkImagePlaneMemoryRequirementsInfo sType(@NativeType(value="VkStructureType") int value) {
        VkImagePlaneMemoryRequirementsInfo.nsType(this.address(), value);
        return this;
    }

    public VkImagePlaneMemoryRequirementsInfo pNext(@NativeType(value="void const *") long value) {
        VkImagePlaneMemoryRequirementsInfo.npNext(this.address(), value);
        return this;
    }

    public VkImagePlaneMemoryRequirementsInfo planeAspect(@NativeType(value="VkImageAspectFlagBits") int value) {
        VkImagePlaneMemoryRequirementsInfo.nplaneAspect(this.address(), value);
        return this;
    }

    public VkImagePlaneMemoryRequirementsInfo set(int sType, long pNext, int planeAspect) {
        this.sType(sType);
        this.pNext(pNext);
        this.planeAspect(planeAspect);
        return this;
    }

    public VkImagePlaneMemoryRequirementsInfo set(VkImagePlaneMemoryRequirementsInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkImagePlaneMemoryRequirementsInfo malloc() {
        return VkImagePlaneMemoryRequirementsInfo.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkImagePlaneMemoryRequirementsInfo calloc() {
        return VkImagePlaneMemoryRequirementsInfo.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkImagePlaneMemoryRequirementsInfo create() {
        return new VkImagePlaneMemoryRequirementsInfo(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkImagePlaneMemoryRequirementsInfo create(long address) {
        return new VkImagePlaneMemoryRequirementsInfo(address, null);
    }

    @Nullable
    public static VkImagePlaneMemoryRequirementsInfo createSafe(long address) {
        return address == 0L ? null : VkImagePlaneMemoryRequirementsInfo.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkImagePlaneMemoryRequirementsInfo.create(VkImagePlaneMemoryRequirementsInfo.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkImagePlaneMemoryRequirementsInfo.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkImagePlaneMemoryRequirementsInfo.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkImagePlaneMemoryRequirementsInfo.create(address, capacity);
    }

    public static VkImagePlaneMemoryRequirementsInfo mallocStack() {
        return VkImagePlaneMemoryRequirementsInfo.mallocStack(MemoryStack.stackGet());
    }

    public static VkImagePlaneMemoryRequirementsInfo callocStack() {
        return VkImagePlaneMemoryRequirementsInfo.callocStack(MemoryStack.stackGet());
    }

    public static VkImagePlaneMemoryRequirementsInfo mallocStack(MemoryStack stack) {
        return VkImagePlaneMemoryRequirementsInfo.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkImagePlaneMemoryRequirementsInfo callocStack(MemoryStack stack) {
        return VkImagePlaneMemoryRequirementsInfo.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkImagePlaneMemoryRequirementsInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkImagePlaneMemoryRequirementsInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkImagePlaneMemoryRequirementsInfo.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkImagePlaneMemoryRequirementsInfo.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nplaneAspect(long struct) {
        return MemoryUtil.memGetInt(struct + (long)PLANEASPECT);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nplaneAspect(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)PLANEASPECT, value);
    }

    static {
        Struct.Layout layout = VkImagePlaneMemoryRequirementsInfo.__struct(VkImagePlaneMemoryRequirementsInfo.__member(4), VkImagePlaneMemoryRequirementsInfo.__member(POINTER_SIZE), VkImagePlaneMemoryRequirementsInfo.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        PLANEASPECT = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkImagePlaneMemoryRequirementsInfo, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkImagePlaneMemoryRequirementsInfo newInstance(long address) {
            return new VkImagePlaneMemoryRequirementsInfo(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkImagePlaneMemoryRequirementsInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkImagePlaneMemoryRequirementsInfo.npNext(this.address());
        }

        @NativeType(value="VkImageAspectFlagBits")
        public int planeAspect() {
            return VkImagePlaneMemoryRequirementsInfo.nplaneAspect(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkImagePlaneMemoryRequirementsInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkImagePlaneMemoryRequirementsInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer planeAspect(@NativeType(value="VkImageAspectFlagBits") int value) {
            VkImagePlaneMemoryRequirementsInfo.nplaneAspect(this.address(), value);
            return this;
        }
    }
}

