/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VkImageMemoryRequirementsInfo2;

public class VkImageMemoryRequirementsInfo2KHR
extends VkImageMemoryRequirementsInfo2 {
    VkImageMemoryRequirementsInfo2KHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkImageMemoryRequirementsInfo2KHR(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkImageMemoryRequirementsInfo2KHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public VkImageMemoryRequirementsInfo2KHR sType(@NativeType(value="VkStructureType") int value) {
        VkImageMemoryRequirementsInfo2KHR.nsType(this.address(), value);
        return this;
    }

    @Override
    public VkImageMemoryRequirementsInfo2KHR pNext(@NativeType(value="void const *") long value) {
        VkImageMemoryRequirementsInfo2KHR.npNext(this.address(), value);
        return this;
    }

    @Override
    public VkImageMemoryRequirementsInfo2KHR image(@NativeType(value="VkImage") long value) {
        VkImageMemoryRequirementsInfo2KHR.nimage(this.address(), value);
        return this;
    }

    @Override
    public VkImageMemoryRequirementsInfo2KHR set(int sType, long pNext, long image) {
        this.sType(sType);
        this.pNext(pNext);
        this.image(image);
        return this;
    }

    public VkImageMemoryRequirementsInfo2KHR set(VkImageMemoryRequirementsInfo2KHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkImageMemoryRequirementsInfo2KHR malloc() {
        return VkImageMemoryRequirementsInfo2KHR.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkImageMemoryRequirementsInfo2KHR calloc() {
        return VkImageMemoryRequirementsInfo2KHR.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkImageMemoryRequirementsInfo2KHR create() {
        return new VkImageMemoryRequirementsInfo2KHR(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkImageMemoryRequirementsInfo2KHR create(long address) {
        return new VkImageMemoryRequirementsInfo2KHR(address, null);
    }

    @Nullable
    public static VkImageMemoryRequirementsInfo2KHR createSafe(long address) {
        return address == 0L ? null : VkImageMemoryRequirementsInfo2KHR.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkImageMemoryRequirementsInfo2KHR.create(VkImageMemoryRequirementsInfo2KHR.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkImageMemoryRequirementsInfo2KHR.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkImageMemoryRequirementsInfo2KHR.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkImageMemoryRequirementsInfo2KHR.create(address, capacity);
    }

    public static VkImageMemoryRequirementsInfo2KHR mallocStack() {
        return VkImageMemoryRequirementsInfo2KHR.mallocStack(MemoryStack.stackGet());
    }

    public static VkImageMemoryRequirementsInfo2KHR callocStack() {
        return VkImageMemoryRequirementsInfo2KHR.callocStack(MemoryStack.stackGet());
    }

    public static VkImageMemoryRequirementsInfo2KHR mallocStack(MemoryStack stack) {
        return VkImageMemoryRequirementsInfo2KHR.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkImageMemoryRequirementsInfo2KHR callocStack(MemoryStack stack) {
        return VkImageMemoryRequirementsInfo2KHR.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkImageMemoryRequirementsInfo2KHR.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkImageMemoryRequirementsInfo2KHR.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkImageMemoryRequirementsInfo2KHR.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkImageMemoryRequirementsInfo2KHR.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static class Buffer
    extends VkImageMemoryRequirementsInfo2.Buffer {
        public Buffer(ByteBuffer container) {
            super(container);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkImageMemoryRequirementsInfo2KHR newInstance(long address) {
            return new VkImageMemoryRequirementsInfo2KHR(address, this.container);
        }

        @Override
        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkImageMemoryRequirementsInfo2KHR.nsType(this.address(), value);
            return this;
        }

        @Override
        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkImageMemoryRequirementsInfo2KHR.npNext(this.address(), value);
            return this;
        }

        @Override
        public Buffer image(@NativeType(value="VkImage") long value) {
            VkImageMemoryRequirementsInfo2KHR.nimage(this.address(), value);
            return this;
        }
    }
}

