/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkExtent3D;

public class VkImageFormatProperties
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MAXEXTENT;
    public static final int MAXMIPLEVELS;
    public static final int MAXARRAYLAYERS;
    public static final int SAMPLECOUNTS;
    public static final int MAXRESOURCESIZE;

    VkImageFormatProperties(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkImageFormatProperties(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkImageFormatProperties.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public VkExtent3D maxExtent() {
        return VkImageFormatProperties.nmaxExtent(this.address());
    }

    public VkImageFormatProperties maxExtent(Consumer<VkExtent3D> consumer) {
        consumer.accept(this.maxExtent());
        return this;
    }

    @NativeType(value="uint32_t")
    public int maxMipLevels() {
        return VkImageFormatProperties.nmaxMipLevels(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxArrayLayers() {
        return VkImageFormatProperties.nmaxArrayLayers(this.address());
    }

    @NativeType(value="VkSampleCountFlags")
    public int sampleCounts() {
        return VkImageFormatProperties.nsampleCounts(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long maxResourceSize() {
        return VkImageFormatProperties.nmaxResourceSize(this.address());
    }

    public static VkImageFormatProperties malloc() {
        return VkImageFormatProperties.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkImageFormatProperties calloc() {
        return VkImageFormatProperties.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkImageFormatProperties create() {
        return new VkImageFormatProperties(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkImageFormatProperties create(long address) {
        return new VkImageFormatProperties(address, null);
    }

    @Nullable
    public static VkImageFormatProperties createSafe(long address) {
        return address == 0L ? null : VkImageFormatProperties.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkImageFormatProperties.create(VkImageFormatProperties.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkImageFormatProperties.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkImageFormatProperties.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkImageFormatProperties.create(address, capacity);
    }

    public static VkImageFormatProperties mallocStack() {
        return VkImageFormatProperties.mallocStack(MemoryStack.stackGet());
    }

    public static VkImageFormatProperties callocStack() {
        return VkImageFormatProperties.callocStack(MemoryStack.stackGet());
    }

    public static VkImageFormatProperties mallocStack(MemoryStack stack) {
        return VkImageFormatProperties.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkImageFormatProperties callocStack(MemoryStack stack) {
        return VkImageFormatProperties.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkImageFormatProperties.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkImageFormatProperties.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkImageFormatProperties.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkImageFormatProperties.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static VkExtent3D nmaxExtent(long struct) {
        return VkExtent3D.create(struct + (long)MAXEXTENT);
    }

    public static int nmaxMipLevels(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MAXMIPLEVELS);
    }

    public static int nmaxArrayLayers(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MAXARRAYLAYERS);
    }

    public static int nsampleCounts(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SAMPLECOUNTS);
    }

    public static long nmaxResourceSize(long struct) {
        return MemoryUtil.memGetLong(struct + (long)MAXRESOURCESIZE);
    }

    static {
        Struct.Layout layout = VkImageFormatProperties.__struct(VkImageFormatProperties.__member(VkExtent3D.SIZEOF, VkExtent3D.ALIGNOF), VkImageFormatProperties.__member(4), VkImageFormatProperties.__member(4), VkImageFormatProperties.__member(4), VkImageFormatProperties.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MAXEXTENT = layout.offsetof(0);
        MAXMIPLEVELS = layout.offsetof(1);
        MAXARRAYLAYERS = layout.offsetof(2);
        SAMPLECOUNTS = layout.offsetof(3);
        MAXRESOURCESIZE = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<VkImageFormatProperties, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkImageFormatProperties newInstance(long address) {
            return new VkImageFormatProperties(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        public VkExtent3D maxExtent() {
            return VkImageFormatProperties.nmaxExtent(this.address());
        }

        public Buffer maxExtent(Consumer<VkExtent3D> consumer) {
            consumer.accept(this.maxExtent());
            return this;
        }

        @NativeType(value="uint32_t")
        public int maxMipLevels() {
            return VkImageFormatProperties.nmaxMipLevels(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxArrayLayers() {
            return VkImageFormatProperties.nmaxArrayLayers(this.address());
        }

        @NativeType(value="VkSampleCountFlags")
        public int sampleCounts() {
            return VkImageFormatProperties.nsampleCounts(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long maxResourceSize() {
            return VkImageFormatProperties.nmaxResourceSize(this.address());
        }
    }
}

