/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkImageFormatListCreateInfoKHR
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int VIEWFORMATCOUNT;
    public static final int PVIEWFORMATS;

    VkImageFormatListCreateInfoKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkImageFormatListCreateInfoKHR(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkImageFormatListCreateInfoKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkImageFormatListCreateInfoKHR.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkImageFormatListCreateInfoKHR.npNext(this.address());
    }

    @NativeType(value="uint32_t")
    public int viewFormatCount() {
        return VkImageFormatListCreateInfoKHR.nviewFormatCount(this.address());
    }

    @Nullable
    @NativeType(value="VkFormat const *")
    public IntBuffer pViewFormats() {
        return VkImageFormatListCreateInfoKHR.npViewFormats(this.address());
    }

    public VkImageFormatListCreateInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkImageFormatListCreateInfoKHR.nsType(this.address(), value);
        return this;
    }

    public VkImageFormatListCreateInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkImageFormatListCreateInfoKHR.npNext(this.address(), value);
        return this;
    }

    public VkImageFormatListCreateInfoKHR pViewFormats(@Nullable @NativeType(value="VkFormat const *") IntBuffer value) {
        VkImageFormatListCreateInfoKHR.npViewFormats(this.address(), value);
        return this;
    }

    public VkImageFormatListCreateInfoKHR set(int sType, long pNext, @Nullable IntBuffer pViewFormats) {
        this.sType(sType);
        this.pNext(pNext);
        this.pViewFormats(pViewFormats);
        return this;
    }

    public VkImageFormatListCreateInfoKHR set(VkImageFormatListCreateInfoKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkImageFormatListCreateInfoKHR malloc() {
        return VkImageFormatListCreateInfoKHR.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkImageFormatListCreateInfoKHR calloc() {
        return VkImageFormatListCreateInfoKHR.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkImageFormatListCreateInfoKHR create() {
        return new VkImageFormatListCreateInfoKHR(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkImageFormatListCreateInfoKHR create(long address) {
        return new VkImageFormatListCreateInfoKHR(address, null);
    }

    @Nullable
    public static VkImageFormatListCreateInfoKHR createSafe(long address) {
        return address == 0L ? null : VkImageFormatListCreateInfoKHR.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkImageFormatListCreateInfoKHR.create(VkImageFormatListCreateInfoKHR.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkImageFormatListCreateInfoKHR.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkImageFormatListCreateInfoKHR.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkImageFormatListCreateInfoKHR.create(address, capacity);
    }

    public static VkImageFormatListCreateInfoKHR mallocStack() {
        return VkImageFormatListCreateInfoKHR.mallocStack(MemoryStack.stackGet());
    }

    public static VkImageFormatListCreateInfoKHR callocStack() {
        return VkImageFormatListCreateInfoKHR.callocStack(MemoryStack.stackGet());
    }

    public static VkImageFormatListCreateInfoKHR mallocStack(MemoryStack stack) {
        return VkImageFormatListCreateInfoKHR.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkImageFormatListCreateInfoKHR callocStack(MemoryStack stack) {
        return VkImageFormatListCreateInfoKHR.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkImageFormatListCreateInfoKHR.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkImageFormatListCreateInfoKHR.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkImageFormatListCreateInfoKHR.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkImageFormatListCreateInfoKHR.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nviewFormatCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)VIEWFORMATCOUNT);
    }

    @Nullable
    public static IntBuffer npViewFormats(long struct) {
        return MemoryUtil.memIntBufferSafe(MemoryUtil.memGetAddress(struct + (long)PVIEWFORMATS), VkImageFormatListCreateInfoKHR.nviewFormatCount(struct));
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nviewFormatCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)VIEWFORMATCOUNT, value);
    }

    public static void npViewFormats(long struct, @Nullable IntBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PVIEWFORMATS, MemoryUtil.memAddressSafe(value));
        VkImageFormatListCreateInfoKHR.nviewFormatCount(struct, value == null ? 0 : value.remaining());
    }

    public static void validate(long struct) {
        if (VkImageFormatListCreateInfoKHR.nviewFormatCount(struct) != 0) {
            Checks.check(MemoryUtil.memGetAddress(struct + (long)PVIEWFORMATS));
        }
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            VkImageFormatListCreateInfoKHR.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = VkImageFormatListCreateInfoKHR.__struct(VkImageFormatListCreateInfoKHR.__member(4), VkImageFormatListCreateInfoKHR.__member(POINTER_SIZE), VkImageFormatListCreateInfoKHR.__member(4), VkImageFormatListCreateInfoKHR.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        VIEWFORMATCOUNT = layout.offsetof(2);
        PVIEWFORMATS = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkImageFormatListCreateInfoKHR, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkImageFormatListCreateInfoKHR newInstance(long address) {
            return new VkImageFormatListCreateInfoKHR(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkImageFormatListCreateInfoKHR.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkImageFormatListCreateInfoKHR.npNext(this.address());
        }

        @NativeType(value="uint32_t")
        public int viewFormatCount() {
            return VkImageFormatListCreateInfoKHR.nviewFormatCount(this.address());
        }

        @Nullable
        @NativeType(value="VkFormat const *")
        public IntBuffer pViewFormats() {
            return VkImageFormatListCreateInfoKHR.npViewFormats(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkImageFormatListCreateInfoKHR.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkImageFormatListCreateInfoKHR.npNext(this.address(), value);
            return this;
        }

        public Buffer pViewFormats(@Nullable @NativeType(value="VkFormat const *") IntBuffer value) {
            VkImageFormatListCreateInfoKHR.npViewFormats(this.address(), value);
            return this;
        }
    }
}

