/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkPipelineColorBlendStateCreateInfo;
import org.lwjgl.vulkan.VkPipelineDepthStencilStateCreateInfo;
import org.lwjgl.vulkan.VkPipelineDynamicStateCreateInfo;
import org.lwjgl.vulkan.VkPipelineInputAssemblyStateCreateInfo;
import org.lwjgl.vulkan.VkPipelineMultisampleStateCreateInfo;
import org.lwjgl.vulkan.VkPipelineRasterizationStateCreateInfo;
import org.lwjgl.vulkan.VkPipelineShaderStageCreateInfo;
import org.lwjgl.vulkan.VkPipelineTessellationStateCreateInfo;
import org.lwjgl.vulkan.VkPipelineVertexInputStateCreateInfo;
import org.lwjgl.vulkan.VkPipelineViewportStateCreateInfo;

public class VkGraphicsPipelineCreateInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int STAGECOUNT;
    public static final int PSTAGES;
    public static final int PVERTEXINPUTSTATE;
    public static final int PINPUTASSEMBLYSTATE;
    public static final int PTESSELLATIONSTATE;
    public static final int PVIEWPORTSTATE;
    public static final int PRASTERIZATIONSTATE;
    public static final int PMULTISAMPLESTATE;
    public static final int PDEPTHSTENCILSTATE;
    public static final int PCOLORBLENDSTATE;
    public static final int PDYNAMICSTATE;
    public static final int LAYOUT;
    public static final int RENDERPASS;
    public static final int SUBPASS;
    public static final int BASEPIPELINEHANDLE;
    public static final int BASEPIPELINEINDEX;

    VkGraphicsPipelineCreateInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkGraphicsPipelineCreateInfo(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkGraphicsPipelineCreateInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkGraphicsPipelineCreateInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkGraphicsPipelineCreateInfo.npNext(this.address());
    }

    @NativeType(value="VkPipelineCreateFlags")
    public int flags() {
        return VkGraphicsPipelineCreateInfo.nflags(this.address());
    }

    @NativeType(value="uint32_t")
    public int stageCount() {
        return VkGraphicsPipelineCreateInfo.nstageCount(this.address());
    }

    @NativeType(value="VkPipelineShaderStageCreateInfo const *")
    public VkPipelineShaderStageCreateInfo.Buffer pStages() {
        return VkGraphicsPipelineCreateInfo.npStages(this.address());
    }

    @NativeType(value="VkPipelineVertexInputStateCreateInfo const *")
    public VkPipelineVertexInputStateCreateInfo pVertexInputState() {
        return VkGraphicsPipelineCreateInfo.npVertexInputState(this.address());
    }

    @NativeType(value="VkPipelineInputAssemblyStateCreateInfo const *")
    public VkPipelineInputAssemblyStateCreateInfo pInputAssemblyState() {
        return VkGraphicsPipelineCreateInfo.npInputAssemblyState(this.address());
    }

    @Nullable
    @NativeType(value="VkPipelineTessellationStateCreateInfo const *")
    public VkPipelineTessellationStateCreateInfo pTessellationState() {
        return VkGraphicsPipelineCreateInfo.npTessellationState(this.address());
    }

    @Nullable
    @NativeType(value="VkPipelineViewportStateCreateInfo const *")
    public VkPipelineViewportStateCreateInfo pViewportState() {
        return VkGraphicsPipelineCreateInfo.npViewportState(this.address());
    }

    @NativeType(value="VkPipelineRasterizationStateCreateInfo const *")
    public VkPipelineRasterizationStateCreateInfo pRasterizationState() {
        return VkGraphicsPipelineCreateInfo.npRasterizationState(this.address());
    }

    @Nullable
    @NativeType(value="VkPipelineMultisampleStateCreateInfo const *")
    public VkPipelineMultisampleStateCreateInfo pMultisampleState() {
        return VkGraphicsPipelineCreateInfo.npMultisampleState(this.address());
    }

    @Nullable
    @NativeType(value="VkPipelineDepthStencilStateCreateInfo const *")
    public VkPipelineDepthStencilStateCreateInfo pDepthStencilState() {
        return VkGraphicsPipelineCreateInfo.npDepthStencilState(this.address());
    }

    @Nullable
    @NativeType(value="VkPipelineColorBlendStateCreateInfo const *")
    public VkPipelineColorBlendStateCreateInfo pColorBlendState() {
        return VkGraphicsPipelineCreateInfo.npColorBlendState(this.address());
    }

    @Nullable
    @NativeType(value="VkPipelineDynamicStateCreateInfo const *")
    public VkPipelineDynamicStateCreateInfo pDynamicState() {
        return VkGraphicsPipelineCreateInfo.npDynamicState(this.address());
    }

    @NativeType(value="VkPipelineLayout")
    public long layout() {
        return VkGraphicsPipelineCreateInfo.nlayout(this.address());
    }

    @NativeType(value="VkRenderPass")
    public long renderPass() {
        return VkGraphicsPipelineCreateInfo.nrenderPass(this.address());
    }

    @NativeType(value="uint32_t")
    public int subpass() {
        return VkGraphicsPipelineCreateInfo.nsubpass(this.address());
    }

    @NativeType(value="VkPipeline")
    public long basePipelineHandle() {
        return VkGraphicsPipelineCreateInfo.nbasePipelineHandle(this.address());
    }

    @NativeType(value="int32_t")
    public int basePipelineIndex() {
        return VkGraphicsPipelineCreateInfo.nbasePipelineIndex(this.address());
    }

    public VkGraphicsPipelineCreateInfo sType(@NativeType(value="VkStructureType") int value) {
        VkGraphicsPipelineCreateInfo.nsType(this.address(), value);
        return this;
    }

    public VkGraphicsPipelineCreateInfo pNext(@NativeType(value="void const *") long value) {
        VkGraphicsPipelineCreateInfo.npNext(this.address(), value);
        return this;
    }

    public VkGraphicsPipelineCreateInfo flags(@NativeType(value="VkPipelineCreateFlags") int value) {
        VkGraphicsPipelineCreateInfo.nflags(this.address(), value);
        return this;
    }

    public VkGraphicsPipelineCreateInfo pStages(@NativeType(value="VkPipelineShaderStageCreateInfo const *") VkPipelineShaderStageCreateInfo.Buffer value) {
        VkGraphicsPipelineCreateInfo.npStages(this.address(), value);
        return this;
    }

    public VkGraphicsPipelineCreateInfo pVertexInputState(@NativeType(value="VkPipelineVertexInputStateCreateInfo const *") VkPipelineVertexInputStateCreateInfo value) {
        VkGraphicsPipelineCreateInfo.npVertexInputState(this.address(), value);
        return this;
    }

    public VkGraphicsPipelineCreateInfo pInputAssemblyState(@NativeType(value="VkPipelineInputAssemblyStateCreateInfo const *") VkPipelineInputAssemblyStateCreateInfo value) {
        VkGraphicsPipelineCreateInfo.npInputAssemblyState(this.address(), value);
        return this;
    }

    public VkGraphicsPipelineCreateInfo pTessellationState(@Nullable @NativeType(value="VkPipelineTessellationStateCreateInfo const *") VkPipelineTessellationStateCreateInfo value) {
        VkGraphicsPipelineCreateInfo.npTessellationState(this.address(), value);
        return this;
    }

    public VkGraphicsPipelineCreateInfo pViewportState(@Nullable @NativeType(value="VkPipelineViewportStateCreateInfo const *") VkPipelineViewportStateCreateInfo value) {
        VkGraphicsPipelineCreateInfo.npViewportState(this.address(), value);
        return this;
    }

    public VkGraphicsPipelineCreateInfo pRasterizationState(@NativeType(value="VkPipelineRasterizationStateCreateInfo const *") VkPipelineRasterizationStateCreateInfo value) {
        VkGraphicsPipelineCreateInfo.npRasterizationState(this.address(), value);
        return this;
    }

    public VkGraphicsPipelineCreateInfo pMultisampleState(@Nullable @NativeType(value="VkPipelineMultisampleStateCreateInfo const *") VkPipelineMultisampleStateCreateInfo value) {
        VkGraphicsPipelineCreateInfo.npMultisampleState(this.address(), value);
        return this;
    }

    public VkGraphicsPipelineCreateInfo pDepthStencilState(@Nullable @NativeType(value="VkPipelineDepthStencilStateCreateInfo const *") VkPipelineDepthStencilStateCreateInfo value) {
        VkGraphicsPipelineCreateInfo.npDepthStencilState(this.address(), value);
        return this;
    }

    public VkGraphicsPipelineCreateInfo pColorBlendState(@Nullable @NativeType(value="VkPipelineColorBlendStateCreateInfo const *") VkPipelineColorBlendStateCreateInfo value) {
        VkGraphicsPipelineCreateInfo.npColorBlendState(this.address(), value);
        return this;
    }

    public VkGraphicsPipelineCreateInfo pDynamicState(@Nullable @NativeType(value="VkPipelineDynamicStateCreateInfo const *") VkPipelineDynamicStateCreateInfo value) {
        VkGraphicsPipelineCreateInfo.npDynamicState(this.address(), value);
        return this;
    }

    public VkGraphicsPipelineCreateInfo layout(@NativeType(value="VkPipelineLayout") long value) {
        VkGraphicsPipelineCreateInfo.nlayout(this.address(), value);
        return this;
    }

    public VkGraphicsPipelineCreateInfo renderPass(@NativeType(value="VkRenderPass") long value) {
        VkGraphicsPipelineCreateInfo.nrenderPass(this.address(), value);
        return this;
    }

    public VkGraphicsPipelineCreateInfo subpass(@NativeType(value="uint32_t") int value) {
        VkGraphicsPipelineCreateInfo.nsubpass(this.address(), value);
        return this;
    }

    public VkGraphicsPipelineCreateInfo basePipelineHandle(@NativeType(value="VkPipeline") long value) {
        VkGraphicsPipelineCreateInfo.nbasePipelineHandle(this.address(), value);
        return this;
    }

    public VkGraphicsPipelineCreateInfo basePipelineIndex(@NativeType(value="int32_t") int value) {
        VkGraphicsPipelineCreateInfo.nbasePipelineIndex(this.address(), value);
        return this;
    }

    public VkGraphicsPipelineCreateInfo set(int sType, long pNext, int flags, VkPipelineShaderStageCreateInfo.Buffer pStages, VkPipelineVertexInputStateCreateInfo pVertexInputState, VkPipelineInputAssemblyStateCreateInfo pInputAssemblyState, @Nullable VkPipelineTessellationStateCreateInfo pTessellationState, @Nullable VkPipelineViewportStateCreateInfo pViewportState, VkPipelineRasterizationStateCreateInfo pRasterizationState, @Nullable VkPipelineMultisampleStateCreateInfo pMultisampleState, @Nullable VkPipelineDepthStencilStateCreateInfo pDepthStencilState, @Nullable VkPipelineColorBlendStateCreateInfo pColorBlendState, @Nullable VkPipelineDynamicStateCreateInfo pDynamicState, long layout, long renderPass, int subpass, long basePipelineHandle, int basePipelineIndex) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.pStages(pStages);
        this.pVertexInputState(pVertexInputState);
        this.pInputAssemblyState(pInputAssemblyState);
        this.pTessellationState(pTessellationState);
        this.pViewportState(pViewportState);
        this.pRasterizationState(pRasterizationState);
        this.pMultisampleState(pMultisampleState);
        this.pDepthStencilState(pDepthStencilState);
        this.pColorBlendState(pColorBlendState);
        this.pDynamicState(pDynamicState);
        this.layout(layout);
        this.renderPass(renderPass);
        this.subpass(subpass);
        this.basePipelineHandle(basePipelineHandle);
        this.basePipelineIndex(basePipelineIndex);
        return this;
    }

    public VkGraphicsPipelineCreateInfo set(VkGraphicsPipelineCreateInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkGraphicsPipelineCreateInfo malloc() {
        return VkGraphicsPipelineCreateInfo.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkGraphicsPipelineCreateInfo calloc() {
        return VkGraphicsPipelineCreateInfo.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkGraphicsPipelineCreateInfo create() {
        return new VkGraphicsPipelineCreateInfo(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkGraphicsPipelineCreateInfo create(long address) {
        return new VkGraphicsPipelineCreateInfo(address, null);
    }

    @Nullable
    public static VkGraphicsPipelineCreateInfo createSafe(long address) {
        return address == 0L ? null : VkGraphicsPipelineCreateInfo.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkGraphicsPipelineCreateInfo.create(VkGraphicsPipelineCreateInfo.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkGraphicsPipelineCreateInfo.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkGraphicsPipelineCreateInfo.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkGraphicsPipelineCreateInfo.create(address, capacity);
    }

    public static VkGraphicsPipelineCreateInfo mallocStack() {
        return VkGraphicsPipelineCreateInfo.mallocStack(MemoryStack.stackGet());
    }

    public static VkGraphicsPipelineCreateInfo callocStack() {
        return VkGraphicsPipelineCreateInfo.callocStack(MemoryStack.stackGet());
    }

    public static VkGraphicsPipelineCreateInfo mallocStack(MemoryStack stack) {
        return VkGraphicsPipelineCreateInfo.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkGraphicsPipelineCreateInfo callocStack(MemoryStack stack) {
        return VkGraphicsPipelineCreateInfo.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkGraphicsPipelineCreateInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkGraphicsPipelineCreateInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkGraphicsPipelineCreateInfo.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkGraphicsPipelineCreateInfo.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nflags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FLAGS);
    }

    public static int nstageCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STAGECOUNT);
    }

    public static VkPipelineShaderStageCreateInfo.Buffer npStages(long struct) {
        return VkPipelineShaderStageCreateInfo.create(MemoryUtil.memGetAddress(struct + (long)PSTAGES), VkGraphicsPipelineCreateInfo.nstageCount(struct));
    }

    public static VkPipelineVertexInputStateCreateInfo npVertexInputState(long struct) {
        return VkPipelineVertexInputStateCreateInfo.create(MemoryUtil.memGetAddress(struct + (long)PVERTEXINPUTSTATE));
    }

    public static VkPipelineInputAssemblyStateCreateInfo npInputAssemblyState(long struct) {
        return VkPipelineInputAssemblyStateCreateInfo.create(MemoryUtil.memGetAddress(struct + (long)PINPUTASSEMBLYSTATE));
    }

    @Nullable
    public static VkPipelineTessellationStateCreateInfo npTessellationState(long struct) {
        return VkPipelineTessellationStateCreateInfo.createSafe(MemoryUtil.memGetAddress(struct + (long)PTESSELLATIONSTATE));
    }

    @Nullable
    public static VkPipelineViewportStateCreateInfo npViewportState(long struct) {
        return VkPipelineViewportStateCreateInfo.createSafe(MemoryUtil.memGetAddress(struct + (long)PVIEWPORTSTATE));
    }

    public static VkPipelineRasterizationStateCreateInfo npRasterizationState(long struct) {
        return VkPipelineRasterizationStateCreateInfo.create(MemoryUtil.memGetAddress(struct + (long)PRASTERIZATIONSTATE));
    }

    @Nullable
    public static VkPipelineMultisampleStateCreateInfo npMultisampleState(long struct) {
        return VkPipelineMultisampleStateCreateInfo.createSafe(MemoryUtil.memGetAddress(struct + (long)PMULTISAMPLESTATE));
    }

    @Nullable
    public static VkPipelineDepthStencilStateCreateInfo npDepthStencilState(long struct) {
        return VkPipelineDepthStencilStateCreateInfo.createSafe(MemoryUtil.memGetAddress(struct + (long)PDEPTHSTENCILSTATE));
    }

    @Nullable
    public static VkPipelineColorBlendStateCreateInfo npColorBlendState(long struct) {
        return VkPipelineColorBlendStateCreateInfo.createSafe(MemoryUtil.memGetAddress(struct + (long)PCOLORBLENDSTATE));
    }

    @Nullable
    public static VkPipelineDynamicStateCreateInfo npDynamicState(long struct) {
        return VkPipelineDynamicStateCreateInfo.createSafe(MemoryUtil.memGetAddress(struct + (long)PDYNAMICSTATE));
    }

    public static long nlayout(long struct) {
        return MemoryUtil.memGetLong(struct + (long)LAYOUT);
    }

    public static long nrenderPass(long struct) {
        return MemoryUtil.memGetLong(struct + (long)RENDERPASS);
    }

    public static int nsubpass(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SUBPASS);
    }

    public static long nbasePipelineHandle(long struct) {
        return MemoryUtil.memGetLong(struct + (long)BASEPIPELINEHANDLE);
    }

    public static int nbasePipelineIndex(long struct) {
        return MemoryUtil.memGetInt(struct + (long)BASEPIPELINEINDEX);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nflags(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FLAGS, value);
    }

    public static void nstageCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STAGECOUNT, value);
    }

    public static void npStages(long struct, VkPipelineShaderStageCreateInfo.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)PSTAGES, value.address());
        VkGraphicsPipelineCreateInfo.nstageCount(struct, value.remaining());
    }

    public static void npVertexInputState(long struct, VkPipelineVertexInputStateCreateInfo value) {
        MemoryUtil.memPutAddress(struct + (long)PVERTEXINPUTSTATE, value.address());
    }

    public static void npInputAssemblyState(long struct, VkPipelineInputAssemblyStateCreateInfo value) {
        MemoryUtil.memPutAddress(struct + (long)PINPUTASSEMBLYSTATE, value.address());
    }

    public static void npTessellationState(long struct, @Nullable VkPipelineTessellationStateCreateInfo value) {
        MemoryUtil.memPutAddress(struct + (long)PTESSELLATIONSTATE, MemoryUtil.memAddressSafe(value));
    }

    public static void npViewportState(long struct, @Nullable VkPipelineViewportStateCreateInfo value) {
        MemoryUtil.memPutAddress(struct + (long)PVIEWPORTSTATE, MemoryUtil.memAddressSafe(value));
    }

    public static void npRasterizationState(long struct, VkPipelineRasterizationStateCreateInfo value) {
        MemoryUtil.memPutAddress(struct + (long)PRASTERIZATIONSTATE, value.address());
    }

    public static void npMultisampleState(long struct, @Nullable VkPipelineMultisampleStateCreateInfo value) {
        MemoryUtil.memPutAddress(struct + (long)PMULTISAMPLESTATE, MemoryUtil.memAddressSafe(value));
    }

    public static void npDepthStencilState(long struct, @Nullable VkPipelineDepthStencilStateCreateInfo value) {
        MemoryUtil.memPutAddress(struct + (long)PDEPTHSTENCILSTATE, MemoryUtil.memAddressSafe(value));
    }

    public static void npColorBlendState(long struct, @Nullable VkPipelineColorBlendStateCreateInfo value) {
        MemoryUtil.memPutAddress(struct + (long)PCOLORBLENDSTATE, MemoryUtil.memAddressSafe(value));
    }

    public static void npDynamicState(long struct, @Nullable VkPipelineDynamicStateCreateInfo value) {
        MemoryUtil.memPutAddress(struct + (long)PDYNAMICSTATE, MemoryUtil.memAddressSafe(value));
    }

    public static void nlayout(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)LAYOUT, value);
    }

    public static void nrenderPass(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)RENDERPASS, value);
    }

    public static void nsubpass(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SUBPASS, value);
    }

    public static void nbasePipelineHandle(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)BASEPIPELINEHANDLE, value);
    }

    public static void nbasePipelineIndex(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)BASEPIPELINEINDEX, value);
    }

    public static void validate(long struct) {
        long pDynamicState;
        int stageCount = VkGraphicsPipelineCreateInfo.nstageCount(struct);
        long pStages = MemoryUtil.memGetAddress(struct + (long)PSTAGES);
        Checks.check(pStages);
        VkPipelineShaderStageCreateInfo.validate(pStages, stageCount);
        long pVertexInputState = MemoryUtil.memGetAddress(struct + (long)PVERTEXINPUTSTATE);
        Checks.check(pVertexInputState);
        VkPipelineVertexInputStateCreateInfo.validate(pVertexInputState);
        Checks.check(MemoryUtil.memGetAddress(struct + (long)PINPUTASSEMBLYSTATE));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)PRASTERIZATIONSTATE));
        long pColorBlendState = MemoryUtil.memGetAddress(struct + (long)PCOLORBLENDSTATE);
        if (pColorBlendState != 0L) {
            VkPipelineColorBlendStateCreateInfo.validate(pColorBlendState);
        }
        if ((pDynamicState = MemoryUtil.memGetAddress(struct + (long)PDYNAMICSTATE)) != 0L) {
            VkPipelineDynamicStateCreateInfo.validate(pDynamicState);
        }
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            VkGraphicsPipelineCreateInfo.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = VkGraphicsPipelineCreateInfo.__struct(VkGraphicsPipelineCreateInfo.__member(4), VkGraphicsPipelineCreateInfo.__member(POINTER_SIZE), VkGraphicsPipelineCreateInfo.__member(4), VkGraphicsPipelineCreateInfo.__member(4), VkGraphicsPipelineCreateInfo.__member(POINTER_SIZE), VkGraphicsPipelineCreateInfo.__member(POINTER_SIZE), VkGraphicsPipelineCreateInfo.__member(POINTER_SIZE), VkGraphicsPipelineCreateInfo.__member(POINTER_SIZE), VkGraphicsPipelineCreateInfo.__member(POINTER_SIZE), VkGraphicsPipelineCreateInfo.__member(POINTER_SIZE), VkGraphicsPipelineCreateInfo.__member(POINTER_SIZE), VkGraphicsPipelineCreateInfo.__member(POINTER_SIZE), VkGraphicsPipelineCreateInfo.__member(POINTER_SIZE), VkGraphicsPipelineCreateInfo.__member(POINTER_SIZE), VkGraphicsPipelineCreateInfo.__member(8), VkGraphicsPipelineCreateInfo.__member(8), VkGraphicsPipelineCreateInfo.__member(4), VkGraphicsPipelineCreateInfo.__member(8), VkGraphicsPipelineCreateInfo.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        STAGECOUNT = layout.offsetof(3);
        PSTAGES = layout.offsetof(4);
        PVERTEXINPUTSTATE = layout.offsetof(5);
        PINPUTASSEMBLYSTATE = layout.offsetof(6);
        PTESSELLATIONSTATE = layout.offsetof(7);
        PVIEWPORTSTATE = layout.offsetof(8);
        PRASTERIZATIONSTATE = layout.offsetof(9);
        PMULTISAMPLESTATE = layout.offsetof(10);
        PDEPTHSTENCILSTATE = layout.offsetof(11);
        PCOLORBLENDSTATE = layout.offsetof(12);
        PDYNAMICSTATE = layout.offsetof(13);
        LAYOUT = layout.offsetof(14);
        RENDERPASS = layout.offsetof(15);
        SUBPASS = layout.offsetof(16);
        BASEPIPELINEHANDLE = layout.offsetof(17);
        BASEPIPELINEINDEX = layout.offsetof(18);
    }

    public static class Buffer
    extends StructBuffer<VkGraphicsPipelineCreateInfo, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkGraphicsPipelineCreateInfo newInstance(long address) {
            return new VkGraphicsPipelineCreateInfo(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkGraphicsPipelineCreateInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkGraphicsPipelineCreateInfo.npNext(this.address());
        }

        @NativeType(value="VkPipelineCreateFlags")
        public int flags() {
            return VkGraphicsPipelineCreateInfo.nflags(this.address());
        }

        @NativeType(value="uint32_t")
        public int stageCount() {
            return VkGraphicsPipelineCreateInfo.nstageCount(this.address());
        }

        @NativeType(value="VkPipelineShaderStageCreateInfo const *")
        public VkPipelineShaderStageCreateInfo.Buffer pStages() {
            return VkGraphicsPipelineCreateInfo.npStages(this.address());
        }

        @NativeType(value="VkPipelineVertexInputStateCreateInfo const *")
        public VkPipelineVertexInputStateCreateInfo pVertexInputState() {
            return VkGraphicsPipelineCreateInfo.npVertexInputState(this.address());
        }

        @NativeType(value="VkPipelineInputAssemblyStateCreateInfo const *")
        public VkPipelineInputAssemblyStateCreateInfo pInputAssemblyState() {
            return VkGraphicsPipelineCreateInfo.npInputAssemblyState(this.address());
        }

        @Nullable
        @NativeType(value="VkPipelineTessellationStateCreateInfo const *")
        public VkPipelineTessellationStateCreateInfo pTessellationState() {
            return VkGraphicsPipelineCreateInfo.npTessellationState(this.address());
        }

        @Nullable
        @NativeType(value="VkPipelineViewportStateCreateInfo const *")
        public VkPipelineViewportStateCreateInfo pViewportState() {
            return VkGraphicsPipelineCreateInfo.npViewportState(this.address());
        }

        @NativeType(value="VkPipelineRasterizationStateCreateInfo const *")
        public VkPipelineRasterizationStateCreateInfo pRasterizationState() {
            return VkGraphicsPipelineCreateInfo.npRasterizationState(this.address());
        }

        @Nullable
        @NativeType(value="VkPipelineMultisampleStateCreateInfo const *")
        public VkPipelineMultisampleStateCreateInfo pMultisampleState() {
            return VkGraphicsPipelineCreateInfo.npMultisampleState(this.address());
        }

        @Nullable
        @NativeType(value="VkPipelineDepthStencilStateCreateInfo const *")
        public VkPipelineDepthStencilStateCreateInfo pDepthStencilState() {
            return VkGraphicsPipelineCreateInfo.npDepthStencilState(this.address());
        }

        @Nullable
        @NativeType(value="VkPipelineColorBlendStateCreateInfo const *")
        public VkPipelineColorBlendStateCreateInfo pColorBlendState() {
            return VkGraphicsPipelineCreateInfo.npColorBlendState(this.address());
        }

        @Nullable
        @NativeType(value="VkPipelineDynamicStateCreateInfo const *")
        public VkPipelineDynamicStateCreateInfo pDynamicState() {
            return VkGraphicsPipelineCreateInfo.npDynamicState(this.address());
        }

        @NativeType(value="VkPipelineLayout")
        public long layout() {
            return VkGraphicsPipelineCreateInfo.nlayout(this.address());
        }

        @NativeType(value="VkRenderPass")
        public long renderPass() {
            return VkGraphicsPipelineCreateInfo.nrenderPass(this.address());
        }

        @NativeType(value="uint32_t")
        public int subpass() {
            return VkGraphicsPipelineCreateInfo.nsubpass(this.address());
        }

        @NativeType(value="VkPipeline")
        public long basePipelineHandle() {
            return VkGraphicsPipelineCreateInfo.nbasePipelineHandle(this.address());
        }

        @NativeType(value="int32_t")
        public int basePipelineIndex() {
            return VkGraphicsPipelineCreateInfo.nbasePipelineIndex(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkGraphicsPipelineCreateInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkGraphicsPipelineCreateInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="VkPipelineCreateFlags") int value) {
            VkGraphicsPipelineCreateInfo.nflags(this.address(), value);
            return this;
        }

        public Buffer pStages(@NativeType(value="VkPipelineShaderStageCreateInfo const *") VkPipelineShaderStageCreateInfo.Buffer value) {
            VkGraphicsPipelineCreateInfo.npStages(this.address(), value);
            return this;
        }

        public Buffer pVertexInputState(@NativeType(value="VkPipelineVertexInputStateCreateInfo const *") VkPipelineVertexInputStateCreateInfo value) {
            VkGraphicsPipelineCreateInfo.npVertexInputState(this.address(), value);
            return this;
        }

        public Buffer pInputAssemblyState(@NativeType(value="VkPipelineInputAssemblyStateCreateInfo const *") VkPipelineInputAssemblyStateCreateInfo value) {
            VkGraphicsPipelineCreateInfo.npInputAssemblyState(this.address(), value);
            return this;
        }

        public Buffer pTessellationState(@Nullable @NativeType(value="VkPipelineTessellationStateCreateInfo const *") VkPipelineTessellationStateCreateInfo value) {
            VkGraphicsPipelineCreateInfo.npTessellationState(this.address(), value);
            return this;
        }

        public Buffer pViewportState(@Nullable @NativeType(value="VkPipelineViewportStateCreateInfo const *") VkPipelineViewportStateCreateInfo value) {
            VkGraphicsPipelineCreateInfo.npViewportState(this.address(), value);
            return this;
        }

        public Buffer pRasterizationState(@NativeType(value="VkPipelineRasterizationStateCreateInfo const *") VkPipelineRasterizationStateCreateInfo value) {
            VkGraphicsPipelineCreateInfo.npRasterizationState(this.address(), value);
            return this;
        }

        public Buffer pMultisampleState(@Nullable @NativeType(value="VkPipelineMultisampleStateCreateInfo const *") VkPipelineMultisampleStateCreateInfo value) {
            VkGraphicsPipelineCreateInfo.npMultisampleState(this.address(), value);
            return this;
        }

        public Buffer pDepthStencilState(@Nullable @NativeType(value="VkPipelineDepthStencilStateCreateInfo const *") VkPipelineDepthStencilStateCreateInfo value) {
            VkGraphicsPipelineCreateInfo.npDepthStencilState(this.address(), value);
            return this;
        }

        public Buffer pColorBlendState(@Nullable @NativeType(value="VkPipelineColorBlendStateCreateInfo const *") VkPipelineColorBlendStateCreateInfo value) {
            VkGraphicsPipelineCreateInfo.npColorBlendState(this.address(), value);
            return this;
        }

        public Buffer pDynamicState(@Nullable @NativeType(value="VkPipelineDynamicStateCreateInfo const *") VkPipelineDynamicStateCreateInfo value) {
            VkGraphicsPipelineCreateInfo.npDynamicState(this.address(), value);
            return this;
        }

        public Buffer layout(@NativeType(value="VkPipelineLayout") long value) {
            VkGraphicsPipelineCreateInfo.nlayout(this.address(), value);
            return this;
        }

        public Buffer renderPass(@NativeType(value="VkRenderPass") long value) {
            VkGraphicsPipelineCreateInfo.nrenderPass(this.address(), value);
            return this;
        }

        public Buffer subpass(@NativeType(value="uint32_t") int value) {
            VkGraphicsPipelineCreateInfo.nsubpass(this.address(), value);
            return this;
        }

        public Buffer basePipelineHandle(@NativeType(value="VkPipeline") long value) {
            VkGraphicsPipelineCreateInfo.nbasePipelineHandle(this.address(), value);
            return this;
        }

        public Buffer basePipelineIndex(@NativeType(value="int32_t") int value) {
            VkGraphicsPipelineCreateInfo.nbasePipelineIndex(this.address(), value);
            return this;
        }
    }
}

